/*
 * PACT.C - do makes properly
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 * include "cpyright.h"
 *
 */

#include <stdio.h>
#include <string.h>

#define MAXLINE 255

static char
 cwd[MAXLINE],
 makefile[MAXLINE];

#ifdef STUPID_MAKE
static int
 was_there = 0;
#endif

int system();
char *getcwd();
void (*signal())();

static int cleanup();
static void handler();

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

main(c, v)
   int c;
   char **v;
   {int i, status, keep;
    FILE *mk, *in;
    char cmnd[MAXLINE], devdir[MAXLINE], *pmname;
    static char *default_pmname = "pre-Make";

    signal(2, handler);

    pmname = default_pmname;
    keep   = 0;

    for (i = 1; i < c; i++)
        {if (v[i][0] == '-')
            {switch (v[i][1])
                {case 'f' :
		      pmname = v[++i];
		      break;
	         case 'n' :
		      keep = 1;
		      break;
	         case 'v' :
		      printf("%s\n", VERSION);
		      exit(0);
		      break;};}
	 else
	    break;};

    in = fopen(pmname, "r");
    if (in == NULL)
       return(0);

#ifdef PUB
    sprintf(devdir, "%s", PUB);
#else
    sprintf(devdir, "%s/dev/%s", ROOT, SYSTEM);
#endif

/* find the current directory */
    if (getcwd(cwd, MAXLINE) == NULL)
       {fprintf(stderr, "ERROR: CAN'T GET CURRENT DIRECTORY\n");
        return(1);};

/* make the temporary file name */
    tmpnam(makefile);
    mk = fopen(makefile, "w");

/* write the temporary Makefile */
    i = strlen(cwd) - 7;
    if (strcmp(cwd+i, "manager") == 0)
       {fprintf(mk, "System = %s\n", SYSTEM);
	while (fgets(cmnd, MAXLINE, in) != NULL)
	   fprintf(mk, "%s", cmnd);}

    else
       {fprintf(mk, "include %s/include/make-def\n", devdir);
	while (fgets(cmnd, MAXLINE, in) != NULL)
	   fprintf(mk, "%s", cmnd);    
	fprintf(mk, "include %s/include/make-macros\n", devdir);};

    fclose(in);
    fclose(mk);

#ifdef STUPID_MAKE
    was_there = ((in = fopen("pact", "r")) != NULL);
    if (was_there)
       fclose(in);
    else
       {sprintf(cmnd, "cp %s/bin/pact .", devdir);
	system(cmnd);
	system("chmod a+x pact");};
#endif
    
/* make the command to invoke make */

#ifdef USE_GNU_MAKE
    sprintf(cmnd, "make --no-print-directory -f %s", makefile);
#else
    sprintf(cmnd, "make -f %s", makefile);
#endif
    for (i = 1; i < c; i++)
        {if (strcmp(v[i], "-f") == 0)
            {i++;
	     continue;};
	 strcat(cmnd, " ");
	 strcat(cmnd, v[i]);};

/* do the make */
    status = system(cmnd);   

    cleanup(keep);

    return((status == 0) ? 0 : 1);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* CLEANUP - remove temporary files of all sorts */

static int cleanup(keep)
   int keep;
   {char cmnd[MAXLINE];

#ifdef STUPID_MAKE
    if (!was_there)
       unlink("pact");
#endif

    if (!keep)
       remove(makefile);
    else
       {sprintf(cmnd, "mv %s make.tmp", makefile);
	system(cmnd);};

    return(1);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* HANDLER - handle signals gracefully */

static void handler(sig)
   int sig;
   {
    fprintf(stderr, "PACT exiting on signal %d\n", sig);
    fprintf(stdout, "PACT exiting with signal %d\n", sig);

#ifdef STUPID_MAKE
    was_there = 0;
#endif

    cleanup(0);

    exit(sig);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
