/*
 * Copyright (c) 1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/* FLASK */

#ifndef _PRVAVTAB_H_
#define _PRVAVTAB_H_

#include "hashtab.h"
#include "avtab.h"


typedef struct
{
    security_id_t source_sid;
    security_id_t target_sid;
    unsigned int target_class;
} prvav_key_t;


typedef struct
{
    access_vector_t allowed;
    unsigned unused;
} prvav_datum_t;


typedef struct 
{
    hashtab_t table;		/* hash table (keyed on an prvav_key_t) */
    unsigned int nel;		/* number of elements */
} prvavtab_t;

int prvavtab_init(prvavtab_t *);

#endif _PRVAVTAB_H_

/* FLASK */
