/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/* Modified from FreeBSD 2.1 sys/i386/boot/netboot */
/**************************************************************************
NETBOOT -  BOOTP/TFTP Bootstrap Program

Author: Martin Renters
  Date: Dec/93

**************************************************************************/

#ifndef __ETHER_H_INCLUDED__
#define __ETHER_H_INCLUDED__

#include <oskit/net/ether.h>

void _dumparptable(char *file, int line);
#define dumparptable() _dumparptable(__FILE__, __LINE__)
extern char ether_bcast[];

/*
 * ARP
 */

struct arptable_t {
	unsigned long ipaddr;
	unsigned char node[6];
};

struct arprequest {
	unsigned short hwtype;
	unsigned short protocol;
	char hwlen;
	char protolen;
	unsigned short opcode;
	char shwaddr[6];
	char sipaddr[4];
	char thwaddr[6];
	char tipaddr[4];
};

#define ARPOP_REQUEST	1
#define ARPOP_REPLY	2

#define ARP_CLIENT	0
#define ARP_SERVER	1
#define ARP_GATEWAY	2
#define ARP_NS		3
#define ARP_ROOTSERVER	4
#define ARP_SWAPSERVER	5
#define MAX_ARP		ARP_SWAPSERVER+1

extern struct arptable_t arptable[];

#endif /* __ETHER_H_INCLUDED__ */
