/*
 * Copyright (c) 1995,1997-1998 University of Utah and the Flux Group.
 * 
 * This file is part of the OSKit Linux Boot Loader, which is free software,
 * also known as "open source;" you can redistribute it and/or modify it under
 * the terms of the GNU General Public License (GPL), version 2, as published
 * by the Free Software Foundation (FSF).
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include <linux/config.h>
#include <oskit/x86/asm.h>

#define SETUPSECS	4			/* nr of setup-sectors */
#define SYSSIZE		DEF_SYSSIZE

/* ROOT_DEV & SWAP_DEV are now written by "build". */
#define ROOT_DEV 0
#define SWAP_DEV 0
#ifndef SVGA_MODE
#define SVGA_MODE ASK_VGA
#endif
#ifndef RAMDISK
#define RAMDISK 0
#endif
#ifndef CONFIG_ROOT_RDONLY
#define CONFIG_ROOT_RDONLY 0
#endif

#define INITSEG 0x07c0			/* initial boot segment */
	
	.text
	.code16
	.globl	EXT(_start)
LEXT(_start)
	/* set up es, so we can get at our string */
	mov	$INITSEG,%ax
	mov	%ax,%es

	/* turn off the floppy, which will otherwise continue spinning */
	mov	$0x3f2, %dx
	xor	%al, %al
	outb	%al, %dx
	
	/* read cursor pos; afterwards dh = row, dl = column */
        xor     %bh, %bh		/* page 0 */
        mov     $3, %ah			
        int     $0x10

	/* print a (semi-)informative message */	
	mov	$emsg, %cx		/* length of the string goes in cx */
	sub	$msg, %cx
        mov     $7, %bx			/* page 0, attribute 7 (normal) */
        mov     $msg, %bp
        mov     $0x1301, %ax		/* write string, move cursor */
        int     $0x10

	/* just sit twiddling our thumbs until the user reboots */
	hlt				

msg:
	.ascii "\n\rSorry, linuxboot kernels cannot be booted directly!\n\rYou need to use a bootloader like lilo instead.\n\r"
emsg:	
	
	.org 497
setup_sects:
	.byte SETUPSECS
root_flags:
	.word CONFIG_ROOT_RDONLY
syssize:
	.word SYSSIZE
swap_dev:
	.word SWAP_DEV
ram_size:
	.word RAMDISK
vid_mode:
	.word SVGA_MODE
root_dev:
	.word ROOT_DEV
boot_flag:
	.word 0xAA55
