
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: polyeseq.m,v 1.2 1999/07/06 19:48:12 stes Exp $
 */

#include "cakit.h"

@implementation exppolscalar_sequence
- _setUpContent:aPolynomial
{
  assert ([aPolynomial isExpanded]);
  content = aPolynomial;
  eachMonomial = [aPolynomial eachMonomial];
  return self;
}

+ content:aPolynomial
{
  return [[super new] _setUpContent:aPolynomial];
}

- toFirst
{
  [eachMonomial toFirst];
  return self;
}

- toLast
{
  [eachMonomial toLast];
  return self;
}

- (unsigned) size
{
  return [eachMonomial size];
}

- (BOOL) isEmpty
{
  return [eachMonomial isEmpty];
}

- toElementAt:(int)i
{
  [eachMonomial toElementAt:i];
  return self;
}

- next
{
  id next = [eachMonomial next];
  return (next) ? [next scalar] : nil;
}

- previous
{
  id previous = [eachMonomial previous];
  return (previous) ? [previous scalar] : nil;
}

@end
 
