/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonGroup;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JRadioButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.PrintJob;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class PrintDlg
extends JDialog
implements ActionListener,
ItemListener {
    private ClogDisplay parent;
    private JFrame printFrame;
    private MyTextField widthTxField;
    private MyTextField heightTxField;
    private JRadioButton cmRB;
    private JRadioButton mmRB;
    private JRadioButton inRB;
    private JRadioButton ptRB;
    private double nonPrintGap;
    private int finalWidth;
    private int finalHeight;
    private int maxPageW;
    private int maxPageH;
    private int dpi;
    private Dimension pageDim;
    private PrintJob pjob;

    public PrintDlg(ClogDisplay clogDisplay) {
        super((Frame)((Object)clogDisplay), "Print Options", true);
        this.parent = clogDisplay;
        this.setup();
    }

    private void setup() {
        this.setupPanel();
    }

    private void setupPanel() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        container.add((Component)new JLabel("width"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.widthTxField = new MyTextField("", 10, true);
        container.add((Component)((Object)this.widthTxField), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        container.add((Component)new JLabel("height"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.heightTxField = new MyTextField("", 10, true);
        container.add((Component)((Object)this.heightTxField), gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.cmRB = new JRadioButton("cm", false);
        container.add((Component)this.cmRB, gridBagConstraints);
        this.cmRB.addItemListener((ItemListener)this);
        buttonGroup.add((AbstractButton)this.cmRB);
        gridBagConstraints.gridy = 1;
        this.mmRB = new JRadioButton("mm", false);
        container.add((Component)this.mmRB, gridBagConstraints);
        this.mmRB.addItemListener((ItemListener)this);
        buttonGroup.add((AbstractButton)this.mmRB);
        gridBagConstraints.gridy = 2;
        this.inRB = new JRadioButton("inches", false);
        container.add((Component)this.inRB, gridBagConstraints);
        this.inRB.addItemListener((ItemListener)this);
        buttonGroup.add((AbstractButton)this.inRB);
        gridBagConstraints.gridy = 3;
        this.ptRB = new JRadioButton("points", false);
        container.add((Component)this.ptRB, gridBagConstraints);
        this.ptRB.addItemListener((ItemListener)this);
        buttonGroup.add((AbstractButton)this.ptRB);
        gridBagConstraints.gridx = 0;
        container.add((Component)((Object)new MyButton("Ok", this)), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ((Window)((Object)this)).pack();
        ((Component)((Object)this)).setSize(((Container)((Object)this)).getMinimumSize());
        ((Dialog)((Object)this)).setResizable(false);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        Object object = itemEvent.getItem();
        if (object == this.mmRB) {
            this.width(this.toMm(this.maxPageW));
            this.height(this.toMm(this.maxPageH));
            return;
        }
        if (object == this.cmRB) {
            this.width(this.toCm(this.maxPageW));
            this.height(this.toCm(this.maxPageH));
            return;
        }
        if (object == this.inRB) {
            this.width(this.toInches(this.maxPageW));
            this.height(this.toInches(this.maxPageH));
            return;
        }
        if (object == this.ptRB) {
            this.width(this.maxPageW);
            this.height(this.maxPageH);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Ok")) {
            Graphics graphics;
            double d;
            double d2;
            ((Component)((Object)this)).setVisible(false);
            double d3 = new Double(this.widthTxField.getText());
            double d4 = new Double(this.heightTxField.getText());
            if (this.cmRB.isSelected()) {
                d2 = this.fromCm(d3);
                d = this.fromCm(d4);
            } else if (this.mmRB.isSelected()) {
                d2 = this.fromMm(d3);
                d = this.fromMm(d4);
            } else if (this.inRB.isSelected()) {
                d2 = this.fromInches(d3);
                d = this.fromInches(d4);
            } else {
                d2 = d3;
                d = d4;
            }
            this.finalWidth = (int)Math.rint(d2);
            this.finalHeight = (int)Math.rint(d);
            if (this.finalWidth > this.maxPageW) {
                JOptionPane.showMessageDialog(null, (Object)"Width >  Max Print Width. Printing may not work.", (String)"width > max print width", (int)2);
            }
            if (this.finalHeight > this.maxPageH) {
                JOptionPane.showMessageDialog(null, (Object)"Height >  Max Print Height. Printing may not work.", (String)"height > max print height", (int)2);
            }
            if ((graphics = this.pjob.getGraphics()) == null) {
                return;
            }
            graphics.setFont(this.parent.printFont);
            FontMetrics fontMetrics = ((Window)((Object)this)).getToolkit().getFontMetrics(graphics.getFont());
            int n = (int)Math.rint(this.nonPrintGap + (double)(this.maxPageW - this.finalWidth) / 2.0);
            int n2 = (int)Math.rint(this.nonPrintGap + (double)(this.maxPageH - this.finalHeight) / 2.0);
            graphics.setColor(Color.black);
            graphics.drawString("Logfile:" + this.parent.parent.logFileName, n, n2 + fontMetrics.getHeight() - fontMetrics.getDescent() - 1);
            int n3 = this.finalWidth;
            int n4 = this.finalHeight - fontMetrics.getHeight();
            if (this.printFrame instanceof ClogDisplay) {
                int n5 = n;
                int n6 = n2 + fontMetrics.getHeight();
                int n7 = this.parent.stateButtons.print(graphics, n5, n6, n3, n4);
                int n8 = n;
                int n9 = n6 + n7;
                new PrintCanvas(this.parent.canvas, graphics, n8, n9, n3, n4 -= n7, this.dpi);
            } else if (this.printFrame instanceof Histwin) {
                Histwin histwin = (Histwin)this.printFrame;
                int n10 = n;
                int n11 = n2 + fontMetrics.getHeight();
                int n12 = histwin.canvas.print(graphics, n10, n11, n3, n4);
                int n13 = n;
                int n14 = n11 + n12;
                new PHistCanvas(histwin.canvas, graphics, n13, n14, n3, n4 -= n12, this.dpi);
            }
            graphics.dispose();
            this.pjob.end();
        }
    }

    void reset(PrintJob printJob, JFrame jFrame) {
        this.pjob = printJob;
        this.printFrame = jFrame;
        this.pageDim = this.pjob.getPageDimension();
        this.dpi = ((Window)((Object)this)).getToolkit().getScreenResolution();
        this.nonPrintGap = 0.25 * (double)this.dpi;
        this.maxPageW = this.pageDim.width - (int)Math.rint(2.0 * this.nonPrintGap);
        this.maxPageH = this.pageDim.height - (int)Math.rint(2.0 * this.nonPrintGap);
        this.inRB.setSelected(true);
        this.width(this.toInches(this.maxPageW));
        this.height(this.toInches(this.maxPageH));
        ((Component)((Object)this)).setVisible(true);
    }

    private void width(double d) {
        this.widthTxField.setText(Float.toString((float)d));
    }

    private void height(double d) {
        this.heightTxField.setText(Float.toString((float)d));
    }

    private double toInches(double d) {
        return d / (double)this.dpi;
    }

    private double toCm(double d) {
        return this.toInches(d) * 2.54;
    }

    private double toMm(double d) {
        return this.toCm(d) * 10.0;
    }

    private double fromInches(double d) {
        return d * (double)this.dpi;
    }

    private double fromCm(double d) {
        return this.fromInches(d) / 2.54;
    }

    private double fromMm(double d) {
        return this.fromCm(d) / 10.0;
    }
}

