/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.JRadioButtonMenuItem;
import com.sun.java.swing.JSlider;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Vector;

public class HistCanvas
extends JComponent
implements ComponentListener,
AdjustmentListener,
ActionListener,
ChangeListener {
    public Histwin parent;
    CLOG_STATE stateDef;
    Vector stateVector;
    double xDensity;
    double yDensity;
    double leastT;
    double maxT;
    double begT;
    double endT;
    int _xPix;
    int _yPix;
    int widthCan;
    int heightCan;
    Color canBColor = Color.black;
    public HistImage view;
    boolean setupComplete = false;
    public int lineSize;
    public int dpi;
    public int fDescent;
    public FontMetrics fm;
    int numBins;
    int maxNumBins;
    Font imgFont;
    private int ty;
    private int eff_yPix;
    public int topGap;
    private double zoomFac = 2.0;
    private int hbarMax;
    private int hbarVal;
    private int hbarVis;
    private int hPixMax;
    private int regionsCt;
    ActionListener tAL = new 1();
    ActionListener bAL = new 2();

    public HistCanvas(Histwin histwin) {
        this.parent = histwin;
    }

    void init() {
        this.waitCursor();
        this.setupData();
        this.adjustCanvasStuff();
        this.ResizeCanvas();
        this.normalCursor();
    }

    private void setupData() {
        this.stateDef = this.parent.stateDef;
        this.stateVector = this.stateDef.stateVector;
        this.sortLen();
        this.leastT = ((Info)this.stateVector.elementAt((int)0)).lenT;
        this.maxT = ((Info)this.stateVector.elementAt((int)(this.stateVector.size() - 1))).lenT;
        if (this.leastT == this.maxT) {
            this.maxT += 0.005;
        }
        this.begT = this.leastT;
        this.endT = this.maxT;
        this.numBins = 24;
        this.maxNumBins = 200;
        ((Component)((Object)this)).addComponentListener(this);
        this.parent.cursorField.setText("0.0");
        this.parent.stateNameLabel.setText("State: " + this.stateDef.description.desc);
        this.parent.numInstField.setText(Integer.toString(this.stateVector.size()));
        this.parent.leastLenField.setText(new Float(this.leastT).toString());
        this.parent.maxLenField.setText(new Float(this.maxT).toString());
        this.parent.numBinsField.setText(Integer.toString(this.numBins));
        this.parent.maxNumBinsField.setText(Integer.toString(this.maxNumBins));
        this.parent.binSlider.setOrientation(0);
        this.parent.binSlider.setMaximum(this.maxNumBins);
        this.parent.binSlider.setMinimum(1);
        this.parent.binSlider.setValue(this.numBins);
    }

    private void adjustCanvasStuff() {
        this.imgFont = new Font("Serif", 0, 10);
        ((Component)((Object)this)).setFont(this.imgFont);
        this.fm = ((Component)((Object)this)).getToolkit().getFontMetrics(this.imgFont);
        this.lineSize = this.fm.getHeight();
        this.fDescent = this.fm.getDescent();
        this.dpi = ((Component)((Object)this)).getToolkit().getScreenResolution();
        ((Component)((Object)this)).setBackground(this.canBColor);
        ((Component)((Object)this)).enableEvents(48L);
    }

    public void paintComponent(Graphics graphics) {
        graphics.drawImage(this.view.img, 0, 0, (ImageObserver)((Object)this));
    }

    private void setupImg() {
        if (this.view != null) {
            this.view.kill();
        }
        Image image = ((Component)((Object)this)).createImage(this._xPix, this._yPix);
        this.view = new HistImage(image, this._xPix, this._yPix, this);
    }

    int getEvtXCord(double d) {
        double d2 = d * this.xDensity;
        return (int)Math.rint(d2);
    }

    double getTime(int n) {
        double d = 1.0 / this.xDensity * (double)n;
        return d;
    }

    int getW(double d, double d2) {
        double d3 = (d2 - d) * this.xDensity;
        return (int)Math.rint(d3);
    }

    int getHistHeight(int n) {
        return (int)Math.rint(this.yDensity * (double)n);
    }

    private void sortLen() {
        ROUTINES.QuickSort(this.stateVector, 0, this.stateVector.size() - 1);
    }

    private void reFit() {
        this.waitCursor();
        this.yDensity = (double)(this._yPix - 3 * this.lineSize - this.topGap) / (double)this.view.highestCt;
        this.eff_yPix = (int)Math.rint(this.yDensity * (double)this.stateVector.size());
        this.view.drawRegion(this.begT, this.endT);
        ((Component)((Object)this)).repaint();
        this.normalCursor();
    }

    private void changeNumBins(int n) {
        this.numBins = n;
        this.view.drawStuff();
        ((Component)((Object)this)).repaint();
    }

    private void markBlink() {
        Enumeration enumeration = this.stateVector.elements();
        while (enumeration.hasMoreElements()) {
            Info info = (Info)enumeration.nextElement();
            if (!(info.lenT >= this.begT) || !(info.lenT <= this.endT)) continue;
            info.blink = true;
        }
    }

    private void unmarkBlink(double d, double d2) {
        Enumeration enumeration = this.stateVector.elements();
        while (enumeration.hasMoreElements()) {
            Info info = (Info)enumeration.nextElement();
            if (!(info.lenT >= this.begT) || !(info.lenT <= this.endT)) continue;
            info.blink = false;
        }
    }

    void unmarkBlinkAll() {
        Enumeration enumeration = this.stateVector.elements();
        while (enumeration.hasMoreElements()) {
            ((Info)enumeration.nextElement()).blink = false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = actionEvent.getActionCommand();
        if (string.equals("Change numBins")) {
            try {
                n = Integer.parseInt(this.parent.numBinsField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new ErrorDiag((Component)((Object)this), "Valid integer required");
                this.parent.numBinsField.setText(Integer.toString(this.parent.binSlider.getValue()));
                return;
            }
            if (n < 1 || n > this.maxNumBins) {
                new ErrorDiag(null, "Value must be >= 1 and =< " + this.maxNumBins);
                this.parent.numBinsField.setText(Integer.toString(this.parent.binSlider.getValue()));
                return;
            }
            this.parent.binSlider.setValue(n);
            this.changeNumBins(n);
        } else if (string.equals("Change maxNumBins")) {
            try {
                n = Integer.parseInt(this.parent.maxNumBinsField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new ErrorDiag((Component)((Object)this), "Valid integer required");
                this.parent.maxNumBinsField.setText(Integer.toString(this.maxNumBins));
                return;
            }
            if (n < 1) {
                new ErrorDiag((Component)((Object)this), "Value must be >= 1");
                this.parent.maxNumBinsField.setText(Integer.toString(this.maxNumBins));
                return;
            }
            this.maxNumBins = n;
            this.parent.binSlider.setMaximum(n);
            int n2 = this.parent.binSlider.getValue();
            if (n2 > n) {
                n2 = n;
            }
            this.parent.binSlider.setValue(n2);
        }
        if (string.equals("Change Start Len")) {
            double d;
            try {
                d = Double.valueOf(this.parent.startLenField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new ErrorDiag((Component)((Object)this), "Valid floating point value required");
                this.parent.startLenField.setText(new Float(this.begT).toString());
                return;
            }
            if (d < this.leastT || d >= this.endT) {
                new ErrorDiag((Component)((Object)this), "Value must be >= " + new Float(this.leastT).toString() + " and < " + new Float(this.endT).toString());
                this.parent.startLenField.setText(new Float(this.begT).toString());
                return;
            }
            this.begT = d;
            this.xDensity = (double)this._xPix / (this.endT - this.begT);
            this.view.drawRegion(this.begT, this.endT);
            ((Component)((Object)this)).repaint();
            this.calcHPixMax();
            this.calcHbarMax();
            this.calcHbarVal();
            this.setHbarValues();
            return;
        }
        if (string.equals("Change End Len")) {
            double d;
            try {
                d = Double.valueOf(this.parent.endLenField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new ErrorDiag((Component)((Object)this), "Valid floating point value required");
                this.parent.endLenField.setText(new Float(this.endT).toString());
                return;
            }
            if (d <= this.begT || d > this.maxT) {
                new ErrorDiag((Component)((Object)this), "Value must be > " + new Float(this.begT).toString() + " and =< " + new Float(this.maxT).toString());
                this.parent.endLenField.setText(new Float(this.endT).toString());
                return;
            }
            this.endT = d;
            this.xDensity = (double)this._xPix / (this.endT - this.begT);
            this.view.drawRegion(this.begT, this.endT);
            ((Component)((Object)this)).repaint();
            this.calcHPixMax();
            this.calcHbarMax();
            this.calcHbarVal();
            this.setHbarValues();
            return;
        }
        if (string.equals("Change Zoom Fac")) {
            double d;
            try {
                d = Double.valueOf(this.parent.zFacField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new ErrorDiag((Component)((Object)this), "Valid floating point value required");
                this.parent.zFacField.setText(Double.toString(this.zoomFac));
                return;
            }
            if (d < 1.0) {
                new ErrorDiag((Component)((Object)this), "Value must be >= 1");
                this.parent.zFacField.setText(Double.toString(this.zoomFac));
                return;
            }
            this.zoomFac = d;
            return;
        }
        if (string.equals("In")) {
            this.zoomInH();
            return;
        }
        if (string.equals("Out")) {
            this.zoomOutH();
            return;
        }
        if (string.equals("Reset")) {
            this.resetView();
            return;
        }
        if (string.equals("Resize to fit")) {
            this.reFit();
            return;
        }
        if (string.equals("Blink states")) {
            ++this.regionsCt;
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(String.valueOf(this.begT) + " to " + this.endT);
            jRadioButtonMenuItem.setSelected(true);
            jRadioButtonMenuItem.addActionListener((ActionListener)this);
            this.parent.regionsMenu.add((JMenuItem)jRadioButtonMenuItem);
            this.markBlink();
            this.parent.parent.canvas.Refresh();
            return;
        }
        if (actionEvent.getSource() instanceof JRadioButtonMenuItem) {
            this.parent.regionsMenu.remove((JMenuItem)actionEvent.getSource());
            String string2 = string.substring(0, string.indexOf(32));
            String string3 = string.substring(string.lastIndexOf(32) + 1, string.length());
            this.unmarkBlink(new Double(string2), new Double(string3));
            this.parent.parent.canvas.Refresh();
        }
    }

    private void obtainArea(int n, boolean bl) {
        double d;
        double d2;
        double d3;
        double d4;
        switch (n) {
            case 1: {
                d4 = 2.3268;
                break;
            }
            case 5: {
                d4 = 1.6452;
                break;
            }
            case 10: {
                d4 = 1.2817;
                break;
            }
            case 20: {
                d4 = 0.8;
                break;
            }
            case 30: {
                d4 = 0.524;
                break;
            }
            case 50: {
                d4 = 0.0;
                break;
            }
            default: {
                new ErrorDiag(null, "Region has not been implemented");
                return;
            }
        }
        if (!bl) {
            d4 *= -1.0;
        }
        if ((d3 = d4 * (d2 = this.getStDevOfStateLens(d = this.getMeanOfStateLens())) + d) >= this.maxT && bl) {
            new ErrorDiag(null, "No states with duration > mu(" + new Float(d).toString() + ") + " + d4 + "sigma(" + new Float(d2).toString() + ")");
            return;
        }
        if (d3 <= this.leastT && !bl) {
            new ErrorDiag(null, "No states with duration < mu(" + new Float(d).toString() + ") + " + d4 + "sigma(" + new Float(d2).toString() + ")");
            return;
        }
        this.endT = this.maxT;
        this.begT = this.leastT;
        if (bl) {
            if (this.stateVector.size() > 1 && d3 >= this.leastT) {
                this.begT = d3;
            }
        } else if (this.stateVector.size() > 1 && d3 <= this.maxT) {
            this.endT = d3;
        }
        this.xDensity = (double)this._xPix / (this.endT - this.begT);
        this.view.drawRegion(this.begT, this.endT);
        ((Component)((Object)this)).repaint();
        this.calcHPixMax();
        this.calcHbarMax();
        this.calcHbarVal();
        this.setHbarValues();
        this.parent.startLenField.setText(new Float(this.begT).toString());
        this.parent.endLenField.setText(new Float(this.endT).toString());
        this.parent.statesInViewField.setText(Integer.toString(this.view.statesDrawn));
        this.parent.pcInViewField.setText(new Float(this.view.statesDrawn * 100 / this.stateVector.size()).toString());
    }

    private double getMeanOfStateLens() {
        Enumeration enumeration = this.stateVector.elements();
        double d = 0.0;
        while (enumeration.hasMoreElements()) {
            Info info = (Info)enumeration.nextElement();
            d += info.lenT;
        }
        return d / (double)this.stateVector.size();
    }

    private double getStDevOfStateLens(double d) {
        Enumeration enumeration = this.stateVector.elements();
        double d2 = 0.0;
        while (enumeration.hasMoreElements()) {
            Info info = (Info)enumeration.nextElement();
            d2 += (info.lenT - d) * (info.lenT - d);
        }
        return Math.sqrt(d2 / (double)this.stateVector.size());
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.ResizeCanvas();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = this.parent.hbar.getValue();
        int n2 = this.parent.hbar.getVisibleAmount();
        this.begT = this.leastT + (this.maxT - this.leastT) * (double)n / (double)this.hbarMax;
        this.endT = this.leastT + (this.maxT - this.leastT) * (double)(n + n2) / (double)this.hbarMax;
        this.view.drawRegion(this.begT, this.endT);
        ((Component)((Object)this)).repaint();
        this.parent.startLenField.setText(new Float(this.begT).toString());
        this.parent.endLenField.setText(new Float(this.endT).toString());
        this.parent.statesInViewField.setText(Integer.toString(this.view.statesDrawn));
        this.parent.pcInViewField.setText(new Float(this.view.statesDrawn * 100 / this.stateVector.size()).toString());
        this.parent.zFacField.setText(new Float(this.zoomFac).toString());
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (jSlider == this.parent.binSlider) {
            int n = this.parent.binSlider.getValue();
            this.parent.numBinsField.setText(Integer.toString(n));
            this.parent.maxNumBinsField.setText(Integer.toString(this.maxNumBins));
            this.changeNumBins(n);
        }
    }

    public void ResizeCanvas() {
        this.waitCursor();
        Dimension dimension = ((Component)((Object)this)).getSize();
        this.widthCan = dimension.width;
        this.topGap = ((Container)((Object)this.parent)).getInsets().top;
        this.heightCan = dimension.height;
        this._xPix = this.widthCan;
        this._yPix = this.heightCan;
        if (this._yPix < 1) {
            this._yPix = 1;
        }
        if (this._xPix < 1) {
            this._xPix = 1;
        }
        if (!this.setupComplete) {
            this.setupComplete = true;
            this.eff_yPix = this._yPix;
        }
        this.xDensity = (double)this.widthCan / (this.endT - this.begT);
        this.yDensity = ((double)this._yPix - 3.0 * (double)this.lineSize) / (double)this.stateVector.size();
        this.setupImg();
        this.view.drawRegion(this.begT, this.endT);
        ((Component)((Object)this)).repaint();
        this.calcHPixMax();
        this.calcHbarMax();
        this.calcHbarVal();
        this.setHbarValues();
        this.normalCursor();
    }

    private void calcHPixMax() {
        this.hPixMax = this.getW(this.leastT, this.maxT);
    }

    private void calcHbarMax() {
        this.hbarMax = this.hPixMax;
    }

    private void calcHbarVal() {
        double d = (this.begT - this.leastT) * this.xDensity;
        this.hbarVal = (int)Math.rint(d);
    }

    private void setHbarValues() {
        this.parent.hbar.setValues(this.hbarVal, this._xPix, 0, this.hbarMax);
    }

    private void resetView() {
        this.waitCursor();
        this.begT = this.leastT;
        this.endT = this.maxT;
        this.xDensity = (double)this._xPix / (this.endT - this.begT);
        this.view.drawRegion(this.begT, this.endT);
        ((Component)((Object)this)).repaint();
        this.calcHPixMax();
        this.calcHbarMax();
        this.calcHbarVal();
        this.setHbarValues();
        this.parent.startLenField.setText(new Float(this.begT).toString());
        this.parent.endLenField.setText(new Float(this.endT).toString());
        this.parent.statesInViewField.setText(Integer.toString(this.view.statesDrawn));
        this.parent.pcInViewField.setText(new Float(this.view.statesDrawn * 100 / this.stateVector.size()).toString());
        this.normalCursor();
    }

    private void zoomInH() {
        this.waitCursor();
        double d = this.begT + (this.endT - this.begT) / 2.0;
        this.begT = d - (d - this.begT) / this.zoomFac;
        this.endT = d + (this.endT - d) / this.zoomFac;
        this.xDensity = (double)this._xPix / (this.endT - this.begT);
        this.view.drawRegion(this.begT, this.endT);
        ((Component)((Object)this)).repaint();
        this.calcHPixMax();
        this.calcHbarMax();
        this.calcHbarVal();
        this.setHbarValues();
        this.parent.startLenField.setText(new Float(this.begT).toString());
        this.parent.endLenField.setText(new Float(this.endT).toString());
        this.parent.statesInViewField.setText(Integer.toString(this.view.statesDrawn));
        this.parent.pcInViewField.setText(new Float(this.view.statesDrawn * 100 / this.stateVector.size()).toString());
        this.normalCursor();
    }

    private void zoomOutH() {
        this.waitCursor();
        double d = this.begT + (this.endT - this.begT) / 2.0;
        this.begT = d - (d - this.begT) * this.zoomFac;
        if (this.begT < this.leastT) {
            this.begT = this.leastT;
        }
        this.endT = d + (this.endT - d) * this.zoomFac;
        if (this.endT > this.maxT) {
            this.endT = this.maxT;
        }
        this.xDensity = (double)this._xPix / (this.endT - this.begT);
        this.view.drawRegion(this.begT, this.endT);
        ((Component)((Object)this)).repaint();
        this.calcHPixMax();
        this.calcHbarMax();
        this.calcHbarVal();
        this.setHbarValues();
        this.parent.startLenField.setText(new Float(this.begT).toString());
        this.parent.endLenField.setText(new Float(this.endT).toString());
        this.parent.statesInViewField.setText(Integer.toString(this.view.statesDrawn));
        this.parent.pcInViewField.setText(new Float(this.view.statesDrawn * 100 / this.stateVector.size()).toString());
        this.normalCursor();
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 503) {
            this.adjustTimeField(mouseEvent.getX());
        }
        if (mouseEvent.getID() == 506) {
            int n = mouseEvent.getY();
            int n2 = this.ty - n;
            this.eff_yPix += n2;
            this.yDensity = ((double)this.eff_yPix - 3.0 * (double)this.lineSize) / (double)this.stateVector.size();
            this.view.drawRegion(this.begT, this.endT);
            ((Component)((Object)this)).repaint();
            this.ty = n;
            return;
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.ty = mouseEvent.getY();
            return;
        }
        if (mouseEvent.getID() == 502) {
            this.ty = mouseEvent.getY();
            return;
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    int print(Graphics graphics, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString("State '" + this.stateDef.description.desc + "' length distribution", n, n2 + fontMetrics.getHeight() - fontMetrics.getDescent());
        graphics.drawString(String.valueOf(Integer.toString(this.view.statesDrawn)) + " drawn out of " + Integer.toString(this.stateVector.size()) + " (" + new Float((double)this.view.statesDrawn * 100.0 / (double)this.stateVector.size()).toString() + "%)", n, n2 + 2 * fontMetrics.getHeight() - fontMetrics.getDescent());
        return 3 * fontMetrics.getHeight();
    }

    private void adjustTimeField(int n) {
        this.parent.cursorField.setText(new Float(this.view.begT + this.getTime(n)).toString());
    }

    void waitCursor() {
        ((Component)((Object)this)).setCursor(new Cursor(3));
    }

    void normalCursor() {
        ((Component)((Object)this)).setCursor(new Cursor(1));
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    void kill() {
        if (this.view != null) {
            this.view.kill();
            this.view = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.endsWith("%")) {
                int n = Integer.parseInt(string.substring(0, string.length() - 1));
                HistCanvas.this.parent.areaField.setText(string);
                HistCanvas.this.obtainArea(n, true);
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.endsWith("%")) {
                int n = Integer.parseInt(string.substring(0, string.length() - 1));
                HistCanvas.this.parent.bAreaField.setText(string);
                HistCanvas.this.obtainArea(n, false);
            }
        }

        /* synthetic */ 2() {
        }
    }
}

