/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollBar;
import com.sun.java.swing.JViewport;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.border.Border;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ClogDisplay
extends JFrame
implements AdjustmentListener,
ActionListener {
    public Mainwin parent;
    Vector mtns;
    Vector stateDefs;
    Vector data;
    CLOG_ARROW quiver;
    CLOG_STATE arrowDef;
    Properties printPrefs;
    StateButtons stateButtons;
    CanOptions optionsDlg;
    ProcDlg procDlg;
    ProgramCanvas canvas;
    VertScaleCanvas vcanvas1;
    VertScaleCanvas vcanvas2;
    JViewport vport;
    JScrollBar hbar;
    private MyTextField timeField;
    private MyTextField elTimeField;
    Font frameFont;
    Font printFont;
    Color frameBColor;
    Color frameFColor;
    Color printBColor;
    Color printFColor;
    Color printImgBColor;
    Color normImgBColor;
    Color rulerColor;
    boolean setupComplete = false;
    int dtype = 0;
    int vertRulerGap;

    public ClogDisplay(Mainwin mainwin) {
        this.parent = mainwin;
        this.dtype = this.parent.dtype;
        ((Frame)((Object)this)).setTitle(CONST.DSTR[this.dtype]);
        this.quiver = mainwin.mainTool.a;
        this.mtns = mainwin.mainTool.mtns;
        this.data = mainwin.mainTool.data;
        this.stateDefs = mainwin.mainTool.stateDefs;
        this.setupArrowDef();
        this.setup();
    }

    private void setupArrowDef() {
        this.arrowDef = new CLOG_STATE();
        this.arrowDef.description.desc = new String("Messages");
        this.arrowDef.color = Color.white;
        this.arrowDef.stateVector = this.quiver.arrowVector;
    }

    private void setup() {
        this.adjustFrameStuff();
        this.setupCanvas();
        this.setupPanels();
        this.setupDlgs();
        this.setupPrintPrefs();
        ((Component)((Object)this)).setSize(this.parent.dimPG);
        ((Component)((Object)this)).setVisible(true);
        this.waitCursor();
        this.drawData();
        this.setupEventHandlers();
        this.setupComplete = true;
        this.normalCursor();
        this.parent.normalCursor();
    }

    private void adjustFrameStuff() {
        this.frameBColor = this.parent.frameBColor;
        this.frameFColor = this.parent.frameFColor;
        this.frameFont = this.parent.frameFont;
        this.rulerColor = ((Component)((Object)this)).getBackground();
        this.printBColor = new Color(35, 129, 174);
        this.printFColor = Color.white;
        this.printImgBColor = Color.lightGray;
        this.normImgBColor = Color.black;
        this.printFont = new Font("Serif", 1, 14);
    }

    private void setupCanvas() {
        this.canvas = new ProgramCanvas();
        this.vcanvas1 = new VertScaleCanvas(this);
        this.vcanvas2 = new VertScaleCanvas(this);
    }

    private void setupPanels() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Border border = BorderFactory.createLoweredBevelBorder();
        JPanel jPanel2 = new JPanel((LayoutManager)new GridBagLayout());
        JPanel jPanel3 = new JPanel((LayoutManager)new GridBagLayout());
        Border border2 = BorderFactory.createEmptyBorder((int)4, (int)4, (int)2, (int)2);
        jPanel3.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel3.add((Component)new JLabel("Pointer "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.timeField = new MyTextField("", 10, false);
        jPanel3.add((Component)((Object)this.timeField), gridBagConstraints);
        this.timeField.setToolTipText("Cursor position (sec) in display");
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        jPanel3.add((Component)new JLabel("Elapsed Time "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.elTimeField = new MyTextField("", 10, false);
        jPanel3.add((Component)((Object)this.elTimeField), gridBagConstraints);
        this.elTimeField.setToolTipText("Cursor position (sec) in display wrt. elapsed time line");
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel((LayoutManager)new GridLayout(1, 3));
        border2 = BorderFactory.createEmptyBorder((int)4, (int)2, (int)2, (int)2);
        jPanel4.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
        jPanel4.add((Component)((Object)new MyButton("In", "Zoom In Horizontally", this)));
        jPanel4.add((Component)((Object)new MyButton("Out", "Zoom Out Horizontally", this)));
        jPanel4.add((Component)((Object)new MyButton("Reset", "Redraws entire data in viewport", this)));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel((LayoutManager)new GridLayout(1, 3));
        border2 = BorderFactory.createEmptyBorder((int)4, (int)2, (int)2, (int)4);
        jPanel5.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
        jPanel5.add((Component)((Object)new MyButton("Options", "Display options for arrows, zoom lock line, elapsed time line and nesting", this)));
        MyButton myButton = new MyButton("Print", "Print display to file or printer", this);
        jPanel5.add((Component)((Object)myButton));
        jPanel5.add((Component)((Object)new MyButton("Close", "Close window", this)));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 2;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel6 = new JPanel((LayoutManager)new BorderLayout());
        border2 = BorderFactory.createEmptyBorder((int)2, (int)4, (int)4, (int)4);
        jPanel6.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
        JPanel jPanel7 = new JPanel((LayoutManager)new BorderLayout());
        this.vport = new JViewport();
        this.vport.setView((Component)((Object)this.canvas));
        this.vport.addComponentListener(this.canvas);
        JPanel jPanel8 = new JPanel((LayoutManager)new BorderLayout());
        jPanel8.setBorder((Border)BorderFactory.createCompoundBorder((Border)BorderFactory.createRaisedBevelBorder(), (Border)BorderFactory.createLoweredBevelBorder()));
        jPanel8.add((Component)this.vport, "Center");
        jPanel7.add((Component)jPanel8, "Center");
        this.hbar = new JScrollBar(0);
        jPanel7.add((Component)this.hbar, "South");
        jPanel6.add((Component)jPanel7, "Center");
        this.vertRulerGap = jPanel8.getInsets().top + jPanel7.getInsets().top;
        this.vcanvas1.setVerticalGap(this.vertRulerGap);
        this.vcanvas2.setVerticalGap(this.vertRulerGap);
        jPanel6.add((Component)((Object)this.vcanvas1), "East");
        jPanel6.add((Component)((Object)this.vcanvas2), "West");
        jPanel.add((Component)jPanel6, "Center");
        this.getContentPane().add((Component)jPanel, "Center");
    }

    private void setupEventHandlers() {
        this.hbar.addAdjustmentListener((AdjustmentListener)this);
        ((Window)((Object)this)).addWindowListener(new 1());
    }

    private void setupDlgs() {
        this.optionsDlg = new CanOptions(this);
        this.stateButtons = new StateButtons(this, 4);
        this.getContentPane().add((Component)((Object)this.stateButtons), "South");
    }

    private void setupPrintPrefs() {
        this.printPrefs = new Properties();
        ((Hashtable)this.printPrefs).put("awt.print.fileName", "jumpshot.ps");
        ((Hashtable)this.printPrefs).put("awt.print.numCopies", "1");
        ((Hashtable)this.printPrefs).put("awt.print.paperSize", "letter");
        ((Hashtable)this.printPrefs).put("awt.print.destination", "file");
        ((Hashtable)this.printPrefs).put("awt.print.orientation", "landscape");
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.setPosition(this.hbar.getValue());
    }

    void setPosition(int n) {
        this.canvas.adjustImgH(n);
        this.vport.setViewPosition(new Point(this.canvas.getPanePosX(), 0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.setupComplete) {
            if (string.equals("In")) {
                this.zoomInH();
                return;
            }
            if (string.equals("Out")) {
                this.zoomOutH();
                return;
            }
            if (string.equals("Reset")) {
                this.resetView();
                return;
            }
            if (string.equals("Options")) {
                this.optionsDlg.reset();
                ((Window)((Object)this.optionsDlg)).show();
                ((Window)((Object)this.optionsDlg)).toFront();
                return;
            }
            if (string.equals("Print")) {
                this.Print();
                return;
            }
            if (string.equals("Close")) {
                this.kill();
            }
        }
    }

    private void drawData() {
        this.canvas.init(this);
        this.vcanvas1.setupComplete();
        this.vcanvas2.setupComplete();
        this.procDlg = new ProcDlg(this);
    }

    private void zoomInH() {
        this.waitCursor();
        this.canvas.zoomInH();
        this.zoomH();
        this.normalCursor();
    }

    private void zoomOutH() {
        this.waitCursor();
        this.canvas.zoomOutH();
        this.zoomH();
        this.normalCursor();
    }

    private void resetView() {
        this.waitCursor();
        this.canvas.resetView();
        this.zoomH();
        this.normalCursor();
    }

    void zoomH() {
        this.setHoriz();
        this.hbar.setValue(this.canvas.sbPos);
        this.vport.setViewPosition(new Point(this.canvas.getPanePosX(), 0));
    }

    void setHoriz() {
        this.hbar.setMaximum(this.canvas.maxH);
        this.hbar.setMinimum(0);
        int n = this.hbar.getValue();
        this.hbar.setValue(0);
        this.hbar.setVisibleAmount((int)Math.rint((double)this.canvas._xPix / 3.0));
        this.hbar.setValue(n);
        this.hbar.setUnitIncrement(1);
        this.hbar.setBlockIncrement((int)Math.rint((double)this.canvas._xPix / 3.0));
    }

    void adjustTimeField(double d) {
        this.timeField.setText(new Float(d).toString());
    }

    void adjustElTimeField(double d) {
        this.elTimeField.setText(new Float(d).toString());
    }

    private void Print() {
        this.waitCursor();
        if (this.checkPrintAllowed()) {
            String string = "Jumpshot:" + this.parent.logFileName;
            PrintJob printJob = ((Window)((Object)this)).getToolkit().getPrintJob((Frame)((Object)this), string, this.printPrefs);
            if (printJob != null) {
                PrintDlg printDlg = this.getPrintDlg();
                printDlg.reset(printJob, this);
            }
        }
        this.normalCursor();
    }

    boolean checkPrintAllowed() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPrintJobAccess();
            }
        }
        catch (SecurityException securityException) {
            new ErrorDiag(null, "Sorry. Printing is not allowed.");
            return false;
        }
        return true;
    }

    PrintDlg getPrintDlg() {
        return new PrintDlg(this);
    }

    void waitCursor() {
        ((Component)((Object)this)).setCursor(new Cursor(3));
    }

    void normalCursor() {
        ((Component)((Object)this)).setCursor(new Cursor(0));
    }

    void kill() {
        this.parent.waitCursor();
        ((Component)((Object)this)).setVisible(false);
        if (this.stateButtons != null) {
            this.stateButtons.kill();
            this.stateButtons = null;
        }
        if (this.canvas != null) {
            this.canvas.kill();
            this.canvas = null;
        }
        this.vcanvas1 = null;
        this.vcanvas2 = null;
        if (this.optionsDlg != null) {
            ((Window)((Object)this.optionsDlg)).dispose();
            this.optionsDlg = null;
        }
        if (this.procDlg != null) {
            ((Window)((Object)this.procDlg)).dispose();
            this.procDlg = null;
        }
        this.mtns = null;
        this.stateDefs = null;
        this.data = null;
        this.quiver = null;
        ((Container)((Object)this)).removeAll();
        ((Window)((Object)this)).dispose();
        this.parent.normalCursor();
        this.parent.delDisp();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    void makeUIChanges() {
        SwingUtilities.updateComponentTreeUI((Component)((Object)this));
        this.optionsDlg.makeUIChanges();
        this.procDlg.makeUIChanges();
        SwingUtilities.updateComponentTreeUI((Component)((Object)this.stateButtons));
        this.rulerColor = ((Component)((Object)this)).getBackground();
        this.canvas.Resize();
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ClogDisplay.this.kill();
        }

        /* synthetic */ 1() {
        }
    }
}

