/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.undo;

import com.sun.java.swing.event.UndoableEditEvent;
import com.sun.java.swing.event.UndoableEditListener;
import com.sun.java.swing.undo.CompoundEdit;
import com.sun.java.swing.undo.UndoableEdit;
import java.util.Enumeration;
import java.util.Vector;

public class UndoableEditSupport {
    protected int updateLevel;
    protected CompoundEdit compoundEdit;
    protected Vector listeners;
    protected Object realSource;

    public UndoableEditSupport() {
        this(null);
    }

    public UndoableEditSupport(Object object) {
        this.realSource = object == null ? this : object;
        this.updateLevel = 0;
        this.compoundEdit = null;
        this.listeners = new Vector();
    }

    public synchronized void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.addElement(undoableEditListener);
    }

    public synchronized void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.removeElement(undoableEditListener);
    }

    protected void _postEdit(UndoableEdit undoableEdit) {
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this.realSource, undoableEdit);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((UndoableEditListener)enumeration.nextElement()).undoableEditHappened(undoableEditEvent);
        }
    }

    public synchronized void postEdit(UndoableEdit undoableEdit) {
        if (this.updateLevel == 0) {
            this._postEdit(undoableEdit);
            return;
        }
        this.compoundEdit.addEdit(undoableEdit);
    }

    public int getUpdateLevel() {
        return this.updateLevel;
    }

    public synchronized void beginUpdate() {
        if (this.updateLevel == 0) {
            this.compoundEdit = this.createCompoundEdit();
        }
        ++this.updateLevel;
    }

    protected CompoundEdit createCompoundEdit() {
        return new CompoundEdit();
    }

    public synchronized void endUpdate() {
        --this.updateLevel;
        if (this.updateLevel == 0) {
            this.compoundEdit.end();
            this._postEdit(this.compoundEdit);
            this.compoundEdit = null;
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " updateLevel: " + this.updateLevel + " listeners: " + this.listeners + " compoundEdit: " + this.compoundEdit;
    }
}

