/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.BoundedRangeModel;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.PlainView;
import com.sun.java.swing.text.Segment;
import com.sun.java.swing.text.Utilities;
import com.sun.java.swing.text.ViewFactory;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

public class FieldView
extends PlainView {
    public FieldView(Element element) {
        super(element);
    }

    protected FontMetrics getFontMetrics() {
        Container container = this.getContainer();
        return container.getFontMetrics(container.getFont());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Shape adjustAllocation(Shape shape) {
        Container container;
        if (shape == null) return null;
        Rectangle rectangle = shape.getBounds();
        int n = (int)this.getPreferredSpan(1);
        int n2 = (int)this.getPreferredSpan(0);
        if (rectangle.height != n) {
            int n3 = rectangle.height - n;
            rectangle.y += n3 / 2;
            rectangle.height -= n3;
        }
        if (!((container = this.getContainer()) instanceof JTextField)) return rectangle;
        JTextField jTextField = (JTextField)container;
        BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
        boundedRangeModel.setMaximum(Math.max(n2, rectangle.width));
        boundedRangeModel.setExtent(rectangle.width - 1);
        if (n2 < rectangle.width) {
            int n4 = rectangle.width - 1 - n2;
            switch (((JTextField)container).getHorizontalAlignment()) {
                case 0: {
                    rectangle.x += n4 / 2;
                    rectangle.width -= n4;
                    return rectangle;
                }
                case 4: {
                    rectangle.x += n4;
                    rectangle.width -= n4;
                    return rectangle;
                }
                default: {
                    return rectangle;
                }
            }
        }
        rectangle.width = n2;
        rectangle.x -= boundedRangeModel.getValue();
        return rectangle;
    }

    void updateVisibilityModel() {
        Container container = this.getContainer();
        if (container instanceof JTextField) {
            JTextField jTextField = (JTextField)container;
            BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
            int n = (int)this.getPreferredSpan(0);
            int n2 = boundedRangeModel.getExtent();
            int n3 = Math.max(n, n2);
            n2 = n2 == 0 ? n3 : n2;
            int n4 = n3 - n2;
            boundedRangeModel.setRangeProperties(n4, n2, 0, n3, false);
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        super.paint(graphics, this.adjustAllocation(shape));
    }

    public float getPreferredSpan(int n) {
        switch (n) {
            case 0: {
                int n2;
                Segment segment = this.getLineBuffer();
                Document document = this.getDocument();
                try {
                    document.getText(0, document.getLength(), segment);
                    n2 = Utilities.getTabbedTextWidth(segment, this.getFontMetrics(), 0, this, 0);
                }
                catch (BadLocationException badLocationException) {
                    n2 = 0;
                }
                return n2;
            }
        }
        return super.getPreferredSpan(n);
    }

    public int getResizeWeight(int n) {
        if (n == 0) {
            return 1;
        }
        return 0;
    }

    public Shape modelToView(int n, Shape shape) throws BadLocationException {
        return super.modelToView(n, this.adjustAllocation(shape));
    }

    public int viewToModel(float f, float f2, Shape shape) {
        return super.viewToModel(f, f2, this.adjustAllocation(shape));
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, this.adjustAllocation(shape), viewFactory);
        this.updateVisibilityModel();
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.removeUpdate(documentEvent, this.adjustAllocation(shape), viewFactory);
        this.updateVisibilityModel();
    }
}

