/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import com.sun.java.swing.plaf.basic.BasicRadioButtonUI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class MetalRadioButtonUI
extends BasicRadioButtonUI {
    private static final MetalRadioButtonUI metalRadioButtonUI = new MetalRadioButtonUI();
    protected ButtonModel model;
    Font f;
    FontMetrics fm;
    Rectangle viewRect;
    Rectangle iconRect;
    Rectangle textRect;
    Icon altIcon;
    Icon selectedIcon;
    Icon disabledIcon;

    public static ComponentUI createUI(JComponent jComponent) {
        return metalRadioButtonUI;
    }

    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        this.model = abstractButton.getModel();
        Dimension dimension = jComponent.getSize();
        this.f = jComponent.getFont();
        graphics.setFont(this.f);
        this.fm = graphics.getFontMetrics();
        this.viewRect = new Rectangle(dimension);
        this.iconRect = new Rectangle();
        this.textRect = new Rectangle();
        this.altIcon = abstractButton.getIcon();
        this.selectedIcon = null;
        this.disabledIcon = null;
        String string = SwingUtilities.layoutCompoundLabel(this.fm, abstractButton.getText(), this.altIcon != null ? this.altIcon : this.icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, this.getDefaultTextIconGap(abstractButton));
        if (jComponent.isOpaque()) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (this.altIcon != null) {
            if (!this.model.isEnabled()) {
                this.altIcon = abstractButton.getDisabledIcon();
            } else if (this.model.isPressed() && this.model.isArmed()) {
                this.altIcon = abstractButton.getPressedIcon();
                if (this.altIcon == null) {
                    this.altIcon = abstractButton.getSelectedIcon();
                }
            } else if (this.model.isSelected()) {
                this.altIcon = abstractButton.getSelectedIcon();
            } else if (abstractButton.isRolloverEnabled() && this.model.isRollover()) {
                this.altIcon = abstractButton.getRolloverIcon();
            }
            if (this.altIcon == null) {
                this.altIcon = abstractButton.getIcon();
            }
            this.altIcon.paintIcon(jComponent, graphics, this.iconRect.x, this.iconRect.y);
        } else {
            this.icon.paintIcon(jComponent, graphics, this.iconRect.x, this.iconRect.y);
        }
        if (string != null) {
            if (this.model.isEnabled()) {
                graphics.setColor(abstractButton.getForeground());
                BasicGraphicsUtils.drawString(graphics, string, this.model.getMnemonic(), this.textRect.x, this.textRect.y + this.fm.getAscent());
            } else {
                graphics.setColor(abstractButton.getBackground().darker());
                BasicGraphicsUtils.drawString(graphics, string, this.model.getMnemonic(), this.textRect.x, this.textRect.y + this.fm.getAscent());
            }
            if (abstractButton.hasFocus() && abstractButton.isFocusPainted() && this.textRect.width > 0 && this.textRect.height > 0) {
                this.paintFocus(graphics, this.textRect, dimension);
            }
        }
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
        graphics.setColor(UIManager.getColor("RadioButton.focus"));
        graphics.drawRect(rectangle.x, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
    }
}

