/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.MenuElement;
import com.sun.java.swing.SwingUtilities;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class MenuSelectionManager {
    private static final MenuSelectionManager instance = new MenuSelectionManager();
    Vector selection = new Vector();

    public static MenuSelectionManager defaultManager() {
        return instance;
    }

    public void setSelectedPath(MenuElement[] menuElementArray) {
        int n = this.selection.size();
        int n2 = 0;
        if (menuElementArray == null) {
            menuElementArray = new MenuElement[]{};
        }
        int n3 = 0;
        int n4 = menuElementArray.length;
        while (n3 < n4) {
            if (n3 >= n || (MenuElement)this.selection.elementAt(n3) != menuElementArray[n3]) break;
            ++n2;
            ++n3;
        }
        n3 = n - 1;
        while (n3 >= n2) {
            ((MenuElement)this.selection.elementAt(n3)).menuSelectionChanged(false);
            this.selection.removeElementAt(n3);
            --n3;
        }
        n3 = n2;
        n4 = menuElementArray.length;
        while (n3 < n4) {
            menuElementArray[n3].menuSelectionChanged(true);
            this.selection.addElement(menuElementArray[n3]);
            ++n3;
        }
    }

    public MenuElement[] getSelectedPath() {
        MenuElement[] menuElementArray = new MenuElement[this.selection.size()];
        int n = 0;
        int n2 = this.selection.size();
        while (n < n2) {
            menuElementArray[n] = (MenuElement)this.selection.elementAt(n);
            ++n;
        }
        return menuElementArray;
    }

    public void clearSelectedPath() {
        this.setSelectedPath(null);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Component component = (Component)mouseEvent.getSource();
        if (!component.isShowing()) {
            System.err.println("Received a mouse event from a non-showing Component " + component);
            return;
        }
        SwingUtilities.convertPointToScreen(point, component);
        int n = point.x;
        int n2 = point.y;
        Vector vector = (Vector)this.selection.clone();
        int n3 = vector.size();
        int n4 = n3 - 1;
        while (n4 >= 0) {
            MenuElement menuElement = (MenuElement)vector.elementAt(n4);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            MenuElement[] menuElementArray2 = null;
            int n5 = 0;
            int n6 = menuElementArray.length;
            while (n5 < n6) {
                Component component2;
                if (menuElementArray[n5] != null && (component2 = menuElementArray[n5].getComponent()).isShowing()) {
                    int n7;
                    int n8;
                    if (component2 instanceof JComponent) {
                        n8 = ((JComponent)component2).getWidth();
                        n7 = ((JComponent)component2).getHeight();
                    } else {
                        Rectangle rectangle = component2.getBounds();
                        n8 = rectangle.width;
                        n7 = rectangle.height;
                    }
                    point.x = n;
                    point.y = n2;
                    SwingUtilities.convertPointFromScreen(point, component2);
                    if (n4 < n3 - 1 && vector.elementAt(n4 + 1) == menuElementArray[n5] || point.x >= 0 && point.x < n8 && point.y >= 0 && point.y < n7) {
                        if (menuElementArray2 == null) {
                            menuElementArray2 = new MenuElement[n4 + 2];
                            int n9 = 0;
                            while (n9 <= n4) {
                                menuElementArray2[n9] = (MenuElement)vector.elementAt(n9);
                                ++n9;
                            }
                        }
                        menuElementArray2[n4 + 1] = menuElementArray[n5];
                        menuElementArray[n5].processMouseEvent(new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()), menuElementArray2, this);
                    }
                }
                ++n5;
            }
            --n4;
        }
    }

    public Component componentForPoint(Component component, Point point) {
        Point point2 = point;
        SwingUtilities.convertPointToScreen(point2, component);
        int n = point2.x;
        int n2 = point2.y;
        Vector vector = (Vector)this.selection.clone();
        int n3 = vector.size();
        int n4 = n3 - 1;
        while (n4 >= 0) {
            MenuElement menuElement = (MenuElement)vector.elementAt(n4);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            int n5 = 0;
            int n6 = menuElementArray.length;
            while (n5 < n6) {
                Component component2;
                if (menuElementArray[n5] != null && (component2 = menuElementArray[n5].getComponent()).isShowing()) {
                    int n7;
                    int n8;
                    if (component2 instanceof JComponent) {
                        n8 = ((JComponent)component2).getWidth();
                        n7 = ((JComponent)component2).getHeight();
                    } else {
                        Rectangle rectangle = component2.getBounds();
                        n8 = rectangle.width;
                        n7 = rectangle.height;
                    }
                    point2.x = n;
                    point2.y = n2;
                    SwingUtilities.convertPointFromScreen(point2, component2);
                    if (point2.x >= 0 && point2.x < n8 && point2.y >= 0 && point2.y < n7) {
                        return component2;
                    }
                }
                ++n5;
            }
            --n4;
        }
        return null;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        Vector vector = (Vector)this.selection.clone();
        int n = vector.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            MenuElement menuElement = (MenuElement)vector.elementAt(n2);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            MenuElement[] menuElementArray2 = null;
            int n3 = 0;
            int n4 = menuElementArray.length;
            while (n3 < n4) {
                Component component;
                if (menuElementArray[n3] != null && (component = menuElementArray[n3].getComponent()).isShowing()) {
                    if (menuElementArray2 == null) {
                        menuElementArray2 = new MenuElement[n2 + 2];
                        int n5 = 0;
                        while (n5 <= n2) {
                            menuElementArray2[n5] = (MenuElement)vector.elementAt(n5);
                            ++n5;
                        }
                    }
                    menuElementArray2[n2 + 1] = menuElementArray[n3];
                    menuElementArray[n3].processKeyEvent(keyEvent, menuElementArray2, this);
                    if (keyEvent.isConsumed()) {
                        return;
                    }
                }
                ++n3;
            }
            --n2;
        }
    }

    public boolean isComponentPartOfCurrentMenu(Component component) {
        if (this.selection.size() > 0) {
            MenuElement menuElement = (MenuElement)this.selection.elementAt(0);
            return this.isComponentPartOfCurrentMenu(menuElement, component);
        }
        return false;
    }

    private boolean isComponentPartOfCurrentMenu(MenuElement menuElement, Component component) {
        if (menuElement == null) {
            return false;
        }
        if (menuElement.getComponent() == component) {
            return true;
        }
        MenuElement[] menuElementArray = menuElement.getSubElements();
        int n = 0;
        int n2 = menuElementArray.length;
        while (n < n2) {
            if (this.isComponentPartOfCurrentMenu(menuElementArray[n], component)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

