/*
** Copyright (C) 1998-1999 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

#ifndef	MERCURY_TRACE_INTERNAL_H
#define	MERCURY_TRACE_INTERNAL_H

#include "mercury_types.h"
#include "mercury_trace.h"

#ifdef  MR_USE_DECLARATIVE_DEBUGGER

/*
** The following enum gives the possible modes that the declarative
** debugger can be in (see trace/mercury_trace_declarative.{c,h}).
*/

typedef enum {
	MR_TRACE_INTERACTIVE,	 	/* Use internal debugger. */
	MR_TRACE_DECL_DEBUG,		/* Normal declarative debugging. */
	MR_TRACE_DECL_DEBUG_TEST	/* Test mode declarative debugging. */
} MR_Trace_Mode;

/*
** This variable is modified whenever we start or stop collecting
** an execution tree.
*/

extern	MR_Trace_Mode	MR_trace_decl_mode;

#endif	/* MR_USE_DECLARATIVE_DEBUGGER */

extern	Code	*MR_trace_event_internal(MR_Trace_Cmd_Info *cmd,
			bool interactive, MR_Event_Info *event_info);


extern	Code	*MR_trace_event_internal_report(MR_Trace_Cmd_Info *cmd,
			MR_Event_Info *event_info);

/*
** Debugger I/O streams.
** Replacements for stdin/stdout/stderr respectively.
**
** The distinction between MR_mdb_out and MR_mdb_err is analagous to
** the distinction between stdout and stderr: ordinary output, including
** information messages about conditions which are not errors, should
** go to MR_mdb_out, but error messages should go to MR_mdb_err.
*/
extern FILE *MR_mdb_in;
extern FILE *MR_mdb_out;
extern FILE *MR_mdb_err;

extern	char	*MR_trace_getline(const char *prompt, FILE *mdb_in,
				FILE *mdb_out);

#endif	/* MERCURY_TRACE_INTERNAL_H */
