/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	JGH
 *
 *	$Id: tsetattr.c,v 1.0 1999/07/21 19:00:18 jsquyres Exp $
 *
 *	Function:	- put value in attribute
 *			- assign attribute to datatype
 *	Accepts:	- datatype
 *			- attribute key
 *			- attribute value
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <errno.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Type_set_attr(type, key, value)

MPI_Datatype		type;
int			key;
void			*value;

{
	struct _attrkey	*p;
	struct _attr	*pk;
	int		err;

	lam_initerr_m();
	lam_setfunc_m(BLKMPITSETATTR);
/*
 * Check the arguments.
 */
	if (type == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITSETATTR, lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	p = lam_getattr(key);
	if (p == 0 || (p->ak_flags & LAM_PREDEF)
			|| !(p->ak_flags & LAM_AKTYPE)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITSETATTR, lam_mkerr(MPI_ERR_KEYVAL, 0)));
	}
/*
 * If the key is not attached to the datatype, attach and fill it.
 */
	pk = (struct _attr *) lam_getkey(type->dt_keys, key);
	if (pk == 0) {
		if (lam_putkey(&type->dt_keys, key)) {
			return(lam_errfunc(MPI_COMM_WORLD, BLKMPITSETATTR,
				lam_mkerr(MPI_ERR_OTHER, errno)));
		}

		pk = (struct _attr *) lam_getkey(type->dt_keys, key);
	}
/*
 * Old attribute, delete previous value and fill new one.
 */
	else if (((MPI_Type_delete_attr_function *) (p->ak_del))
			!= MPI_TYPE_NULL_DELETE_FN) {

		if (p->ak_flags & LAM_LANGF77) {
			(*((MPI_F_delete_function *) (p->ak_del)))
				(&type->dt_f77handle, &key,
				(int *) &pk->a_value,
				(int *) &p->ak_extra, &err);
		} else {
			err = (*((MPI_Type_delete_attr_function *) (p->ak_del)))
				(type, key, pk->a_value, p->ak_extra);
		}

		if (err != MPI_SUCCESS) {
			return(lam_err_comm(MPI_COMM_WORLD, err, 0,
						"deleting old attribute"));
		}
	}

	pk->a_value = value;

	lam_resetfunc_m(BLKMPITSETATTR);
	return(MPI_SUCCESS);
}
