/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD
 *
 *	$Id: opcreate.c,v 6.3 1999/05/25 22:08:09 kmeyer1 Exp $
 *
 *	Function:	- create a reduction operator
 *	Accepts:	- function
 *			- commutative flag
 *			- operator (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

int
MPI_Op_create(func, commute, pop)

void			(*func)();
int			commute;
MPI_Op			*pop;

{
	int		class;
	MPI_Op		op;

	lam_initerr_m();
	lam_setfunc_m(BLKMPIOPCREATE);

	if ((pop == 0) || (func == 0)) {
		class = (pop == 0) ? MPI_ERR_OP : MPI_ERR_ARG;
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIOPCREATE, lam_mkerr(class, 0)));
	}

	op = (MPI_Op) malloc(sizeof(struct _op));
	if (op == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIOPCREATE, lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	*pop = op;
	op->op_func = func;
	op->op_commute = commute;
	op->op_f77handle = -1;
	op->op_flags = 0;

	lam_resetfunc_m(BLKMPIOPCREATE);
	return(MPI_SUCCESS);
}
