/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: rfstate.c,v 6.3 1999/05/25 17:44:43 kmeyer1 Exp $
 * 
 *	Function:	- gathers state from a remote filed
 *			- receives file descriptors from
 *			  filed until reply code is EEOF
 *
 *	Accepts:	- target node ID
 *			- ptr to file descriptor table
 *			- # of entries in table
 *
 *	Returns:	- number of replied descriptors or ERROR
 */

#include <string.h>
#include <unistd.h>

#include <events.h>
#include <freq.h>
#include <ksignal.h>
#include <net.h>
#include <string.h>
#include <terror.h>
#include <typical.h>
#include <t_types.h>

/*
 * local variables
 */
static char		hole[MAXNMSGLEN];

int
lam_rfstate(nodeid, ftbl, maxcount)

int			nodeid;		/* target node ID */
int			maxcount;	/* count of descriptor table */
struct fstate		ftbl[];		/* ptr to descriptor table */

{
	struct nmsg	nhead;		/* network message desc. */
	struct freq  	*request;	/* filed request */
	struct freply	*reply;		/* filed reply */
	struct fstate	*fhole;		/* ptr incoming file descs */
	int		count;		/* # descs in this msg */
	int		totcount;	/* total # replied descs */
	int		i;		/* favourite index */
	int		mask;		/* signal mask */

	totcount = 0;
	fhole = (struct fstate *) hole;
	request = (struct freq *) nhead.nh_data;
	reply = (struct freply *) nhead.nh_data;

	request->fq_src_node = (nodeid == LOCAL) ? nodeid : getnodeid();
	request->fq_src_event = -getpid();
	request->fq_req = FQSTATE;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVFILED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = (char *) 0;

	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	nhead.nh_event = -getpid();
	nhead.nh_msg = hole;

	do {
		nhead.nh_length = MAXNMSGLEN;

		if (nrecv(&nhead)) {
			ksigsetmask(mask);
			return(LAMERROR);
		}

		count = nhead.nh_length / sizeof(struct fstate);
		totcount += count;

		if (maxcount > 0) {
/*
 * Convert byte ordering (sigh).
 */
			for (i = 0; i < count; ++i) {
				fhole[i].fs_tfd = ttol(fhole[i].fs_tfd);
				fhole[i].fs_tflags = ttol(fhole[i].fs_tflags);
				fhole[i].fs_flow = ttol(fhole[i].fs_flow);
				fhole[i].fs_count = ttol(fhole[i].fs_count);
				fhole[i].fs_src_node =
					ttol(fhole[i].fs_src_node);
				fhole[i].fs_src_event =
					ttol(fhole[i].fs_src_event);
			}

			if (count > maxcount) count = maxcount;

			memcpy((char *) ftbl, hole,
				count * sizeof(struct fstate));
			maxcount -= count;
			ftbl += count;
		}

	} while (! reply->fr_errno);

	ksigsetmask(mask);

	if (reply->fr_errno == EEOF) {
		return(totcount);
	} else {
		errno = reply->fr_errno;
		return(LAMERROR);
	}
}

/*
 * backwards compatibility
 */
int rfstate(nodeid, ftbl, maxcount) int nodeid, maxcount; struct fstate ftbl[];
	{ return(lam_rfstate(nodeid, ftbl, maxcount)); }
