/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Log: rf77.c,v $
 *	Revision 6.2  1999/05/25 17:44:41  kmeyer1
 *	added copyright
 *	
 *	Revision 6.1  1996/11/23 19:58:46  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:50:05  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:59:11  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:58:07  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:38:23  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.1  94/02/21  17:57:40  raja
 * Remove backward compatibility functions.
 * 
 * Revision 2.2  92/04/30  14:41:27  trillium
 * Ohio Release
 *
 * Revision 2.1  91/02/24  20:56:17  gdburns
 * Ohio Release
 *
 *	Function:	- functions to support F77 I/O
 */

#include <events.h>
#include <freq.h>
#include <ksignal.h>
#include <net.h>
#include <typical.h>

/*
 * external variables
 */
extern int		errno;		/* error number */
extern struct fclient	_ufd[FUMAX];	/* client file descriptor table */

/*
 * external functions
 */
extern int		_fdvalid();	/* check validity of file desc */

/*
 *	rf77back
 *
 *	Function:	- move file position ptr backwards one record
 *			- assumes an F77 sequential file
 *	Accepts:	- file descriptor handle
 *			- formatted or unformatted indicator
 *	Returns:	- 0 or ERROR
 */
int
rf77back(fd, fmt)

int			fd;
char			fmt;

{
	struct nmsg	nhead;		/* network message desc. */
	struct freq	*request;	/* filed request */
	struct freply	*reply;		/* filed reply */
	int		mask;		/* signal mask */
/*
 * Do simple error checking.
 */
	if (_fdvalid(fd) == ERROR) {
		return((int4) ERROR);
	}

	request = (struct freq *) nhead.nh_data;
	reply = (struct freply *) nhead.nh_data;

	request->fq_src_node = getnodeid();
	request->fq_src_event = -getpid();
	request->fq_req = FQF77BACK;
	request->fq_tfd = _ufd[fd].fu_tfd;
	request->fq_fmt = fmt;

	if ((fd <= 2) && (_ufd[fd].fu_node == NOTNODEID)) {
		_ufd[fd].fu_node = getorigin();
	}

	nhead.nh_node = _ufd[fd].fu_node;
	nhead.nh_event = EVFILED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	if (nsend(&nhead)) {
		return((int4) ERROR);
	}

	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));
	nhead.nh_event = -getpid();

	if (nrecv(&nhead)) {
		return((int4) ERROR);
	}

	if (reply->fr_errno != 0) {
		errno = reply->fr_errno;
		return((int4) ERROR);
	}

	ksigsetmask(mask);

	return((int) reply->fr_ret);
}

/*
 *	rf77read
 *
 *	Function:	- read a record from a file
 *			- assumes an F77 sequential file
 *	Accepts:	- file descriptor handle
 *			- ptr to input buffer
 *			- length of input buffer
 *			- formatted or unformatted indicator
 *	Returns:	- actual length of record in file
 */
int4
rf77read(fd, buf, len, fmt)

int			fd;
char			*buf;
int4			len;
char			fmt;

{
	struct nmsg	nhead;		/* network message desc. */
	struct freq	*request;	/* filed request */
	struct freply	*reply;		/* filed reply */
	int		mask;		/* signal mask */
	int4		tot_len = 0;	/* total length read */
/*
 * Do simple error checking.
 */
	if (_fdvalid(fd) == ERROR) {
		return((int4) ERROR);
	}

	request = (struct freq *) nhead.nh_data;
	reply = (struct freply *) nhead.nh_data;

	request->fq_src_node = getnodeid();
	request->fq_src_event = -getpid();
	request->fq_req = FQF77READ;
	request->fq_tfd = _ufd[fd].fu_tfd;
	request->fq_length = len;
	request->fq_fmt = fmt;

	if ((fd <= 2) && (_ufd[fd].fu_node == NOTNODEID)) {
		_ufd[fd].fu_node = getorigin();
	}

	nhead.nh_node = _ufd[fd].fu_node;
	nhead.nh_event = EVFILED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	if (nsend(&nhead)) {
		return((int4) ERROR);
	}

	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));
/*
 * Receive input buffer packets.
 * Each packet contains the length of the total input data.
 */
	nhead.nh_msg = buf;
	nhead.nh_event = -getpid();

	do {
		nhead.nh_type = 0;
		nhead.nh_length = MAXNMSGLEN;

		if (nrecv(&nhead)) {
			return((int4) ERROR);
		}

		if (reply->fr_errno != 0) {
			errno = reply->fr_errno;
			return((int4) ERROR);
		}

		tot_len += nhead.nh_length;
	} while (tot_len < reply->fr_ret);

	ksigsetmask(mask);

	return(tot_len);
}
