/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: di_wait.ext.c,v 6.4 1999/07/28 00:31:49 jsquyres Exp $
 *
 *	Function:	- block waiting for network frame message
 *	Accepts:	- socket descriptor
 */

#include <lam_config.h>

#include <string.h>
#include <sys/types.h>
#include <sys/time.h>

#if LAM_NEED_SYS_SELECT_H
#include <sys/select.h>
#endif

#include <kreq.h>
#include <terror.h>

/*
 * external functions 
 */
extern void		di_forward();

void
di_wait(sockd)

int			sockd;

{
	fd_set		readmask;		/* select read-mask */
/*
 * Block for datalink input.
 */
	FD_ZERO(&readmask);
	FD_SET(sockd, &readmask);

	if (select(sockd + 1, &readmask, (fd_set *) 0, (fd_set *) 0,
			(struct timeval *) 0) < 0) {
		terror("dli_inet (select)");
		kexit(errno);
	}

	di_forward();
}
