// This is -*- C++ -*-
// $Id: color.h,v 1.18 1999/02/07 09:18:54 glaurent Exp $

/* 
 * color.h
 *
 * Copyright (C) 1998 EMC Capital Management, Inc.
 * Copyright 1998 Karl E. Nelson <kenelson@ece.ucdavis.edu>
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@emccta.com>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _GDKMM_COLOR_H
#define _GDKMM_COLOR_H

#include <gdk/gdk.h>
#include <gdk--/types.h>

//: Gdk Color
// This is a container for a GdkColor.  
// It stores 3 color values and the color index.
// (It is not a handle.)
class Gdk_Color: public Gdk_Obj<GdkColor>
  {
   private:
     GdkColor* operator -> ();
     const GdkColor* operator -> () const;  

   public:
     Gdk_Color();
     Gdk_Color(const string &str);
     Gdk_Color(GdkColor* c);
     Gdk_Color(const Gdk_Color& c);
     ~Gdk_Color();

     bool operator == (const Gdk_Color &color)
       {
        return equal(color);
       }

     gint equal(const Gdk_Color& color) const;

     void set_grey(gushort g) 
       {
        obj_.red = obj_.green = obj_.blue = g;
       }

     void set_grey_p(gdouble g) 
       {
        obj_.red = obj_.green = obj_.blue = (gushort)(g*65535);
       }

     void set_rgb(gushort red, gushort green, gushort blue) 
       {
        obj_.red = red;
        obj_.green = green;
        obj_.blue = blue;
       }

     void set_rgb_p(gdouble red, gdouble green, gdouble blue) 
       {
        obj_.red = (gushort)(red*65535);
        obj_.green = (gushort)(green*65535);
        obj_.blue = (gushort)(blue*65535);
       }

     void set_hsv(gdouble h, gdouble s, gdouble v);
     void set_hsl(gdouble h, gdouble s, gdouble l);

     gint set(const string &str) ;
     gint parse(const string& spec)
       {return set(spec);}

     gushort get_red() const     { return obj_.red;   }
     gushort get_green() const   { return obj_.green; }
     gushort get_blue() const    { return obj_.blue;  }

     void set_red(gushort r)     {  obj_.red = r;   }
     void set_green(gushort g)   {  obj_.green = g; }
     void set_blue(gushort b)    {  obj_.blue = b;  }

     guint get_pixel() const     { return obj_.pixel; }

     gdouble red_p() const   { return obj_.red / 65535.;   }
     gdouble green_p() const { return obj_.green / 65535.; }
     gdouble blue_p() const  { return obj_.blue / 65535.;  }

     /* Gratuitous code-bloat begins here */
     void set_random(); /* pointless, but fun */
     gdouble distance_rgb_euclidean(const Gdk_Color& obj) const;
     gdouble distance_rgb_taxicab(const Gdk_Color& obj) const;
  };

#endif // _GDKMM_COLOR_H

// $Id: color.h,v 1.18 1999/02/07 09:18:54 glaurent Exp $
