#include <gtk--.h>

// Gtk-- version of the "statusbar" example from the gtk+ tutorial

class StatusBar : public Gtk_Window
{
  Gtk_VBox m_vbox;
  Gtk_Button m_bPush, m_bPop;
  Gtk_Statusbar m_status_bar;

  // Note : m_context_id has to be declared *after* m_status_bar to be
  // initialized in the constructor's init list
  unsigned int m_context_id,
    m_count;  
 
  void push_item(unsigned int context_id);
  void pop_item(unsigned int context_id) { m_status_bar.pop(context_id); }
  
 public:
  StatusBar();
};


StatusBar::StatusBar() :
  m_vbox(false, 1),
  m_bPush("push item"),
  m_bPop("pop last item"),
  m_context_id(m_status_bar.get_context_id("Statusbar example")),
  m_count(1)
{
  set_usize(200, 100);
  set_title("Gtk-- Statusbar Example");
  
  add(&m_vbox);
  
  m_vbox.pack_start(m_status_bar);

  connect_to_method(m_bPush.clicked, this, &push_item, m_context_id);
  m_vbox.pack_start(m_bPush);
  
  connect_to_method(m_bPop.clicked, this, &pop_item, m_context_id);
  m_vbox.pack_start(m_bPop);
  
  show_all();
}

void
StatusBar::push_item(unsigned int context_id)
{
  char buff[20];

  g_snprintf(buff, 20, "Item %d", m_count++);
  m_status_bar.push(context_id, buff);
}

int main (int argc, char *argv[])
{
  Gtk_Main myapp(&argc, &argv);

  StatusBar statusbar;

  myapp.run();
  return 0;
}

