/* example-start entry entry.c */

#include <gtk--.h>

class EntryWindow: public Gtk_Window
{
    Gtk_Entry entry;
    Gtk_CheckButton editable, visible;
    Gtk_VBox vbox;
    Gtk_HBox hbox;
    Gtk_Button close;
public:
    EntryWindow();
private:
    void toggle_editable();
    void toggle_visible();
    void display_text();
    
    gint delete_event_impl(GdkEventAny*) { 
        Gtk_Main::instance()->quit(); return 0;
    }
};

EntryWindow::EntryWindow():
    editable("Editable"),
    visible("Visible"),
    close("Close")
{
    entry.set_text("hello world");
    entry.select_region(0, entry.get_text_length());
    connect_to_method(entry.activate, this, &display_text);
    
    editable.set_active(true);
    connect_to_method(editable.clicked, this, &toggle_editable);
    visible.set_active(true);
    connect_to_method(visible.clicked, this, &toggle_visible);
    set_usize(200, 100);
    set_title("GTK Entry");
    
    hbox.pack_start(editable, true, true, 0);
    hbox.pack_start(visible, true, true, 0);

    connect_to_method(close.clicked, Gtk_Main::instance(),
		      &Gtk_Main::quit);
    close.set_flags(GTK_CAN_DEFAULT);

    vbox.pack_start(entry, true, true, 0);
    vbox.add(hbox);
    vbox.add(close);
    vbox.show_all();
    add(vbox);

    close.grab_default();
}

void EntryWindow::toggle_editable()
{
    entry.set_editable(editable.get_active());
}

void EntryWindow::toggle_visible()
{
    entry.set_visibility(visible.get_active());
}

void EntryWindow::display_text()
{
    cout << "Entry contents: " << entry.get_text() << endl;
}

int main (int argc, char *argv[])
{
    Gtk_Main m(&argc, &argv);
    EntryWindow window;

    window.show();
    m.run();

    return 0;
}
/* example-end */
