/* example-start base buttons.cc */

#include <gtk--.h>

/* Create a new hbox with an image and a label packed into it.
 * This demonstrates the ability to derive your own widgets
 * from the stock GTK-- ones. */

class IBox: public Gtk_HBox
{
    Gtk_Label label;
    Gtk_Pixmap pixmap;
public:
    IBox(Gtk_Widget& parent, const string& filename, const string& text);
};

IBox::IBox(Gtk_Widget& parent, const string& filename,
	   const string& text):
    label(text),
    pixmap(parent, filename)
{ 
    set_border_width(2);

    pack_start(pixmap, false, false, 3);
    pack_start(label, false, false, 3);
}

class Wnd: public Gtk_Window
{
    IBox* box; // This is a pointer, because we'll have to initialize
    // it later
    Gtk_Button button;
public:
    Wnd();
    ~Wnd() {delete box;}; // Beware the memleaks!
private:
    int delete_event_impl(GdkEventAny*) { 
        Gtk_Main::instance()->quit(); return 0; 
    }
    void button_clicked(string widget_name);
};

Wnd::Wnd():
    Gtk_Window(GTK_WINDOW_TOPLEVEL)
{
    set_title("Pixmap'd Buttons!");
    set_border_width(10);

    /* Create our custom box */
    box = new IBox(*this, "info.xpm", "cool button");
    
    /* Connect the "clicked" signal of the button to our callback */
    connect_to_method(button.clicked, this, &button_clicked, (string)"cool button");

    /* Do the packaging */
    button.add(box);
    add(button);
    button.show_all();
}

void Wnd::button_clicked(string widget_name)
{
    cout << "Hello again - " << widget_name << " was pressed" << endl;
}


int main(int argc, char *argv[])
{
    Gtk_Main m(&argc, &argv);
    Wnd window;

    window.show();
    m.run();
    
    return(0);
}
/* example-end */
