#include "ReparentDemo.h"

ReparentDemo * ReparentDemo::theTest = 0;

TestFixture *
ReparentDemo::create ()
{
  if ( theTest == 0 ) 
    {
      theTest = new ReparentDemo ();
      return theTest;
    }
  return 0;
}

ReparentDemo::~ReparentDemo () 
{ 
  hide(); 
};	

void
ReparentDemo::reparent_label ( ReparentDemo::ReparentData * data )
{

   Gtk_Label * label;

   label = static_cast < Gtk_Label * > ( data -> widget -> get_user_data () );

   label -> reparent ( * data -> newParent );
}

void
ReparentDemo::set_parent_signal ( Gtk_Widget *old_parent,
				  gpointer    func_data )
{
  // the child is always label
  cout << "set_parent for \""
       << gtk_type_name ( GTK_OBJECT_TYPE ( label . gtkobj () ) )
       << "\": new parent: \""
       << ( label . get_parent ()  ? 
	    gtk_type_name ( GTK_OBJECT_TYPE ( label . get_parent () -> gtkobj () ) ) : "NULL" )
       << "\", old parent: \""
       << ( old_parent ? gtk_type_name ( GTK_OBJECT_TYPE ( old_parent -> gtkobj () ) ) : "NULL" )
       << "\", data: "
       << GPOINTER_TO_INT ( func_data ) 
       << endl;
}

ReparentDemo::ReparentDemo () :
  hbox2 ( false, 5 ),
  vbox2 ( false, 10 ),
  label ( "Hello World" )
{
  Gtk_VBox   *box3;
  Gtk_Frame  *frame;
  Gtk_Button *button;

  set_title ( "reparent" );
  set_border_width ( 0 );
  
  actionArea . pack_start ( box1 );

  hbox2 . set_border_width ( 10 );
  box1 . pack_start ( hbox2, true, true, 0 );

  frame = new Gtk_Frame ( "Frame 1" );
  hbox2 . pack_start ( manage ( frame ), true, true, 0 );
  
  box3 = new Gtk_VBox ( false, 5 );
  box3 -> set_border_width ( 5 );
  frame -> add ( box3 );

  button = new Gtk_Button( "switch" );

  ReparentDemo::ReparentData * rpData = new ReparentDemo::ReparentData;
  rpData -> widget = button;
  rpData -> newParent = box3;

  connect_to_method ( button -> clicked, this, &( ReparentDemo::reparent_label ),
		      static_cast < ReparentDemo::ReparentData * > ( rpData ) );
  button -> set_user_data ( &label );
  box3 -> pack_start ( manage ( button ), false, true, 0);

  box3 -> pack_start ( label, false, true, 0 );
  connect_to_method ( label . parent_set , this, &ReparentDemo::set_parent_signal, 
		      GINT_TO_POINTER ( 42 ) );

  frame = new Gtk_Frame ( "Frame 2" );
  hbox2 . pack_start ( manage ( frame ), true, true, 0 );

  box3 = new Gtk_VBox ( false, 5 );

  box3 -> set_border_width ( 5 );

  frame -> add ( box3 );

  button = new Gtk_Button ( "switch" );

  rpData = new ReparentDemo::ReparentData;
  rpData -> widget = button;
  rpData -> newParent = box3;
  
  connect_to_method ( button -> clicked, this , &ReparentDemo::reparent_label, 
		      static_cast < ReparentDemo::ReparentData * > ( rpData ) );

  button -> set_user_data ( &label );
  box3 -> pack_start ( manage ( button ), false, true, 0 );

  box1 . pack_start ( hseparator, false, true, 0 );

  vbox2 . set_border_width ( 10 );
  box1 . pack_start ( vbox2, false, true, 0 );

  packControlArea ();
  show_all ();
}
