/****************************************************************************
**
** dump_args.c
**
** Michael S. Borella 
** 3Com Advanced Technologies Research Center
**
** Copyright (C) 1997, 1998 3Com
**
** Output the arguments read from a genparse file.  For debugging, mostly
**
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <malloc.h>
#include "genparse.h"

extern clarg_t arg_array[];

/*---------------------------------------------------------------------------
 * 
 * dump_args()
 *
 *-------------------------------------------------------------------------*/

void dump_args(void)
{
  int i;
  int n;
  int get_current_flag(void);

  /*
   * Get the current argument pointer
   */

  n = get_current_flag();

  /*
   * Loop over each argument
   */

  for (i = 0; i<=n; i++)
    {
      printf("Argument %d:\n", i+1);
      printf("\tShort parameter: %c\n", arg_array[i].short_param);
      printf("\tLong parameter: %s\n", arg_array[i].long_param);
      printf("\tInternal variable: %s\n", arg_array[i].internal_var);
      printf("\tType: %d\n", arg_array[i].type);
      printf("\tDefault value: %s\n", arg_array[i].default_val);
      printf("\tLow range: %s\n", arg_array[i].low_range);
      printf("\tHigh range: %s\n", arg_array[i].high_range);
      printf("\tCallback function: %s\n", arg_array[i].callback);
      printf("\tDescription: %s\n", arg_array[i].desc);
    }
}



