{
Internal Pascal declarations of the GPC run time system that are not
meant to be used in normal programs. This file is a supplement to
gpc.pas. Use of the routines in this file from user programs is at
your own risk. It might work only under certain circumstances, and
the declarations might change without notice.

Note about the `GPC_' prefix:
This is inserted so that some identifiers don't conflict with the
built-in ones. Sometimes, the built-in ones do exactly the same as
the ones declared here, but often enough, they contain some "magic",
so they should be used instead of the plain declarations here.
In general, routines with a `GPC_' prefix should not be called from
programs. They may change or disappear in future GPC versions.

Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

This file is part of the GNU Pascal Library. The GNU Pascal
Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

The GNU Pascal Library is distributed in the hope that it will
be useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.
If not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

{$if __GPC_RELEASE__ < 19990905}
{$error
Trying to compile the RTS with a non-current GPC version is likely
to cause problems. If you are building the RTS separately from GPC,
make sure you install a current GPC version previously. If you are
building GPC now and this message appears, something is wrong --
if you are overriding the GCC_FOR_TARGET or GPC_FOR_TARGET, make
variables, this might be the problem. If you are cross-building GPC,
build and install a current GPC cross-compiler first. Sorry.}
{$endif}

unit Internal;

interface

type
  GPC_TChars = packed array [1 .. 1] of Char;
  GPC_PChars = ^GPC_TChars;
  GPC_PCStrings = ^GPC_TCStrings;
  GPC_TCStrings = array [0 .. MaxInt] of CString;
  GPC_CFilePtr = Pointer;
  GPC_UnixTimeType = LongInt; { This is hard-coded in the compiler. Do not change here. }
  GPC_MicroSecondTimeType = LongInt;

type
  AnyFile = Text; (*@@ create `AnyFile' parameters*)
  PAnyFile = ^AnyFile;

{ RTS initialization, called before entering the main Pascal program, from rt0.c }

procedure GPC_Initialize (ArgumentCount : Integer; Arguments, StartEnvironment : GPC_PCStrings); asmname '_p_initialize';

{ Subroutines of GPC_Initialize. All GPC_Initialize does is call these routines. }

procedure GPC_Init_Heap;            asmname '_p_init_heap';
procedure GPC_Init_Signals;         asmname '_p_init_signals';
(*@@IO critical*) procedure GPC_Initialize_StdErr;    asmname '_p_initialize_stderr';
procedure GPC_Init_Environment (StartEnvironment : GPC_PCStrings); asmname '_p_init_environment';
procedure GPC_Init_Arguments;       asmname '_p_init_arguments';
(*@@IO critical*) procedure GPC_Initialize_Std_Files; asmname '_p_initialize_std_files';
procedure GPC_Init_Misc;            asmname '_p_init_misc';
procedure GPC_Init_Time;            asmname '_p_init_time';
procedure GPC_Run_Constructors;     asmname '_p_run_constructors';

{ Automatically called at the end of the program }
procedure GPC_Done_Files;                                    asmname '_p_done_files';

type
  PFileAssociation = ^TFileAssociation;
  TFileAssociation = record
    Next : PFileAssociation;
    IntName, ExtName : CString
  end;

var
  RTSDebugFlag     : asmname '_p_debug' Integer;
  RTSWarnFlag      : asmname '_p_warn'  Boolean;
  ForceDirectFiles : asmname '_p_force_direct_files' Boolean;
  EOLnResetHack    : asmname '_p_eoln_reset_hack' Boolean;
  FileAssociation  : asmname '_p_FileAssociation' PFileAssociation;
  CurrentStdIn     : asmname '_p_current_stdin' ^Text;

procedure FlushAllFiles (OnlyTTYs : Boolean); asmname '_p_fflush';
procedure ExitProgram (Status : Integer); asmname '_p_exit';

{ Generic file handling routines and their support, from file.c }

type
  InternalIOSelectTypePtr = ^InternalIOSelectType;
  InternalIOSelectType = record
    fi : PAnyFile;
    WantedReadOrEOF,
    WantedRead,
    WantedEOF,
    WantedWrite,
    WantedException,
    WantedAlways,
    OccurredReadOrEOF,
    OccurredRead,
    OccurredEOF,
    OccurredWrite,
    OccurredException : Boolean
  end;

function  FileName_CString (protected var aFile : AnyFile) : CString; asmname '_p_filename';

function  InternalIOSelect (Events : InternalIOSelectTypePtr; EventsLow, Count : Integer; MicroSeconds : GPC_MicroSecondTimeType) : Integer; asmname '_p_select';
procedure GPC_InitFDR (var aFile : AnyFile; Name : CString; Size, Flags : Integer); asmname '_p_initfdr';
procedure GPC_DoneFDR (var aFile : AnyFile);                                        asmname '_p_donefdr';

{ Default TFDD routines for files. @@ OpenProc and CloseProc still missing. }
function  F_Read     (var aFile; var   Buffer; Size : SizeType) : SizeType; asmname '_p_f_read';
function  F_Read_TTY (var aFile; var   Buffer; Size : SizeType) : SizeType; asmname '_p_f_read_tty';
function  F_Write    (var aFile; const Buffer; Size : SizeType) : SizeType; asmname '_p_f_write';
procedure F_Flush    (var aFile);                                           asmname '_p_f_flush';

{ Routines to read various things from files, from read.c }

procedure GPC_LazyTryGet (var aFile : AnyFile);                    asmname '_p_lazytryget';
procedure GPC_LazyGet    (var aFile : AnyFile);                    asmname '_p_lazyget';
procedure GPC_LazyUnget  (var aFile : AnyFile);                    asmname '_p_lazyunget';

{ If an error occurs or remaining characters (including whitespace!) are left,
  the position of the error, not the error code, is returned (BP compatibility!) }
function GPC_Val_ByteInt_NoCheck   (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : ByteInt  ) : Integer; asmname '_p_val_byteint_nocheck';
function GPC_Val_ShortInt_NoCheck  (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : ShortInt ) : Integer; asmname '_p_val_shortint_nocheck';
function GPC_Val_Integer_NoCheck   (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : Integer  ) : Integer; asmname '_p_val_integer_nocheck';
function GPC_Val_MedInt_NoCheck    (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : MedInt   ) : Integer; asmname '_p_val_medint_nocheck';
function GPC_Val_LongInt_NoCheck   (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : LongInt  ) : Integer; asmname '_p_val_longint_nocheck';
function GPC_Val_ByteCard_NoCheck  (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : ByteCard ) : Integer; asmname '_p_val_bytecard_nocheck';
function GPC_Val_ShortCard_NoCheck (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : ShortCard) : Integer; asmname '_p_val_shortcard_nocheck';
function GPC_Val_Cardinal_NoCheck  (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : Cardinal ) : Integer; asmname '_p_val_cardinal_nocheck';
function GPC_Val_MedCard_NoCheck   (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : MedCard  ) : Integer; asmname '_p_val_medcard_nocheck';
function GPC_Val_LongCard_NoCheck  (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : LongCard ) : Integer; asmname '_p_val_longcard_nocheck';
{$if 0} { Not yet built-in }
function GPC_Val_ByteInt_Check     (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : ByteInt;   MinRange, MaxRange : ByteInt  ) : Integer; asmname '_p_val_byteint_check';
function GPC_Val_ShortInt_Check    (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : ShortInt;  MinRange, MaxRange : ShortInt ) : Integer; asmname '_p_val_shortint_check';
function GPC_Val_Integer_Check     (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : Integer;   MinRange, MaxRange : Integer  ) : Integer; asmname '_p_val_integer_check';
function GPC_Val_MedInt_Check      (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : MedInt;    MinRange, MaxRange : MedInt   ) : Integer; asmname '_p_val_medint_check';
function GPC_Val_LongInt_Check     (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : LongInt;   MinRange, MaxRange : LongInt  ) : Integer; asmname '_p_val_longint_check';
function GPC_Val_ByteCard_Check    (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : ByteCard;  MinRange, MaxRange : ByteCard ) : Integer; asmname '_p_val_bytecard_check';
function GPC_Val_ShortCard_Check   (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : ShortCard; MinRange, MaxRange : ShortCard) : Integer; asmname '_p_val_shortcard_check';
function GPC_Val_Cardinal_Check    (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : Cardinal;  MinRange, MaxRange : Cardinal ) : Integer; asmname '_p_val_cardinal_check';
function GPC_Val_MedCard_Check     (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : MedCard;   MinRange, MaxRange : MedCard  ) : Integer; asmname '_p_val_medcard_check';
function GPC_Val_LongCard_Check    (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : LongCard;  MinRange, MaxRange : LongCard ) : Integer; asmname '_p_val_longcard_check';
{$endif}
function GPC_Val_ShortReal         (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : ShortReal) : Integer; asmname '_p_val_shortreal';
function GPC_Val_Real              (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : Real     ) : Integer; asmname '_p_val_real';
function GPC_Val_LongReal          (Source : GPC_PChars; StrLength, Flags : Integer; var Dest : LongReal ) : Integer; asmname '_p_val_longreal';

{ Internal declarations for built-in functionality }

{ For GNU malloc }
procedure HeapWarning                     (s : CString);                             asmname '_p_heap_warning';

{ For signal handlers }
procedure PrintMessage (Message : CString; n : Integer; Warning : Boolean);          asmname '_p_prmessage';

{ Returns a description for a signal }
function CStringStrSignal (Signal : Integer) : CString; asmname '_p_c_strsignal';

const { from types.h }
  Binding_Name_Length = 255;

type
  { The standard fields are Bound and Name. The others are extensions. }
  GPC_BindingType = {@@packed} record
                      Bound             : Boolean;
                      Force             : Boolean;      { Can be set to allow binding to non-writable files or directories }
                      Extensions_Valid  : Boolean;
                      Readable          : Boolean;
                      Writable          : Boolean;
                      Executable        : Boolean;
                      Existing          : Boolean;      { Binding points to an existing file }
                      Directory         : Boolean;      { Binding points to an existing directory; `Existing' is False then }
                      Size              : LongInt;      { Number of elements or -1 }
                      AccessTime,                       { Time of last access }
                      ModificationTime,                 { Time of last modification }
                      ChangeTime        : GPC_UnixTimeType; { Time of last inode change }
                      User,                             { User ID of owner }
                      Group,                            { Group ID of owner }
                      Mode,                             { Protection mode, cf. ChMod }
                      INode             : Integer;      { Unix INode number }
                      CFile             : GPC_CFilePtr; { allows binding a Pascal file to a C file }
                      Name              : String (Binding_Name_Length)
                    end;

procedure GPC_Bind         (var aFile : AnyFile; protected var aBinding : BindingType); asmname '_p_bind';
procedure GPC_Unbind       (var aFile : AnyFile);                                       asmname '_p_unbind';

var
  GPC_FileMode : asmname '_p_filemode' Integer;

procedure GPC_Flush (var aFile : AnyFile);                                        asmname '_p_flush';

function GPC_GetFile (protected var aFile : AnyFile) : GPC_CFilePtr;                          asmname '_p_getfile';

function PExecuteC (ProgramName : CString; ArgV: GPC_PCStrings; This_PName, Temp_Base : CString;
                    var ErrMsg_Fmt, ErrMsg_Arg : CString; Flags : Integer) : Integer; asmname 'pexecute';

{ Various other versions of Reset, Rewrite and Extend are still overloaded magically }
procedure GPC_Rewrite  (          var aFile : AnyFile; aFileName : CString; aLength : Integer); asmname '_p_rewrite';
procedure GPC_Extend   (          var aFile : AnyFile; aFileName : CString; aLength : Integer); asmname '_p_extend';
procedure GPC_Reset    (          var aFile : AnyFile; aFileName : CString; aLength : Integer); asmname '_p_reset';
procedure GPC_Close    (          var aFile : AnyFile);                                        asmname '_p_close';
procedure GPC_Erase    (          var aFile : AnyFile);                                        asmname '_p_erase';
procedure GPC_Rename   (          var aFile : AnyFile; NewName : CString);                     asmname '_p_rename';
Procedure GPC_ChDir    (Path : CString);                                                       asmname '_p_chdir';
Procedure GPC_MkDir    (Path : CString);                                                       asmname '_p_mkdir';
Procedure GPC_RmDir    (Path : CString);                                                       asmname '_p_rmdir';
procedure GPC_Erase    (          var aFile : AnyFile);                                        asmname '_p_erase';
procedure GPC_Rename   (          var aFile : AnyFile; NewName : CString);                     asmname '_p_rename';
Procedure GPC_ChDir    (Path : CString);                                                       asmname '_p_chdir';
Procedure GPC_MkDir    (Path : CString);                                                       asmname '_p_mkdir';
Procedure GPC_RmDir    (Path : CString);                                                       asmname '_p_rmdir';

{ Random access file routines, from randfile.c }

function  GPC_GetSize      (          var aFile : AnyFile) : Integer;           asmname '_p_getsize';
procedure GPC_Truncate     (          var aFile : AnyFile);                     asmname '_p_truncate';
procedure GPC_DefineSize   (          var aFile : AnyFile; NewSize :  Integer); asmname '_p_definesize';
procedure GPC_SeekAll      (          var aFile : AnyFile; NewPlace : Integer); asmname '_p_seekall';
procedure GPC_SeekRead     (          var aFile : AnyFile; NewPlace : Integer); asmname '_p_seekread';
procedure GPC_SeekWrite    (          var aFile : AnyFile; NewPlace : Integer); asmname '_p_seekwrite';
procedure GPC_SeekUpdate   (          var aFile : AnyFile; NewPlace : Integer); asmname '_p_seekupdate';
function  GPC_Empty        (protected var aFile : AnyFile) : Boolean;           asmname '_p_empty';
procedure GPC_Update       (          var aFile : AnyFile);                     asmname '_p_update';
function  GPC_LastPosition (          var aFile : AnyFile) : Integer;           asmname '_p_lastposition';
function  GPC_Position     (          var aFile : AnyFile) : Integer;           asmname '_p_position';

{ Versions with only 3 parameters are still overloaded magically }
(*@@*)procedure GPC_BlockRead  (var aFile : File;           var Buf : Void; Count : Cardinal; var BytesRead    : Cardinal); asmname '_p_blockread';
(*@@*)procedure GPC_BlockWrite (var aFile : File; protected var Buf : Void; Count : Cardinal; var BytesWritten : Cardinal); asmname '_p_blockwrite';

{ Routines to output various things, from write.c }

procedure GPC_Page      (var aFile : Text);                       asmname '_p_page';
procedure GPC_Put       (var aFile : AnyFile);                    asmname '_p_put';

{ Transcendental functions for Reals and LongReals }

function Real_Sin        (x : Double)                : Double;   asmname '_p_sin';
function Real_Cos        (x : Double)                : Double;   asmname '_p_cos';
function Real_Arctan     (x : Double)                : Double;   asmname '_p_arctan';
function Real_Sqrt       (x : Double)                : Double;   asmname '_p_sqrt';
function Real_Ln         (x : Double)                : Double;   asmname '_p_ln';
function Real_Exp        (x : Double)                : Double;   asmname '_p_exp';
function LongReal_Arctan (x : LongReal)              : LongReal; asmname '_pp_arctan';
function LongReal_Sqrt   (x : LongReal)              : LongReal; asmname '_pp_sqrt';
function LongReal_Ln     (x : LongReal)              : LongReal; asmname '_pp_ln';
function LongReal_Exp    (x : LongReal)              : LongReal; asmname '_pp_exp';
function LongReal_Sin    (x : LongReal)              : LongReal; asmname '_pp_sin';
function LongReal_Cos    (x : LongReal)              : LongReal; asmname '_pp_cos';

{ Extended Pascal `**' operator }
function Real_Power      (x, y : Double)             : Double;   asmname '_p_expon';
function LongReal_Power  (x, y : LongReal)           : LongReal; asmname '_pp_expon';

function StatusExited     (Status : Integer) : Boolean; asmname '_p_WIfExited';
function StatusExitCode   (Status : Integer) : Integer; asmname '_p_WExitStatus';
function CSystem (CmdLine : CString) : Integer; asmname '_p_csystem';
procedure CSetEnv (VarName, Value, NewEnvCString : CString; UnSet : Boolean); asmname '_p_csetenv';

type
  TCPasswordEntry = record
    UserName, RealName, Password, HomeDirectory, Shell : CString;
    UID, GID : Integer
  end;

  PCPasswordEntries = ^TCPasswordEntries;
  TCPasswordEntries = array [0 .. MaxInt] of TCPasswordEntry;

function  CGetPwNam (UserName : CString; var Entry : TCPasswordEntry) : Boolean; asmname '_p_cgetpwnam';
function  CGetPwUID (UID : Integer;      var Entry : TCPasswordEntry) : Boolean; asmname '_p_cgetpwuid';
function  CGetPwEnt (var Entries : PCPasswordEntries) : Integer; asmname '_p_cgetpwent';

implementation

end.
