-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkSpinButton objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_SPIN_BUTTON_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, append_parent_declaration, parent_inherit
		end

	CHILD

creation

	make

feature

		
	type: STRING is "GTK_SPIN_BUTTON"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			climb_rate := widget_tree.get_integer_string_from_field("climb_rate")
			digits := widget_tree.get_integer_string_from_field("digits")
			numeric := widget_tree.get_boolean_string_from_field("numeric")
			update_policy := widget_tree.get_string_from_field("update_policy")
			snap := widget_tree.get_boolean_string_from_field("snap")
			wrap := widget_tree.get_boolean_string_from_field("wrap")
			hvalue := widget_tree.get_real_string_from_field("hvalue")
			hlower := widget_tree.get_real_string_from_field("hlower")
			hupper := widget_tree.get_real_string_from_field("hupper")
			hstep := widget_tree.get_real_string_from_field("hstep")
			hpage := widget_tree.get_real_string_from_field("hpage")
			hpage_size := widget_tree.get_real_string_from_field("hpage_size")
		end
			
	climb_rate: STRING
	digits: STRING
	numeric: STRING
	update_policy: STRING
	snap: STRING
	wrap: STRING
	hvalue: STRING
	hlower: STRING
	hupper: STRING
	hstep: STRING
	hpage: STRING
	hpage_size: STRING
	
	append_parent_declaration(code: ARRAY[STRING]) is
		do
			code.add_last(name + ": " + type)
			code.add_last(name + "_adjustment: GTK_ADJUSTMENT")
		end

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + "_adjustment.make("+ hvalue + ", " +
				hlower + ", " + hupper + ", " + hstep + ", " + hpage + ", " + 
				hpage_size + ")")
			code.add_last("!!" + name + ".make(" + name + "_adjustment, " +
				climb_rate + ", " + digits + ")")
			code.add_last(name + ".set_numeric(" + numeric +")")
			code.add_last(name + ".set_update_policy("+ update_policy +")")
			code.add_last(name + ".set_snap_to_ticks("+ snap +")")
			code.add_last(name + ".set_wrap("+ wrap +")")
			add_widget_code(code)
		end

	parent_inherit: INHERIT_LIST is
		local
			temp: KLASS
		do
			!!Result.make
			!!temp.make_with_name("GTK_SPIN_BUTTON_EXTERNALS")
			temp.add_undefine_clause("is_equal, copy")
			Result.add(temp)
		end

end
