-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkEntry objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_ENTRY_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end

	CHILD

creation

	make

feature

		
	type: STRING is "GTK_ENTRY"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			editable := widget_tree.get_boolean_string_from_field("editable")
			text_visible := widget_tree.get_boolean_string_from_field("text_visible")
			text_max_length := widget_tree.get_string_from_field("text_max_length")
			text := widget_tree.get_string_from_field("text")
		end
			
	text: STRING
	editable: STRING
	text_visible: STRING
	text_max_length: STRING
	
	append_parent_creation(code: ARRAY[STRING]) is
		do
			if text_max_length > "0" then
				code.add_last("!!" + name + ".make_with_max_length("+text_max_length+")")
			else
				code.add_last("!!" + name + ".make")
			end
			code.add_last(name + ".set_text(%"" + text +"%")")
			code.add_last(name + ".set_editable("+editable+")")
			code.add_last(name + ".set_visible("+text_visible+")")
			add_widget_code(code)
		end

end
