/*
  html.cc

  Copyright (c) 1996 Roland Wunderling, Malte Zoeckler
  Copyright (c) 1998 Michael Meeks
  Copyright (c) 1998-99 Dragos Acostachioaie

  This file is part of DOC++.

  DOC++ is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public
  License as published by the Free Software Foundation; either
  version 2 of the license, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <assert.h>
#include <ctype.h>
#ifdef __BORLANDC__
#include <dir.h>
#endif
#if defined(__VISUALC__) || defined(__WATCOMC__)
#include <direct.h>
#endif
#include <errno.h>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "McHashTable.h"
#include "McSorter.h"
#include "classgraph.h"
#include "doc.h"
#include "gifs.h"
#include "java.h"

extern bool	withTables;			// --tables
extern bool	withBorders;			// --tables-border
extern char*    ownFooter;			// --footer FILE
extern bool	javaGraphs;			// --no-java-graphs
extern bool	trivialGraphs;			// --trivial-graphs
extern bool	useGeneral;			// --no-general
extern bool	shortFilenames;			// --short-filenames
extern bool	sortEntries;			// --sort
extern char*    ownHeader;			// --header FILE

#define max(a,b) ((a)>(b) ? (a) : (b))

#define BGCOLOR "<BODY BGCOLOR=\"#ffffff\">\n"

static McString header, footer;
static char *HTML_SUFFIX="html";
static char *GENERAL_NAME="General.";
FILE *generalf;

static McString indexHeader("<HTML>\n<HEAD>\n   <TITLE>Table of Contents</TITLE>\n"
			   "   <META NAME=\"GENERATOR\" CONTENT=\"DOC++ " DOCXX_VERSION "\">\n"
			   "</HEAD>\n" BGCOLOR);
static McString indexFooter("<I><A HREF=\"HIER.html\">Hierarchy of classes</A></I><P>");

static McString hierHeader("<HTML>\n<HEAD>\n   <TITLE>Hierarchy of Classes</TITLE>\n"
			   "   <META NAME=\"GENERATOR\" CONTENT=\"DOC++ " DOCXX_VERSION "\">\n"
			   "</HEAD>\n" BGCOLOR);
static McString hierFooter("<I><A HREF=\"index.html\">Alphabetic index</A></I><P>");

static McString generalHeader("<HTML>\n<HEAD>\n   <TITLE>General Bits</TITLE>\n"
			   "   <META NAME=\"GENERATOR\" CONTENT=\"DOC++ " DOCXX_VERSION "\">\n"
			   "</HEAD>\n" BGCOLOR);

static McString pageHeader(BGCOLOR);
static McString pageFooter("<I><A HREF=\"index.html\">Alphabetic index</A></I>"
			   " <I><A HREF=\"HIER.html\">Hierarchy of classes</A></I></P>");
static McString pageFooterJava("<I><A HREF=\"index.html\">Alphabetic index</A></I>"
			   " <I><A HREF=\"HIER.html\">HTML hierarchy of classes</A>"
			   " or <A HREF=\"HIERjava.html\">Java</A></I><P>");

void writeTOCentry(FILE *f,Entry *e,int memo, int dup=0) ;

int makedir(const char *d, int perm)
{
#if defined(__BORLANDC__) || defined(__WATCOMC__)
  return mkdir(d);
#else
#ifdef __VISUALC__
  return _mkdir(d);
#else
  return mkdir(d, perm);
#endif
#endif
}

#define myisalnum(c) ((c>='a' && c<='z')||(c>='A' && c<='Z')||\
		      (c>='0' && c<='9')||c=='_'||c=='.'||c=='-')

char *makeFileName(const char* str, Entry *e)
{
    static McHashTable<char *,int> files(1);
    McString s,ls;
    int l=strlen(str);
    static int cnt=0;
    int odd = 0 ;	// An unusual thing ...

    if (shortFilenames){
	s="f";
	cnt++;
	char buf[40];
	sprintf(buf,"%d",cnt);
	s+=buf;
    } else {
	for (int i=0 ; i<l ; i++){
	    if (myisalnum(str[i])){
	      char c=str[i];
	      s+=c;
	      if (c>='A' && c<='Z')
		c+=(((int)'a')-'A');
	      ls+=c;
	    }
	}
	char *tmp=strdup(ls);
	int *val=files.insert(tmp);
	if (*val>1) {
	    free(tmp);
	    s+='.';
	    char buf[40];
	    sprintf(buf,"%d",*val);
	    s+=buf;
	    odd = 1 ;
	}
	(*val)++;
    }
    s+=".";
    s+=HTML_SUFFIX;

#ifdef DEBUG
    if(verb && odd)
    {
	fprintf(stderr, "Warning: weird file name `%s'\n", (char *)s);
	e->dump(stdout) ;
    }
#endif
    return strdup((const char *)s) ;
}

enum _outType { DOC = 1,
		MEMO = 2 } ;
void htmlComment (FILE *f, Entry *e, int t)
{
  static int done ;
  char start[] = "<BLOCKQUOTE>" ;
  char end[]  = "</BLOCKQUOTE>" ;

  done = 0 ;
  if ((t&DOC) && e->doc.length()>1)
    {
      fprintf(f,"%s%s%s\n", start, (e->hdoc), end) ;
      done =  1 ; 
    }
  if ((t&MEMO) && !done && e->memo.length()>1)
    fprintf(f,"%s%s%s\n", start, (e->hmemo), end) ;
}

int subEntryIsToBeDocumented(Entry *entry)
{
    int toBeDocumented = 0;
    if (entry->protection!=PRIV || withPrivate) {
	if (entry->retrn.length()  ||
	    entry->param.size() || entry->author.length() ||
	    entry->see.size()   || entry->version.length())
	    toBeDocumented = 1;
	if (entry->doc.length() > entry->memo.length() || 
	    (entry->doc.length() == entry->memo.length() &&
	     entry->doc == (const char *)entry->memo))
	    toBeDocumented = 1;

	if (alwaysPrintDocSection)
	    toBeDocumented = 1;
    }

    return toBeDocumented;
}

// Writes classgraphs. Either as text-graphs or as java-graphs.
class ClassGraphWriter
{
public:
    static void writeJava(FILE *f,Entry *e,int directOnly=1);
    static void writeText(FILE *f,Entry *e);
    static void write(FILE *f,Entry *e);
	static void writeImplements(FILE *f,Entry *e);
};

// This class writes members.
class MemberWriter
{
protected:
    McString heading;
    int first;
    FILE *f;
    virtual char* startString()
      {
      return "<P><DL>";
      };
    virtual char* endString()
      {
      return "</DL></P>";
      };
    virtual void showSubMembers(Entry *);
    struct ListEntry {
	Entry* entry;
	int links;
	int withSub;
    };
    McDArray<ListEntry> list;
    virtual void writeMember(Entry *e, int links, int withSub = 1);
    class EntryCompare {
    public:
	int operator()(const ListEntry& l1,const ListEntry& l2) {
	    return strcmp(l1.entry->name,l2.entry->name);
	}
    };
public:
    virtual void sort() {
	EntryCompare comp;
	if (list.size())
	    ::sort((ListEntry *)list,list.size(),comp,0);
    }
    virtual void startList(FILE *f,char *heading,int withLinks);
    virtual void addMember(Entry *e, int links,int withSub=1) {
	ListEntry le;
	le.entry=e;
	le.links=links;
	le.withSub=withSub;
	list.append(le);
    }
    virtual void endList();
    virtual ~MemberWriter() {} ;
};

class MemberWriterTable : public MemberWriter
{
 protected:
  virtual char *startString()
    {
    return (withBorders ? "<P><TABLE BORDER>" : "<P><TABLE>");
    };

  virtual char *endString()
    {
    return "</TABLE></P>";
    };

  virtual void writeMember(Entry *e, int links, int withSub = 1);
};

// Renamed from 'SortedList' as far too specific now...
class TOClist : public MemberWriter
{
protected:
    struct ListEntry {
	Entry *e;
        TOClist *tl ;
	char *name;
    };
    McDArray<ListEntry> list;
public:
    virtual void sort() {
	EntryCompare comp;
	if (list.size()>1)
	    ::sort((ListEntry *)list,list.size(),comp,0);
	// Sort subsections
	for (int lp=0;lp<list.size();lp++)
	  if (list[lp].tl)
	    list[lp].tl->sort() ;
    }
    class EntryCompare {
    public:
	int operator()(ListEntry& l1, ListEntry& l2) {
	    return strcmp(l1.name, l2.name);
	}
    };
    void addEntry(Entry *entry, TOClist *tl) ;
    void write(FILE *f);
    int  size() { return list.size() ; }
    ~TOClist();
};

void TOClist::write(FILE *f)
{
  // Resolve conflicts, get meaningful data from WriteTOCentry
  //    (f, entry, 1), and go for it... merge writeTOCEntry into this ?
  // As a further burden, try and merge duplicate ClassName link references
  // ALSO, do sub lists
    int i, last_collision = 0, size = list.size(), inUL = 0;
    for(i = 0; i < size; i++)
      {
	ListEntry *le, *nle ;
	le = &list[i] ;

	if (i < size-1)
	    nle = &list[i+1] ;
	else nle = 0 ;

	// Skip identical entries (eg. loads of constructors in a class )
	// ---
	// Global functions that are overloaded get seen as indentical,
	// but they in fact have different documentation, which is why we 
	// check for fileName as well <cpbotha@bigfoot.com>
	if(nle && strcmp(le->name, nle->name) == 0 && le->tl == nle->tl)
	    continue ;

	// Detect identicaly named entries ( eg. lots of next() )
	// ---
	// See comment above about overloaded global functions 
	// <cpbotha@bigfoot.com>
	int conf = nle && (strcmp(le->e->fullName, nle->e->fullName) == 0);
	if (conf != last_collision && conf) {
	    fprintf(f, "<LI><B>%s:</B>\n<UL>\n", (char *)le->e->name);
	    inUL = 1 ;
	}

	fprintf (f, "<LI>") ;
	writeTOCentry (f, le->e, 1, (conf | last_collision)) ;

	if (conf != last_collision && !conf) {
	  fprintf (f, "</UL>\n") ;
	  inUL = 0 ;
	}

	if (le->tl)	// A dreaded sub-list eg. package list
	  {
	  fprintf (f, "<UL>") ;
	  le->tl->write(f) ;
	  fprintf (f, "</UL>") ;
	  }
	last_collision = conf ;
      }
    if (inUL) // Some odd thing happened at the end of the list ...
      fprintf (f, "</UL>\n") ;
}

void TOClist::addEntry(Entry *entry, TOClist *tl)
{
  ListEntry le;

  // don't show class members in the TOC... due to popular demand
  // do the same with structure members
  if(!showMembersInTOC)
    if(entry->parent->section == CLASS_SEC || entry->parent->section == UNION_SEC)
      return;

  le.e = entry;
  le.tl = tl;
  le.name = strdup(entry->fullName);
  list.append(le);
}

TOClist::~TOClist()
{
  for (int i=0 ; i<list.size() ; i++)
    {
      if (list[i].tl)
	free (list[i].tl) ;
      if (list[i].name)
	free(list[i].name);
    }
}

void MemberWriter::showSubMembers(Entry *e)
{
  Entry *tmp;
  fprintf(f, "%s\n", startString());
  for(tmp = e->sub; tmp; tmp = tmp->next)
    writeMember(tmp, 1);
  fprintf(f, "%s\n", endString());
}

void printRefLabel(FILE *f, Entry *entry) 
{
  fprintf(f, "\n<A NAME=\"%s\">\n<A NAME=\"DOC.", (const char *)entry->name);
  entry->dumpNumber(f);
  fprintf(f, "\">\n");
}

void MemberWriter::writeMember(Entry *entry, int link, int withSub)
{
  if(first)
    {
    fprintf(f, "%s\n%s", startString(), (const char *)heading);
    first = 0;
    }

  if(!subEntryIsToBeDocumented(entry) && link)
    printRefLabel(f, entry);

  fprintf(f, "<DT>\n");
  if(subEntryIsToBeDocumented(entry) && link)
    {
    fprintf(f, "<A HREF=\"#DOC.");
    entry->dumpNumber(f);
    fprintf(f, "\"><IMG ALT=\"[more]\" BORDER=0 SRC=icon1.gif></A>");
    }
   else
    if(entry->section != MANUAL_SEC)
      fprintf(f, "<IMG ALT=\"o\" SRC=icon2.gif>");
     else 
      fprintf(f, "<P>");

  fprintf(f, "%s ", entry->htype);
  fprintf(f, "<B>%s</B>%s\n", entry->hname, entry->hargs);

  if(link)
    fprintf(f, "<DD><I>%s</I>\n", entry->hmemo);

  if(entry->sub && withSub)
    showSubMembers(entry);
}

void MemberWriter::startList(FILE *file, char *head, int withLinks)
{
  f = file;
  heading = head;
  first = 1;
  list.resize(0);
}

void MemberWriter::endList()
{
  if(sortEntries)
    sort();

  for(int i = 0; i < list.size(); i++)
    writeMember(list[i].entry, list[i].links, list[i].withSub);

  if(!first)
    fprintf(f, "%s\n\n", endString());
}

void MemberWriterTable::writeMember(Entry *entry, int link, int withSub)
{
    if (first) {
	fprintf(f,"%s\n%s",startString(),(const char *)heading);	
	first=0;
    }
    fprintf(f,"<TR>");
    fprintf(f,"<TD VALIGN=top>");

    if (!subEntryIsToBeDocumented(entry) && link) 
	printRefLabel(f,entry);

    if (subEntryIsToBeDocumented(entry) && link) {
	fprintf( f, "<A HREF=\"#DOC." ) ;
	entry->dumpNumber( f ) ;
	fprintf(f, "\"><IMG ALT=\"[more]\" BORDER=0 SRC=icon1.gif></A>");
    } else if (entry->section!=MANUAL_SEC){
	fprintf(f, "<IMG ALT=\"o\" SRC=icon2.gif>");
    } else fprintf(f,"<P>");

    char *args=entry->hargs;
    char *type=entry->htype;

    fprintf(f, "%s ", type);
    fprintf(f,"</TD><TD>");
    fprintf(f,"<B>%s</B> %s<BR>",entry->hname,args);

    if (link)
	fprintf(f,"\n<I>%s</I>\n",(entry->hmemo));
    if(entry->sub && withSub)
	showSubMembers(entry);
    fprintf(f,"</TD></TR>");  
}

void ClassGraphWriter::writeJava(FILE *f,Entry *entry,int directOnly)
{
    ClassGraph	cg( entry, 0 );
    ClassGraph*	cls = &cg ;
    cg.addBases() ;

    if (directOnly)
	cg.addDirectChilds() ;
    else
	cg.addAllChilds() ;

    McString classes,before,after,indent;
    char first=1;
    int numLines=0,longest=0;
    for( cls = cg.firstLine ; cls ; cls = cls->nextLine ){
	numLines++;    
	if (first)
	    first=0;
	else {
	    classes+=",";
	    before +=",";
	    after  +=",";
	    indent +=",";
	}
	if (cls->entry){
	    if (longest<cls->entry->name.size())
		longest=cls->entry->name.size();
	    
	    if (cls->entry->section==CLASS_SEC)
		classes+="C";
	    else
		classes+="I";
	    classes+=cls->entry->name;
	    classes+=",M";
	    classes+=cls->entry->fileName;
	} else {
	    if (longest<cls->name.size())
		longest=cls->name.size();
	    classes+="M"+cls->name;
	    classes+=",M";
	}
	before+="M"+cls->before;
	after+="M"+cls->after;
	char buf[40];
	sprintf(buf,"%d",cls->indent);
	indent+=buf;
    }
    
    fprintf(f,"<APPLET CODE=\"ClassGraph.class\" WIDTH=600 HEIGHT=%d>\n",
	    numLines*30+5);
    fprintf(f,"<param name=classes value=\"%s\">\n",(const char *)classes);
    fprintf(f,"<param name=before value=\"%s\">\n",(const char *)before);
    fprintf(f,"<param name=after value=\"%s\">\n",(const char *)after);
    fprintf(f,"<param name=indent value=\"%s\">\n",(const char *)indent);
    fprintf(f,"<param name=arrowdir value=");
    if (upArrows)
	fprintf(f,"\"up\">\n");
    else
	fprintf(f,"\"down\">\n");

  fprintf(f,"</APPLET>\n");    
}

void ClassGraphWriter::writeText(FILE *f,Entry *e)
{
    int i;
    for (i=0 ; i<max(1,e->baseclasses.size()) ; i++){
	if (i < e->baseclasses.size() && e->baseclasses[i]->section == INTERFACE_SEC) {
	    if (i==0) {
		fprintf(f, "<H3>%s</H3>\n", e->hname);
	    }
	    continue;
	}
	fprintf(f,"<H3>%s\n",e->hname);
	Entry* c=e ;
	while (c->baseclasses.size()>0){
	    if (c==e) c=c->baseclasses[i]; else  c=c->baseclasses[0];
	    if (c)
		fprintf(f,"- <A HREF=\"%s\">%s</A>\n",(const char*)(c->fileName),
			(const char*)(c->hname));
	    else
		fprintf(f,"- %s</A>\n",(const char*)(c->name));  
	}
	fprintf(f, "</H3>\n");
    }
}

void ClassGraphWriter::write(FILE *f,Entry *e)
{
    if (javaGraphs)
	writeJava(f,e);
    else 
	writeText(f,e);
}

void ClassGraphWriter::writeImplements(FILE *f,Entry *e)
{
    int i,first=1;
    for (i=0 ; i<e->baseclasses.size() ; i++){
		if (e->baseclasses[i]->section != INTERFACE_SEC)
			continue;

		if (first) 
			fprintf(f, "<HR>\n<H2>Implements:</H2>\n");
		first=0;

		Entry* c=e->baseclasses[i];
			if (i>0)
				fprintf(f,", ");
			if (c)
				fprintf(f,"<A HREF=\"%s\">%s</A>",(const char*)(c->fileName),
					(const char*)(c->hname));
		
    }
}

void copyright(FILE *f)
{
  fprintf(f, "<HR>\n");
  if(footer.length() <= 0 && ownFooter == 0)
    {
    fprintf(f, "<BR>\n");
    fprintf(f, "This page was generated with the help of <A HREF=\"http://www.imaginator.com/doc++\">DOC++</A>.\n");
    fprintf (f,"</BODY>\n");
    }
   else
    fprintf(f, "%s", (const char *)footer);
}

extern char *strToHtml(McString &in,char *dest=0, Entry* ct=0,int withLinks=0);
extern char *seeToHtml(McString &in, Entry* ct=0);

void	entry2link( McString& u, Entry* ref,const char *linkname)
{
    Entry *globref = ref ;
    if (globref!=root)
      while( globref->parent &&
	     globref->parent != root &&
	     !globref->fileName.length())
	globref = globref->parent ;
    if( ref->fileName.length()) {
	u+="<!1><A HREF=\"" ; 
	u+=ref->fileName ; 
	u+="\">" ; 
	if (linkname)
	  u+=linkname;
	else
	  u+=ref->hname ;
	u+="</A>";
    } else if (globref){
	u+="<!2><A HREF=\""+globref->fileName+"#DOC." ;
	ref->dumpNumber( u ) ;
	u+="\">" ;
	if (linkname)
	    u+=linkname;
	else
	    u+=ref->hname ;
	u+="</A>";
    }
}  

void writeTOCentry(McString &out, Entry *e, int memo, int dup=0)
{ 
  McString link = "" ;
  if(e->fileName.length())
    {
    if(dup && e->parent)
      link += "in ";
    link+= "<A HREF=\"";
    if(e->parent)
      if(e->ownPage)
	{
	if(strlen(e->fileName) > 0)
	  link += e->fileName;
         else
	  {
	  link += e->hname;
	  link += ".";
	  link += HTML_SUFFIX;
	  }
	}
       else
	{
	if(strlen(e->parent->fileName) > 0)
	  link += e->parent->fileName;
	 else
	  {
	  link += e->parent->hname;
	  link += ".";
	  link += HTML_SUFFIX;
	  }
	link += "#";
	link += e->hname;
	}
     else
      {
      link += GENERAL_NAME;
      link += HTML_SUFFIX;
      link += "#";
      link += e->hname;
      }
    link+="\">";

    if(dup && e->parent)
      {
      if(e->parent->hname && strlen(e->parent->hname) > 0)
	link += (char *)(e->parent->hname);
       else
        {
	link += "duplicate";
#ifdef DEBUG
	if(verb)
          {
	  printf("Duff link from: \n");
	  e->dump(stdout);
          }
#endif
	}
      }
     else
      {
      if(java && e->section == PACKAGE_SEC && e->name.length())
	link += e->hname;
       else
	link += e->fullName;
      }

    link += "</A>";
    }
   else
    entry2link(link, e, (const char *)(e->hname));
  out += link;
  if(memo && !java)
    {
    if(e->memo.length())
      {
      out += " <I>";
      out += (const char*)e->hmemo;
      out += "</I>\n";
      }
     else
      out += '\n';    
    }
}

void writeTOCentry(FILE *f, Entry *e, int memo, int dup)
{ 
    McString out;

    writeTOCentry(out, e, memo, dup);
    fprintf(f, "%s", (const char *)out);
}

void writeHIERentry(FILE *f,Entry *k,int memo)
{
    fprintf(f,"<LI>");
    writeTOCentry(f,k,memo);
    if( k->pubChilds.size() || k->proChilds.size() ){
	fprintf(f,"<UL>\n");
	int i ;
	for (i=0 ; i<k->pubChilds.size() ; i++){
	    writeHIERentry(f,k->pubChilds[i],memo);
	}
	for (i=0 ; i<k->proChilds.size() ; i++){
	    writeHIERentry(f,k->proChilds[i],memo);
	}
	fprintf(f,"</UL>\n");
    }
}

struct {
    int sec;
    const char *name;
} toc_sections[]={
    { MANUAL_SEC, "General stuff" },
    { PACKAGE_SEC, "Packages" },
    { NAMESPACE_SEC, "Namespaces" },
    { CLASS_SEC, "Classes" },
    { INTERFACE_SEC, "Interfaces" },
    { FUNCTION_SEC, "Functions" },
    { VARIABLE_SEC, "Variables" },
    { MACRO_SEC, "Macros" },
    { UNION_SEC, "Enums, Unions, Structs" },
    { TYPEDEF_SEC, "Typedefs" },
    { 0, 0 }
};

void writeTOCRec(TOClist& list,FILE *f,Entry *root,int section,int& first)
{ 
  int output = root->section == toc_sections[section].sec &&
    root->name.length() ;

  // Want to recurse down em all, but subtree only if output root
  TOClist *sub = 0 ;
  if (root->sublist.size())
    {
      if (output)
	sub = new TOClist() ;

      for (int i=0 ; i<root->sublist.size() ; i++)
	{
	  if (output)
	    writeTOCRec(*sub, f, root->sublist[i], section,first);
	  else
	    writeTOCRec(list, f, root->sublist[i], section,first);
	}
    }
  if (output)
    list.addEntry (root, sub) ;
}

void writeTOC(FILE *f)
{
    fprintf(f,"%s",(const char *) indexHeader);
    fprintf(f, "\n<H1>Table of Contents</H1>\n");
    int first=1;
    for (int k=0 ; toc_sections[k].name ; k++)
      {
	first=1;
	TOClist list;
	writeTOCRec(list,f,root,k,first);
	if (list.size()>0)
	  {
	    list.sort();
	    fprintf(f,"<H2>%s</H2>\n",toc_sections[k].name);
	    fprintf(f,"<UL>\n");
	    list.write(f);
	    fprintf(f,"</UL>\n");
	}
	// Javadoc compatibility: fairly sure this is what it does.
	if (java && toc_sections[k].sec == INTERFACE_SEC)
	  break ;
      }
    fprintf(f,"%s",(const char *) indexFooter);
    copyright(f);
}

void writeHIERrec(FILE *f,Entry* root)
{
    for (int i=0 ; i<root->sublist.size() ; i++){
	if (root->sublist[i]->baseclasses.size()==0)
	    if ( root->sublist[i]->isClass() 
		&&  root->sublist[i]->proBaseclasses.size() == 0
		&&  root->sublist[i]->pubBaseclasses.size() == 0 ){
		writeHIERentry(f,root->sublist[i],0);
	    }
	writeHIERrec(f,root->sublist[i]);
  }
}

void writeHIER(FILE *f)
{
  fprintf(f,"%s",(const char *) hierHeader);

  fprintf(f, "<H1>Hierarchy of Classes</H1>\n");
  fprintf(f,"<UL>\n");
  writeHIERrec(f,root);
  fprintf(f,"</UL>\n");

  fprintf(f,"%s",(const char *) hierFooter);

  copyright(f);
}

void writeHIERrecJava(FILE *f,Entry *root)
{
    for (int i=0 ; i<root->sublist.size() ; i++){
	if (root->sublist[i]->baseclasses.size()==0)
	    if (root->sublist[i]->isClass()
		&&  root->sublist[i]->proBaseclasses.size() == 0
		&&  root->sublist[i]->pubBaseclasses.size() == 0 ){
		ClassGraphWriter::writeJava(f,root->sublist[i],0);
	    }
	writeHIERrecJava(f,root->sublist[i]);
  }
}

void writeHIERjava(FILE *f)
{
    fprintf(f, "%s", (const char *)hierHeader);
    fprintf(f,"<H1>Hierarchy of classes</H1>\n");
    fprintf(f,"<UL>\n");
    writeHIERrecJava(f,root);
    fprintf(f,"</UL>\n");
    fprintf(f,"<I><A HREF=\"index.%s\"> alphabetic index</A></I><P>",HTML_SUFFIX);
    copyright(f);
}

/** This class keeps track of overloading relationships. Insert mebers
  using addMember. It returns NULL in case this is a new Member, != 0 
  otherwise.*/

class MemberList {
    McHashTable<char *,Entry *> list;
public:
    MemberList() : list((Entry*) NULL) {}
    /** Add a new member. Returns NULL, if no compatible member 
      has yet occurred.*/
  Entry *addMember(Entry *e,Entry *father) {
      McString signature;
      signature=e->name;
      if (e->language==LANG_JAVA) {
	signature+=e->args;
      }
      char *tmp=strdup((const char *)signature);
	Entry **val=list.insert(tmp);
	if (*val==0) {
	    *val=father;
	    return(0);
	} else {
#ifdef DEBUG
	    if(verb)
	      printf("Member `%s' was there\n", tmp);
#endif
	    free (tmp);
	}
	return (*val);
    }
};

void showSubMembers(FILE *f,Entry *entry);

void showMembers(Entry *e, FILE *f, int links, MemberList *ignore = 0)
{
  static struct
    {
    char *heading;
    int protection;
    int secMask;
    } sections[] = {
      { "<DT><H3>Public Classes</H3><DD>", PUBL, CLASS_SEC | UNION_SEC },
      { "<DT><H3>Public Fields</H3><DD>", PUBL, VARIABLE_SEC },
      { "<DT><H3>Public Methods</H3><DD>", PUBL, FUNCTION_SEC},
      { "<DT><H3>Public</H3><DD>", PUBL, ~(CLASS_SEC | VARIABLE_SEC | FUNCTION_SEC | UNION_SEC) },
      { "<DT><H3>Protected Classes</H3><DD>", PROT, CLASS_SEC | UNION_SEC },
      { "<DT><H3>Protected Fields</H3><DD>", PROT, VARIABLE_SEC },
      { "<DT><H3>Protected Methods</H3><DD>", PROT, FUNCTION_SEC },
      { "<DT><H3>Protected</H3><DD>", PROT, ~(CLASS_SEC | VARIABLE_SEC | FUNCTION_SEC | UNION_SEC) },
      { "<DT><H3>Private Classes</H3><DD>", PRIV, CLASS_SEC | UNION_SEC },
      { "<DT><H3>Private Fields</H3><DD>", PRIV, VARIABLE_SEC },
      { "<DT><H3>Private Methods</H3><DD>", PRIV, FUNCTION_SEC },
      { "<DT><H3>Private</H3><DD>", PRIV, ~(CLASS_SEC | VARIABLE_SEC | FUNCTION_SEC | UNION_SEC) },
      { 0, 0, 0 }};

    int i;
    Entry *tmp;
    MemberWriter *memberWriter;

    fprintf(f, "<DL>\n");
    if(withTables && links)
      memberWriter = new MemberWriterTable();
     else
      memberWriter = new MemberWriter();
    for(i = 0; sections[i].heading; i++)
      {
      if(withPrivate || sections[i].protection != PRIV)
        {
	memberWriter->startList(f, sections[i].heading, links);
	for(tmp = e->sub; tmp; tmp = tmp->next)
	  {
	  if(tmp->protection == sections[i].protection &&
	    (tmp->section & sections[i].secMask))
	    {
	    if(links || (strcmp(tmp->name, e->name) != 0 &&
	      (((const char *)tmp->name)[0] != '~' ||
	      strcmp(&((const char *)tmp->name)[1], e->name) != 0)))
	      {
	      int ignoreThisOne = 0;
	      if(ignore)
	        {
		Entry *othersFather = ignore->addMember(tmp, e);
		if(othersFather != 0 && othersFather != e)
		  ignoreThisOne = 1;
		}
	      if(!ignoreThisOne || links)
		memberWriter->addMember(tmp, links, 0);
	      }
	    }
	  }
        memberWriter->endList();
	}
      }

    delete memberWriter;
    fprintf(f, "</DL>\n");
}

void writeInherited(struct Entry *k,FILE *f,MemberList *list=0)
{
  int i;
  showMembers(k,f,0,list);
  for (i=0 ; i<k->baseclasses.size() ; i++){
    fprintf(f, "<HR><H3>Inherited from <A HREF=\"%s\">%s</A>:</H3>\n",
      (const char *)((k->baseclasses)[i]->fileName),
      (const char *)((k->baseclasses)[i]->hname));
    writeInherited((k->baseclasses)[i],f,list);
  }
}

/* This function writes the @-fields (except @memo, @name) of the
   specified entry */
void writeTags(FILE *f,Entry *entry)
{
    fprintf( f, "<DL>");    
    
    if (entry->exception.size()) {
	fprintf(f,"<DT><B>Throws:</B><DD>");
	for (int i=0 ; i<entry->exception.size() ; i++) {
	    int k=0;
	    McString s;
	    while (k<entry->exception[i]->length() && (myisalnum((*entry->exception[i])[k]) 
						       || (*entry->exception[i])[k]=='_'
                                                       || (*entry->exception[i])[k]==':'))
		s+=(*entry->exception[i])[k++];
	    fprintf(f,"<B>%s</B> ",strToHtml(s,0,entry,1));
	    while (k<entry->exception[i]->length())
		fprintf(f,"%c",(*entry->exception[i])[k++]);
	    fprintf(f,"<br>");
	}
    }
    if (entry->retrn.length()) {
	fprintf(f,"<DT><B>Returns:</B><DD>%s\n", (const char *)entry->retrn);
    }
    if (entry->param.size()) {
	fprintf(f,"<DT><B>Parameters:</B><DD>");
	for (int k=0 ; k<entry->param.size() ; k++) {
	  
	    int i=0;
	    fprintf(f,"<B>");
	    while (i<entry->param[k]->length() && 
		   (myisalnum((*entry->param[k])[i]) || 
		    (*entry->param[k])[i]=='_'))
		fprintf(f,"%c",(*entry->param[k])[i++]);
	    fprintf(f,"</B> - ");

	    while (i<entry->param[k]->length())
		fprintf(f,"%c",(*entry->param[k])[i++]);
	    fprintf(f, "<BR>");
	}
    }
    if (entry->author.length()) {
	fprintf(f,"<DT><B>Author:</B><DD>%s\n", (const char *)entry->author);
    }
    if (entry->version.length()) {
	fprintf(f,"<DT><B>Version:</B><DD>%s\n", (const char *)entry->version);
    }
    if (entry->see.size()) {
	fprintf(f,"<DT><B>See Also:</B><DD>");
	for (int k=0 ; k<entry->see.size() ; k++) {
	    if (entry->see[k]->length())
		fprintf(f, "%s<BR>", seeToHtml(*entry->see[k], entry));
	}
    }

    fprintf( f, "</DL><P>");    
}

void writeDoc(FILE *f,Entry *entry)
{  
    if (entry->ownPage)
	return;
    int toBeDocumented = subEntryIsToBeDocumented(entry);
    
    if (toBeDocumented) {
	char *args=(entry->hargs);
	char *type=(entry->htype);
	printRefLabel(f,entry ) ;
	fprintf( f, "<DT>");
	fprintf( f, "<IMG ALT=\"o\" BORDER=0 SRC=icon2.gif><TT><B>%s %s",
		 type,
		 (char *)(entry->hname));
	fprintf( f, "%s", args);	
	fprintf( f, "</B></TT>\n");

	if (entry->doc.length()>0)
	    fprintf( f, "<DD>%s\n",(char *)(entry->hdoc));
	else if (entry->memo.length()>0)
	    fprintf( f, "<DD>%s\n",(char *)(entry->hmemo));

	writeTags(f,entry);
    }
    if (entry->sub){
	fprintf(f,"<DL>\n");
	for (Entry *tmp=entry->sub ; tmp ; tmp=tmp->next){
	    writeDoc(f,tmp);
	}
	fprintf(f,"</DL>\n");
    }
}

void writeHeader(Entry *e, FILE *f)
{
  if(ownHeader == 0)
    {
    fprintf(f, "<HTML>\n");
    fprintf(f, "<HEAD>\n");
    fprintf(f, "   <TITLE>%s %s</TITLE>\n", (char *)e->type, (char *)e->fullName);
    fprintf(f, "   <META NAME=\"GENERATOR\" CONTENT=\"DOC++ " DOCXX_VERSION "\">\n");
    fprintf(f, "</HEAD>\n" BGCOLOR);
    }
   else
    fprintf(f, "%s\n", (const char *)header);

  if(showFilenames && e->section != PACKAGE_SEC && e->section != MANUAL_SEC)
    fprintf(f, "In file %s:", (const char *)e->file);

  if(e->section == PACKAGE_SEC || e->section == NAMESPACE_SEC)
    {
    McString tmp;
    e->getPackage(tmp);
    fprintf(f, "<H2>%s %s</H2>",
      (e->language == LANG_JAVA ? "Package" : "Namespace"), (char *)tmp);
    }
   else
    {
    fprintf(f, "<H2>");
    if(e->language == LANG_JAVA)
      {
      McString tmp;
      e->getPackage(tmp);
      fprintf(f, "%s <A HREF=\"#DOC.DOCU\">%s.%s", e->htype, (const char *)tmp,
        e->hname);
      }
     else
      fprintf(f, "%s <A HREF=\"#DOC.DOCU\">%s", e->htype, e->hname);

    fprintf(f, "</A>%s</H2>\n", (const char*)(e->hargs));
    }
  htmlComment(f, e, MEMO);
}

void writeManPage(Entry *e, FILE *f)
{
  int i, numChilds, numParents = 0;
  Entry *c, *tmp;
  MemberList list;
  MemberWriter memberWriter;

#ifdef DEBUG
  if(verb)
    printf("Writing page for `%s %s'\n", (const char *)e->type,
      (const char *)e->name);
#endif

  // the page header
  writeHeader(e, f);

  if(e->isClass())            // is it really a class?
    { 
    // the inheritance
    numChilds = e->pubChilds.size() + e->proChilds.size() + e->priChilds.size();
    if(e->language == LANG_JAVA)
      numParents = e->pubBaseclasses.size()+ e->proBaseclasses.size() +
        e->otherPubBaseclasses.size() + e->otherProBaseclasses.size();
     else
      numParents = e->pubBaseclasses.size() + e->priBaseclasses.size() +
	e->proBaseclasses.size() + e->otherPubBaseclasses.size()+
	e->otherPriBaseclasses.size() + e->otherProBaseclasses.size();

    if(numParents > 0 || numChilds > 0 || trivialGraphs)
      {
      fprintf(f, "<HR>\n\n<H2>Inheritance:</H2>\n");
      ClassGraphWriter::write(f, e);
      if(e->language == LANG_JAVA && e->implements.size() > 0)
	ClassGraphWriter::writeImplements(f, e);
      }

    // the members 
    if(e->sub)
      {
      fprintf(f, "<HR>\n\n");
      showMembers(e, f, 1, &list);
      }
    }
   else                       // this is not a class
    { 
    if(e->sub)
      {
      fprintf(f, "\n<HR>\n");
      memberWriter.startList(f, " ", 1);
      for(tmp = e->sub; tmp; tmp = tmp->next)
        memberWriter.addMember(tmp, 1, 0);
      }
    memberWriter.endList();
    }

  // the inherited members
  if(e->isClass())            // is it really a class?
    { 
    if(showInherited)
      for(i = 0; i < e->baseclasses.size(); i++)
        {
        fprintf(f, "<HR><H3>Inherited from <A HREF=\"%s\">%s</A>:</H3>\n",
	  (const char *)((e->baseclasses)[i]->fileName),
	  (const char *)((e->baseclasses)[i]->hname));
	writeInherited((e->baseclasses)[i], f, &list);
	}
    }

  // the documentation
  fprintf(f, "\n<A NAME=\"DOC.DOCU\">\n");
  fprintf(f, "<HR>\n<H2>Documentation</H2>\n");
  htmlComment (f, e, (DOC | MEMO));
  fprintf(f, "<DL>\n");
  for(tmp = e->sub; tmp; tmp = tmp->next)
    writeDoc(f, tmp);
  fprintf(f, "</DL>\n");

  // the childrens
  if(e->isClass())            // is it really a class?
    { 
    if(e->pubChilds.size() || e->proChilds.size())
      {
      fprintf(f, "<HR>\n<DL><DT><B>Direct child classes:\n</B><DD>");
      c = e;
      for(i = 0; i < c->pubChilds.size(); i++)
	fprintf(f, "<A HREF=\"%s\">%s</A><BR>\n",
	  (const char *)c->pubChilds[i]->fileName,
	  (const char *)c->pubChilds[i]->hname);
      for(i = 0; i < c->proChilds.size(); i++)
	fprintf(f, "<A HREF=\"%s\">%s</A><BR>\n",
	  (const char *)c->proChilds[i]->fileName,
	  (const char *)c->proChilds[i]->hname);
      fprintf(f, "</DL>\n\n");
      }
     else
      fprintf(f, "\n<HR><DL><DT><B>This class has no child classes.</B></DL>\n\n");
  }

  writeTags(f, e);
  if(javaGraphs)
    fprintf(f, "%s", (const char *)pageFooterJava);
   else
    fprintf(f, "%s", (const char *)pageFooter);

  copyright(f);
}

FILE *myOpen(const char *dir,const char *name)
{
  FILE *f;
  McString buf = dir ;
  buf+=PATH_DELIMITER ;
  buf+=name ;
#ifdef DEBUG
  if(verb)
    printf ("Opening `%s'\n", (char *)buf) ;
#endif
  if(!(f = fopen((char *)buf, "wb")))
    {
    fprintf(stderr, "Cannot open `%s'\n", (char *)buf);
    exit(-1);
    }
  return f;
}

void makeHtmlNames(Entry *entry)
{
  Entry *tmp;
  entry->hname = strToHtml(entry->name, 0, entry, 0);
  if(entry->section == EMPTY_SEC)
    entry->section = PACKAGE_SEC;

  if(entry->sub)
    for(tmp = entry->sub; tmp; tmp = tmp->next)
      makeHtmlNames(tmp);
}

// This creates names for all those with their own pages
void makeFileNames(Entry* entry)
{
    Entry *tmp;
    McString file;

    if(entry->ownPage)
    {
	if (entry->language==LANG_JAVA) {
	    McString pack;
	    if (entry->section==PACKAGE_SEC)
		file = "package-";
	    entry->getPackage(pack);
	    if (pack.length()) {
		file+=pack;
		if (entry->section!=PACKAGE_SEC)
		    file+='.'; 
	    }
	}
	if (entry->language!=LANG_JAVA || entry->section!=PACKAGE_SEC)
	{
	    if (entry->name.length())
		file+=entry->name;
	    else if (entry->section == UNION_SEC) // Struct, union, enum
	    {
		file+=entry->type ;
#ifdef DEBUG
		if (verb)
		{	// This is for unnamed enums / unions etc.
		    printf("Making name from type for:\n");
		    entry->dump(stdout) ;
		}
#endif
	    }
	}
	entry->fileName=makeFileName(file, entry);
    }
    if (entry->sub){
	for( tmp = entry->sub ; tmp ; tmp = tmp->next )
	    makeFileNames(tmp);
    }
}

// This creates filenames for items from their parents
void inheritFileNames(Entry* entry)
{
  Entry *tmp;

  if(!entry->ownPage)
    {
    tmp = entry;
    while(tmp->parent && tmp->fileName.length() == 0)
      tmp = tmp->parent;
    if(tmp != entry)
      {
      entry->fileName = (char *)tmp->fileName;
#ifdef DEBUG
      if(verb)
        printf("Copied `%s %s' into `%s'\n", (char *)entry->type,
	  (char *)entry->name, (char *)entry->fileName);
#endif
      }
    }

  if(entry->sub)
    for(tmp = entry->sub; tmp; tmp = tmp->next)
      inheritFileNames(tmp);
}

// This marks those names that can't be attached to a class eg.
// It also junks redundant floating comments as a bad job...
void relocateNames(Entry* root)
{
  Entry *e, *next ;
  e=root->sub ;
  while (e)
    {
    next = e->next ;
    if (!e->ownPage)
      {
      if (useGeneral)
        {
#ifdef DEBUG
	if (verb)
	  {
	  printf("`%s' hanging from root with no page\n", (char *)e->name);
	  e->dump(stdout) ;
	  }
#endif
	e->general = true;
	}
       else
	{
	root->removeSub(e) ;
	if (!fastNotSmall)
	  delete (e) ;
	}
      }
    e = next ;
    }	
}

// Decide what entries should have their's own page
void decideAboutOwnPages(Entry* entry)
{
  Entry *tmp;

  if(entry->section == EMPTY_SEC)
    entry->section = MANUAL_SEC;

  // The Quantel extn. bit is to stop annoying stuff like the RCS info
  // ( often in a FED fold ) from turning up in the data...
  if(entry->sub || (entry->doc.length() > 1 && !QuantelExtn) || entry->isClass())
    entry->ownPage = true;

  if(entry->sub && (entry->section == MANUAL_SEC ||
    entry->section == PACKAGE_SEC ||
    entry->section == NAMESPACE_SEC || entry->section == CLASS_SEC))
    for(tmp = entry->sub; tmp; tmp = tmp->next)
      if(entry->section != CLASS_SEC || (entry->section == CLASS_SEC &&
        tmp->section == CLASS_SEC))
        decideAboutOwnPages(tmp);
}

void makeHtml(Entry* entry)
{
    Entry*  tmp ;
    int i;
    entry->hmemo=strToHtml(entry->memo, 0, entry,0);
    entry->hdoc =strToHtml(entry->doc, 0, entry,0);
    
    entry->hargs =strToHtml(entry->args, 0, entry ,1);
    entry->htype =strToHtml(entry->type, 0, entry ,1);
    
    entry->author =strToHtml(entry->author, 0, entry ,0);
    entry->version =strToHtml(entry->version, 0, entry ,0);
    entry->retrn =strToHtml(entry->retrn, 0, entry ,0);
    for (i=0 ; i<entry->param.size() ; i++)
	*entry->param[i] = strToHtml(*entry->param[i], 0, entry ,0);

    for (i=0 ; i<entry->exception.size() ; i++)
	*entry->exception[i] = strToHtml(*entry->exception[i], 0, entry ,0);

    if (entry->sub){
	for( tmp = entry->sub ; tmp ; tmp = tmp->next )
	    makeHtml(tmp);
    }
}

void writePageSub(FILE *f, Entry *e)
{
  McString htype,hargs;

#ifdef DEBUG
  if(verb)
    printf("Writing sub for `%s %s' to file `%s'\n", (char *)e->type,
      (char *)e->name, (char *)e->fileName);
#endif

  if(withTables)
    fprintf(f, "<TR><TD VALIGN=top>");
   else
    fprintf(f, "<DT>\n");

  if(e->fileName.length() == 0 || e->general)
    {
    htype = e->htype;
    hargs = e->hargs;
    }

  fprintf(f, "\n<IMG ALT=\"o\" BORDER=0 SRC=icon1.gif>");

  if(e->section != MANUAL_SEC)
    if(withTables)
      fprintf(f, "%s </TD><TD>", (const char *)htype);
     else 
      fprintf(f, "%s ", (const char *)htype);

  if(e->fileName.length() > 0)
    fprintf(f, "<A HREF=%s><B>%s</B></A>", (const char *)e->fileName,
      (const char *)e->hname);
   else
    fprintf(f, "<B>%s</B>", (const char *)e->hname);

  if(withTables && (e->section == MANUAL_SEC && 0))
    fprintf(f, "</TD><TD>");

  if(1 || e->section != MANUAL_SEC)
    fprintf(f, "%s", (const char *)hargs);

  if(withTables)
    {
    fprintf(f, "<BR>");
    if(e->hmemo)
      fprintf(f, "<I>%s</I>\n", (const char *)e->hmemo);
    fprintf(f, "</TD></TR>");
    }
   else
    if(e->hmemo)
      fprintf(f, "<DD><I>%s</I>\n", (const char *)e->hmemo);
}

void writeManPageRec(const char *dir, Entry *e)
{
  Entry *tmp;
  FILE *f;

#ifdef DEBUG
  if(verb)
    printf("Writing `%s %s' to file `%s'\n", (char *)e->type,
      (char *)e->name, (char *)e->fileName);
#endif

  if(e->general)
    writePageSub(generalf, e);

  if(e->ownPage)
    {
#ifdef DEBUG
    if((e->fileName == (const char *)".html" || e->fileName == (const char *)".2.html") && verb)
      {
      fprintf(stderr, "Warning: weird filename `%s' for `%s %s'\n",
        (char *)e->fileName, (char *)e->type, (char *)e->name);
      e->dump(stdout);
      }
#endif
    if(!(f = myOpen(dir, (char *)e->fileName)))
      {
      fprintf(stderr, "Cannot open `%s' for writing\n", (char *)e->fileName);
      return;
      }
    if(e->section != MANUAL_SEC && e->section != PACKAGE_SEC &&
      e->section != NAMESPACE_SEC)
      writeManPage(e, f);
     else
      {
      writeHeader(e, f);
      if(e->sub)
        {
	if(withTables)
	  fprintf(f, "\n<TABLE>\n");
	 else
	  fprintf(f, "\n<HR>\n<DL>\n");
	for(tmp = e->sub; tmp; tmp = tmp->next)
	  writePageSub(f, tmp);
	if(withTables)
	  fprintf(f, "\n</TABLE>\n");
	 else
	  fprintf(f, "</DL>\n");
        }

      fprintf(f, "<A NAME=\"DOC.DOCU\">\n");
      htmlComment(f, e, (DOC | MEMO));
      writeTags(f, e);
      fprintf(f, "%s", (const char *)pageFooter);
      copyright(f);
      }
    fclose(f);
    }
  if(e->sub && (e->section == MANUAL_SEC || e->section == PACKAGE_SEC ||
    e->section == NAMESPACE_SEC || e->section == CLASS_SEC))
    for(tmp = e->sub; tmp; tmp = tmp->next)
      if(e->section != CLASS_SEC || (e->section == CLASS_SEC &&
        tmp->section == CLASS_SEC))
	writeManPageRec(dir, tmp);
}

void dumpFile(const char *dir,const char *name,const unsigned char *data,int size)
{
  FILE *f=myOpen(dir,name);
  fwrite(data,1,size,f);
  fclose(f);
}

void readTemplates()
{
  FILE *f;
  int c;
  if ((f=fopen("indexHeader.inc","r"))) {
    indexHeader=" ";
    while ((c=fgetc(f)) != EOF) indexHeader+=c;
    fclose(f);
  }
  if ((f=fopen("indexFooter.inc","r"))) {
    indexFooter=" ";
    while ((c=fgetc(f)) != EOF) indexFooter+=c;
    fclose(f);
  }
  if ((f=fopen("hierHeader.inc","r"))) {
    hierHeader=" ";
    while ((c=fgetc(f)) != EOF) hierHeader+=c;
    fclose(f);
  }
  if ((f=fopen("hierFooter.inc","r"))) {
    hierFooter=" ";
    while ((c=fgetc(f)) != EOF) hierFooter+=c;
    fclose(f);
  }
  if ((f=fopen("classHeader.inc","r"))) {
    pageHeader=" ";
    while ((c=fgetc(f)) != EOF) pageHeader+=c;
    fclose(f);
  }
  if ((f=fopen("classFooter.inc","r"))) {
    pageFooter=" ";
    while ((c=fgetc(f)) != EOF) pageFooter+=c;
    fclose(f);
  }
}

void doHTML(char *dir,Entry*)
{
    FILE *f;
    Entry *tmp;

    if( makedir( dir,0755) != 0 ) {
	if( errno == EEXIST ) {
	    FILE *exist = fopen(dir,"a");
	    if( exist ) {
		fprintf(stderr, "`%s' file already exists\n", dir);
		fclose( exist ) ;
	    }
	} else {
	    fprintf(stderr, "Could not create `%s' directory\n", dir);
	}
    }
    
    if (shortFilenames){
	HTML_SUFFIX=strdup("htm");
    }

    decideAboutOwnPages(root);
    makeFileNames(root);

    // This is as items under root with no page inherit this name
    root->fileName=GENERAL_NAME ;
    root->fileName+=HTML_SUFFIX ;
    inheritFileNames(root);
    relocateNames(root) ;

    if (root->name.length() && root->section == MANUAL_SEC){
	root->fileName="index.";
	root->fileName+=HTML_SUFFIX;
    } else if (root->sublist.size()==1	// Unconvinced about this...
	       && root->sublist[0]->section == MANUAL_SEC){
	root->sublist[0]->fileName="index.";
	root->sublist[0]->fileName+=HTML_SUFFIX;
    }

#ifdef DEBUG
  if(verb)
    {
    root->dump(stdout);
    for(tmp = root->sub; tmp; tmp = tmp->next)
      tmp->dump(stdout);
    }
#endif

    if(verb)
      printf("Converting DOC++ to HTML...\n");

    if (root->section==EMPTY_SEC)
	root->section=MANUAL_SEC;
    for( tmp = root ; tmp ; tmp = tmp->next )
	makeHtmlNames(tmp);
    for( tmp = root ; tmp ; tmp = tmp->next )	// This takes the bulk of the time
	makeHtml(tmp);

    readTemplates();
    if(verb)
      printf("Writing files...\n");
    dumpFile(dir,"logo.gif",logo,sizeof(logo));
    dumpFile(dir,"icon1.gif",blueBall,sizeof(blueBall));
    dumpFile(dir,"icon2.gif",greyBall,sizeof(greyBall));
    dumpFile(dir,"down.gif",down,sizeof(down));
    
    if(ownFooter){
	FILE *in = fopen(ownFooter, "r");
	if (!in && strcmp("none",ownFooter) && strlen(ownFooter)>1){
	    fprintf(stderr, "Warning: Can't open `%s', producing no footer.\n",
		    ownFooter);
	} else {	  
	    int	c ;
	    while ( (c = fgetc(in)) != EOF )
		footer += (char) c ;
	    fclose(in);
	}
    }

    if(ownHeader) {
	FILE *in = fopen(ownHeader, "r");
	if(!in && strcmp("none", ownHeader) && strlen(ownHeader) > 1) {
	    fprintf(stderr, "Warning: Can't open `%s', producing no header.\n",
		ownHeader);
	} else {
	    int c;
	    while((c = fgetc(in)) != EOF)
		header += (char)c;
	    fclose(in);
	}
    }
  
    if (javaGraphs){
	dumpFile(dir,"ClassGraph.class",ClassGraph_class,sizeof(ClassGraph_class));
	dumpFile(dir,"ClassGraphPanel.class",ClassGraphPanel_class,sizeof(ClassGraphPanel_class));
	dumpFile(dir,"ClassLayout.class",ClassLayout_class,sizeof(ClassLayout_class));
	dumpFile(dir,"NavigatorButton.class",NavigatorButton_class,sizeof(NavigatorButton_class));    
    }	


    McString buf ;

    // Table of contents
    buf="index." ;
    buf+=HTML_SUFFIX ;
    f=myOpen(dir,buf);
    writeTOC(f);
    fclose(f);      

    if(verb)
      printf("Writing TOC...\n");

    // Class heirarchy
    buf="HIER." ;
    buf+=HTML_SUFFIX ;
    f=myOpen(dir,buf);
    writeHIER(f);
    fclose(f);  

    // Java class heirarchy
    if(javaGraphs)
      {
      buf="HIERjava." ;
      buf+=HTML_SUFFIX ;
      f=myOpen(dir,buf);
      writeHIERjava(f);
      fclose(f);  
      }

    if(verb)
      printf("Writing Class Hierarchy...\n");

    /* Render all the rest of the pages to HTML, and output a 'General' file
       of floating #defines, global variables / functions etc. */
  {
      // We don't want root page coming out as .html !
      root->ownPage = false;
      root->general = false;

      buf = GENERAL_NAME ;
      buf+= HTML_SUFFIX ;
      generalf = myOpen(dir, buf) ;
      fprintf(generalf, generalHeader);
      if (withTables)
	  fprintf(generalf,"\n<TABLE>\n");
      else
	  fprintf(generalf,"\n<DL>\n");

      // Recursively write all pages.
      writeManPageRec(dir,root);

      if (withTables)
	  fprintf(generalf,"\n</TABLE>\n");
      else
	  fprintf(generalf,"</DL>\n");
      fprintf(generalf,"%s",(const char *) pageFooter);
      copyright(generalf);

      fclose(generalf) ;
  }
}      
      
static void	dumpEntry (FILE* out, Entry* entry,int)
{
  Entry*	tmp ;

  if (entry->sub){
    for( tmp = entry->sub ; tmp ; tmp = tmp->next )
      dumpEntry(out,tmp,0);
  }
}

void	usermanHTML(char*, Entry* root)
{
    if( root->name.length() )
	dumpEntry (out, root,1) ;
    else
	for( root=root->sub ; root ; root=root->next )
	    dumpEntry (out, root,1) ;
}
