/*
  McWildMatch.cc

  Copyright (c) 1996 Roland Wunderling, Malte Zoeckler
  Copyright (c) 1998 Michael Meeks
  Copyright (c) 1999 Dragos Acostachioaie

  This file is part of DOC++.

  DOC++ is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public
  License as published by the Free Software Foundation; either
  version 2 of the license, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public
  License along with this program; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

int mcWildMatch(const char* str, const char* pat)
{
    register int i = 0, j = 0;
    int	star = 0, k = 0;

    while (pat[i] != '\0'&& str[j] != '\0')
    {
	if (pat[i] == '*')
	{
	    star = 1;
	    while (pat[i] == '*') i++;
	    k = i;
	}
	else
	{
	    if (pat[i] == '?' || pat[i] == str[j])
	    {
	        j++; i++;
	    }
	    else
	    {
		if (star == 0)
		{
		    return 0;
		}
	        i = k;
		j++;
	    }
	}
    }

    while (pat[i] == '*') i++;

    if (pat[i] == str[j])
    {
	return 1;
    }
    else if (pat[i] == '\0' && (pat[i-1] == '*' || pat[i-1] == '?'))
    {
	return 1;
    }
    else
    {
	return 0;
    }
}
