(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(* Certification of Imperative Programs                                     *)
(* Jean-Christophe Fillitre                                                *)
(****************************************************************************)
(*                               progTypes.mli                              *)
(****************************************************************************)

(* Generated automatically by ocamlc -i *)

type 'a precondition = { p_assert: bool; p_name: Names.name; p_value: 'a }
type 'a assertion = { a_name: Names.name; a_value: 'a }
type 'a postcondition = 'a assertion 
type predicate = Term.constr assertion
type 'a binder_type = | BindType of 'a | BindSet | Untyped
type 'a binder = Names.identifier * 'a binder_type
type variant = Term.constr * Term.constr * Term.constr
type 'a ml_type_v =
  | Ref of 'a ml_type_v
  | Array of 'a * 'a ml_type_v
  | Arrow of 'a ml_type_v binder list * 'a ml_type_c
  | TypePure of 'a
and 'a ml_type_c =
  (Names.identifier * 'a ml_type_v) * Effects.t * 'a precondition list *
  'a postcondition option
type type_v = Term.constr ml_type_v
type type_c = Term.constr ml_type_c
val is_mutable : 'a ml_type_v -> bool
val is_pure : 'a ml_type_v -> bool
