(* program generated from PPML *)

(********************************************************************)
(*|                                                                |*)
(*|                              pprinter                          |*)
(*|                                                                |*)
(********************************************************************)
(*  Name : english  *)

open Ppml;;
open Ppaux;;
open Ntpprinter;;
open Ppenglish_aux;;

let def_sep_h = (0, 0);;
let def_sep_v = (0, 0);;

let nc_set_pprinter_text () =
begin
nc_set_pprinter_text_integers ();

(********************************************************************)
(*|                                                                |*)
(*|                              chapter                           |*)
(*|                                                                |*)
(********************************************************************)
(*  Name : vocabulary  *)

(

begin

(p_text_and := function c ->
box "h" def_sep_h
  [< 'String "and" >]);

(p_text_theorem := function c ->
box "h" def_sep_h
  [< 'String "Theorem" >]);

(p_text_definition := function c ->
box "h" def_sep_h
  [< 'String "Definition" >]);

(p_text_axiom := function c ->
box "h" def_sep_h
  [< 'String "Axiom" >]);

(p_text_type := function c ->
box "h" def_sep_h
  [< 'String "Type" >]);

(p_text_statement := function c ->
box "h" def_sep_h
  [< 'String "Statement" >]);

(p_text_proof := function c ->
box "h" def_sep_h
  [< 'String "Proof" >]);

(p_text_qed := function c ->
box "h" def_sep_h
  [< 'String "Q.E.D." >]);

(p_text_int := function c ->
box "h" def_sep_h
  [< 'String (nc_atm_text_int c) >]);

()

end);

(********************************************************************)
(*|                          end of chapter                        |*)
(********************************************************************)

(********************************************************************)
(*|                                                                |*)
(*|                              chapter                           |*)
(*|                                                                |*)
(********************************************************************)
(*  Name : misc  *)

(

begin

(p_definition_expl := function c ->
box "hv" (1, 0)
  [< 'String "the"; 'String "definition"; 'String "of"; 'Std_ppcmds (!p_cst c ) >]);

(p_definition_cap := function c ->
box "hv" (1, 0)
  [< 'String "The"; 'String "definition"; 'String "of"; 'Std_ppcmds (!p_cst c ) >]);

(p_id_cap := function c ->
box "hv" (1, 0)
  [< (match (nc_int_id_nat c) with
    | 1 ->
      [< (if (nc_int_is_immediate_hypothesis c) = 1 then
            [< 'String "The"; 'String "last"; 'String "hypothesis" >] else
         [< 'String "Hypothesis"; 'Std_ppcmds (pr_nc c ) >]
         ) >]
    | 2 -> [< 'String "Theorem"; 'Std_ppcmds (pr_nc c ) >]
    | 3 -> [< 'String "Axiom"; 'Std_ppcmds (pr_nc c ) >]
    | 4 -> [< 'Std_ppcmds (!p_induct_cst p_definition_cap c ) >]
    | 5 -> [< 'Std_ppcmds (!p_induct_cst p_definition_cap c ) >]
    | _ -> [< 'Std_ppcmds (pr_nc c ) >]
    ) >]);

(p_id_expl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_id_nat c) with
    | 1 ->
      [< (if (nc_int_is_immediate_hypothesis c) = 1 then
            [< 'String "the"; 'String "last"; 'String "hypothesis" >] else
         [< 'String "hypothesis"; 'Std_ppcmds (pr_nc c ) >]
         ) >]
    | 2 -> [< 'String "theorem"; 'Std_ppcmds (pr_nc c ) >]
    | 3 -> [< 'String "axiom"; 'Std_ppcmds (pr_nc c ) >]
    | 4 -> [< 'Std_ppcmds (!p_induct_cst p_definition_expl c ) >]
    | 5 -> [< 'Std_ppcmds (!p_induct_cst p_definition_expl c ) >]
    | _ -> [< 'Std_ppcmds (pr_nc c ) >]
    ) >]);

(p_id := function c ->
box "hv" (1, 0)
  [< (match (nc_int_id_nat c) with
    | 1 ->
      [< (if (nc_int_is_immediate_hypothesis c) = 1 then
            [< 'Std_ppcmds (!p_id_expl c ) >] else
         [< 'Std_ppcmds (pr_nc c ) >]
         ) >]
    | 3 -> [< 'Std_ppcmds (!p_id_expl c ) >]
    | _ -> [< 'Std_ppcmds (pr_nc c ) >]
    ) >]);

()

end);

(********************************************************************)
(*|                          end of chapter                        |*)
(********************************************************************)

(********************************************************************)
(*|                                                                |*)
(*|                              chapter                           |*)
(*|                                                                |*)
(********************************************************************)
(*  Name : types  *)

(

begin

(p_type_formula := function c ->
box "hv" (1, 0)
  [< (if (nc_int_is_type_False c) = 1 then [< 'String "a"; 'String "contradiction" >]
       else
    [< 'Std_ppcmds (!p_formula c ) >]
    ) >]);

(p_type_formula_bis := function c ->
box "hv" (1, 0)
  [< (if (nc_int_is_type_False c) = 1 then
       [< 'String "there"; 'String "is"; 'String "a"; 'String "contradiction" >] else
    [< 'Std_ppcmds (!p_formula c ) >]
    ) >]);

(p_type_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_number_of_types c) with
    | 3 -> [< 'String "to"; 'String "prove"; 'Std_ppcmds (box "h" def_sep_h
                                                       [< 'Std_ppcmds
                                                            (!p_type_3_bis c );
                                                         'String "," >]);
             'String "we"; 'String "will"; 'String "prove";
             'Std_ppcmds (!p_type_2_bis c ); 'String "which"; 'String "is";
             'String "equivalent"; 'String "to"; 'Std_ppcmds (!p_type_1 c ) >]
    | 2 -> [< 'String "to"; 'String "prove"; 'Std_ppcmds (box "h" def_sep_h
                                                       [< 'Std_ppcmds (!p_type_2
                                                            c ); 'String "," >]);
             'String "we"; 'String "will"; 'String "prove";
             'Std_ppcmds (!p_type_1_bis c ) >]
    | 1 ->
      [< 'String "we"; 'String "will"; 'String "prove";
        'Std_ppcmds (!p_type_1_bis c ) >]
    | _ -> [< 'String "ERROR type_intro" >]
    ) >]);

(p_type_intro_cap := function c ->
box "hv" (1, 0)
  [< (match (nc_int_number_of_types c) with
    | 3 -> [< 'String "To"; 'String "prove"; 'Std_ppcmds (box "h" def_sep_h
                                                       [< 'Std_ppcmds
                                                            (!p_type_3_bis c );
                                                         'String "," >]);
             'String "we"; 'String "will"; 'String "prove";
             'Std_ppcmds (!p_type_2_bis c ); 'String "which"; 'String "is";
             'String "equivalent"; 'String "to"; 'Std_ppcmds (!p_type_1 c ) >]
    | 2 -> [< 'String "To"; 'String "prove"; 'Std_ppcmds (box "h" def_sep_h
                                                       [< 'Std_ppcmds
                                                            (!p_type_2_bis c );
                                                         'String "," >]);
             'String "we"; 'String "will"; 'String "prove";
             'Std_ppcmds (!p_type_1_bis c ) >]
    | 1 ->
      [< 'String "We"; 'String "will"; 'String "prove";
        'Std_ppcmds (!p_type_1_bis c ) >]
    | _ -> [< 'String "ERROR type_intro" >]
    ) >]);

(p_type_intro_bis := function c ->
box "hv" (1, 0)
  [< (match (nc_int_number_of_types c) with
    | 3 -> [< 'String "to"; 'String "prove"; 'Std_ppcmds (box "h" def_sep_h
                                                       [< 'Std_ppcmds
                                                            (!p_type_3_bis c );
                                                         'String "," >]);
             'String "we"; 'String "will"; 'String "prove";
             'Std_ppcmds (!p_type_2_bis c ); 'String "which"; 'String "is";
             'String "equivalent"; 'String "to"; 'Std_ppcmds (!p_type_1 c ) >]
    | 2 -> [< 'String "to"; 'String "prove"; 'Std_ppcmds (box "h" def_sep_h
                                                       [< 'Std_ppcmds
                                                            (!p_type_2_bis c );
                                                         'String "," >]);
             'String "we"; 'String "will"; 'String "prove";
             'Std_ppcmds (!p_type_1_bis c ) >]
    | 1 -> [< 'String "to"; 'String "prove"; 'Std_ppcmds (!p_type_1_bis c ) >]
    | _ -> [< 'String "ERROR type_intro_bis" >]
    ) >]);

(p_type_intro_bis_cap := function c ->
box "hv" (1, 0)
  [< (match (nc_int_number_of_types c) with
    | 3 -> [< 'String "To"; 'String "prove"; 'Std_ppcmds (box "h" def_sep_h
                                                       [< 'Std_ppcmds
                                                            (!p_type_3_bis c );
                                                         'String "," >]);
             'String "we"; 'String "will"; 'String "prove";
             'Std_ppcmds (!p_type_2_bis c ); 'String "which"; 'String "is";
             'String "equivalent"; 'String "to"; 'Std_ppcmds (!p_type_1 c ) >]
    | 2 -> [< 'String "To"; 'String "prove"; 'Std_ppcmds (box "h" def_sep_h
                                                       [< 'Std_ppcmds
                                                            (!p_type_2_bis c );
                                                         'String "," >]);
             'String "we"; 'String "will"; 'String "prove";
             'Std_ppcmds (!p_type_1_bis c ) >]
    | 1 -> [< 'String "To"; 'String "prove"; 'Std_ppcmds (!p_type_1_bis c ) >]
    | _ -> [< 'String "ERROR type_intro_bis_cap" >]
    ) >]);

(p_type_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_number_of_types c) with
    | 3 ->
      [< 'Std_ppcmds (!p_type_1 c ); 'String "which"; 'String "is"; 'String "equivalent";
        'String "to"; 'Std_ppcmds (!p_type_2 c ); 'String "or";
        'Std_ppcmds (!p_type_3 c ) >]
    | 2 ->
      [< 'Std_ppcmds (!p_type_1 c ); 'String "which"; 'String "is"; 'String "equivalent";
        'String "to"; 'Std_ppcmds (!p_type_2 c ) >]
    | 1 -> [< 'Std_ppcmds (!p_type_1 c ) >]
    | _ -> [< 'String "ERROR type_concl" >]
    ) >]);

(p_type_concl_bis := function c ->
box "hv" (1, 0)
  [< (match (nc_int_number_of_types c) with
    | 3 ->
      [< 'Std_ppcmds (!p_type_1_bis c ); 'String "which"; 'String "is";
        'String "equivalent"; 'String "to"; 'Std_ppcmds (!p_type_2 c ); 'String "or";
        'Std_ppcmds (!p_type_3 c ) >]
    | 2 ->
      [< 'Std_ppcmds (!p_type_1_bis c ); 'String "which"; 'String "is";
        'String "equivalent"; 'String "to"; 'Std_ppcmds (!p_type_2 c ) >]
    | 1 -> [< 'Std_ppcmds (!p_type_1_bis c ) >]
    | _ -> [< 'String "ERROR type_concl_bis" >]
    ) >]);

(p_type_concl_ter := function c ->
box "hv" (1, 0)
  [< (match (nc_int_number_of_types c) with
    | 3 ->
      [< 'String "assert"; 'Std_ppcmds (!p_type_1_bis c ); 'String "which"; 'String "is";
        'String "equivalent"; 'String "to"; 'String "assert";
        'Std_ppcmds (!p_type_2_bis c ); 'String "or"; 'Std_ppcmds (!p_type_3 c ) >]
    | 2 ->
      [< 'String "assert"; 'Std_ppcmds (!p_type_1_bis c ); 'String "which"; 'String "is";
        'String "equivalent"; 'String "to"; 'String "assert";
        'Std_ppcmds (!p_type_2 c ) >]
    | 1 -> [< 'String "assert"; 'Std_ppcmds (!p_type_1_bis c ) >]
    | _ -> [< 'String "ERROR type_concl_ter" >]
    ) >]);

()

end);

(********************************************************************)
(*|                          end of chapter                        |*)
(********************************************************************)

(********************************************************************)
(*|                                                                |*)
(*|                              chapter                           |*)
(*|                                                                |*)
(********************************************************************)
(*  Name : introduction  *)

(

begin

(p_elim_case_intro := function c ->
box "hv" (1, 0)
  [< 'String "Case"; 'Std_ppcmds (!p_case_number c ); 'Std_ppcmds (box "h" (0, 1)
                                                                 [< (match
                                                                      (nc_int_elim_case_nat
                                                                        c) with
                                                                    | 1 ->
                                                                      [< >]
                                                                    | 2 ->
                                                                      [< 'String
                                                                           "(trivial)" >]
                                                                    | 3 ->
                                                                      [< 'String
                                                                           "(vacuous)" >]
                                                                    | 4 ->
                                                                      [< 'String
                                                                           "(base)" >]
                                                                    | 5 ->
                                                                      [< 'String
                                                                           "(inductive)" >]
                                                                    | _ ->
                                                                      [< 'String
                                                                           "ERROR elim_case_intro" >]
                                                                    );
                                                                   'String ":" >]) >]);

(p_lambda_type := function c ->
box "hv" (1, 0)
  [< (match (nc_int_lambda_sort c) with
    | 1 ->
      [< 'Std_ppcmds (!p_lambda_binder_type c );
        (if (not ((nc_int_is_lambda_var_list_anonymous c) = 1)) then
           [< 'Std_ppcmds (box "h" def_sep_h
                             [< 'String "(";
                               'Std_ppcmds (!p_lambda_var_list_hyp c );
                               'String ")" >]) >] else
        [< >]
        ) >]
    | 2 ->
      [< (if (nc_int_lambda_var_list_length c) = 1 then
            [< 'String "an"; 'String "element"; 'Std_ppcmds (!p_lambda_var_list c );
              'String "of"; 'Std_ppcmds (!p_lambda_binder_type c ) >] else
         [< 'String (nc_atm_lambda_text_var_list_length c); 'String "elements";
           'Std_ppcmds (!p_lambda_var_list c ); 'String "of";
           'Std_ppcmds (!p_lambda_binder_type c ) >]
         ) >]
    | _ -> [< (match (nc_int_lambda_typ_is_a_sort c) with
              | 1 ->
                [< (if (nc_int_lambda_var_list_length c) = 1 then
                      [< 'String "a"; 'String "proposition";
                        'Std_ppcmds (!p_lambda_var_list c ) >] else
                   [< 'String (nc_atm_lambda_text_var_list_length c);
                     'String "propositions"; 'Std_ppcmds (!p_lambda_var_list c ) >]
                   ) >]
              | 2 ->
                [< (if (nc_int_lambda_var_list_length c) = 1 then
                      [< 'String "a"; 'String "set";
                        'Std_ppcmds (!p_lambda_var_list c ) >] else
                   [< 'String (nc_atm_lambda_text_var_list_length c); 'String "sets";
                     'Std_ppcmds (!p_lambda_var_list c ) >]
                   ) >]
              | 3 ->
                [< (if (nc_int_lambda_var_list_length c) = 1 then
                      [< 'String "a"; 'String "type";
                        'Std_ppcmds (!p_lambda_var_list c ) >] else
                   [< 'String (nc_atm_lambda_text_var_list_length c); 'String "types";
                     'Std_ppcmds (!p_lambda_var_list c ) >]
                   ) >]
              | _ ->
                [< (if (nc_int_lambda_var_list_length c) = 1 then
                      [< 'String "a"; 'String "term";
                        'Std_ppcmds (!p_lambda_var_list c ); 'String "of";
                        'String "type"; 'Std_ppcmds (!p_lambda_binder_type c ) >]
                      else
                   [< 'String (nc_atm_lambda_text_var_list_length c);
                     'String "terms"; 'Std_ppcmds (!p_lambda_var_list c );
                     'String "of"; 'String "type";
                     'Std_ppcmds (!p_lambda_binder_type c ) >]
                   ) >]
              ) >]
    ) >]);

(p_lambda_type_next := function c ->
box "hv" (1, 0)
  [< (if (nc_int_lambda_var_right c) > 0 then
       [< 'Std_ppcmds (!p_lambda_son p_lambda_type_next c ) >] else
    [< 'Std_ppcmds (!p_lambda_son p_lambda_type_list c ) >]
    ) >]);

(p_lambda_type_list := function c ->
box "hv" (1, 0)
  [< (match (nc_int_lambda_type_right c) with
    | 0 -> [< 'Std_ppcmds (!p_lambda_type c ) >]
    | 1 ->
      [< 'Std_ppcmds (!p_lambda_type c ); 'String "and";
        'Std_ppcmds (!p_lambda_type_next c ) >]
    | _ -> [< 'Std_ppcmds (box "h" def_sep_h
                             [< 'Std_ppcmds (!p_lambda_type c ); 'String "," >]);
              'Std_ppcmds (!p_lambda_type_next c ) >]
    ) >]);

(p_lambda_sort_next_bis := function c ->
box "hv" (1, 0)
  [< (if (nc_int_lambda_type_right c) > 0 || (nc_int_lambda_var_right c) > 0 then
       [< 'Std_ppcmds (!p_lambda_son p_lambda_sort_next_bis c ) >] else
    [< 'Std_ppcmds (!p_lambda_son p_lambda_sort_list_bis c ) >]
    ) >]);

(p_lambda_sort_bis := function c ->
box "hv" (1, 0)
  [< 'Std_ppcmds (!p_lambda_type_list c ) >]);

(p_lambda_sort_list_bis := function c ->
box "hv" (1, 0)
  [< (match (nc_int_lambda_sort_right c) with
    | 0 -> [< 'Std_ppcmds (!p_lambda_sort_bis c ) >]
    | _ -> [< 'Std_ppcmds (box "h" def_sep_h
                             [< 'Std_ppcmds (!p_lambda_sort_bis c ); 'String ";" >]);
              'Std_ppcmds (!p_lambda_sort_next c ) >]
    ) >]);

(p_lambda_sort_next := function c ->
box "hv" (1, 0)
  [< (if (nc_int_lambda_type_right c) > 0 || (nc_int_lambda_var_right c) > 0 then
       [< 'Std_ppcmds (!p_lambda_son p_lambda_sort_next c ) >] else
    [< 'Std_ppcmds (!p_lambda_son p_lambda_sort_list c ) >]
    ) >]);

(p_lambda_sort := function c ->
box "hv" (1, 0)
  [< (if (nc_int_is_lambda_in_case c) = 1 then
       [< (match (nc_int_lambda_sort c) with
          | 1 -> [< 'String "we"; 'String "have" >]
          | _ -> [< 'String "we"; 'String "know" >]
          ) >] else
    [< (match (nc_int_lambda_sort c) with
       | 1 -> [< (match (nc_int_lambda_nat c) with
                 | 3 | 4 -> [< 'String "suppose" >]
                 | 5 ->
                   [< 'String "by"; 'String "induction"; 'String "hypothesis";
                     'String "we"; 'String "have" >]
                 | _ -> [< 'String "assume" >]
                 ) >]
       | _ -> [< (match (nc_int_lambda_nat c) with
                 | 3 | 4 ->
                   [< 'String "suppose"; 'String "there";
                     (if (nc_int_lambda_type_right c) = 0 then
                        [< 'String "exists" >] else
                     [< 'String "exist" >]
                     ) >]
                 | _ -> [< 'String "consider" >]
                 ) >]
       ) >]
    ); 'Std_ppcmds (!p_lambda_type_list c ) >]);

(p_lambda_sort_cap := function c ->
box "hv" (1, 0)
  [< (if (nc_int_is_lambda_in_case c) = 1 then
       [< (match (nc_int_lambda_sort c) with
          | 1 -> [< 'String "We"; 'String "have" >]
          | _ -> [< 'String "We"; 'String "know" >]
          ) >] else
    [< (match (nc_int_lambda_sort c) with
       | 1 -> [< (match (nc_int_lambda_nat c) with
                 | 3 | 4 -> [< 'String "Suppose" >]
                 | 5 ->
                   [< 'String "By"; 'String "induction"; 'String "hypothesis";
                     'String "we"; 'String "have" >]
                 | _ -> [< 'String "Assume" >]
                 ) >]
       | _ -> [< (match (nc_int_lambda_nat c) with
                 | 3 | 4 ->
                   [< 'String "Suppose"; 'String "there";
                     (if
                        (nc_int_lambda_var_list_length c) = 1 &&
                          (nc_int_lambda_type_right c) = 0 then
                        [< 'String "exists" >] else
                     [< 'String "exist" >]
                     ) >]
                 | _ -> [< 'String "Consider" >]
                 ) >]
       ) >]
    ); 'Std_ppcmds (!p_lambda_type_list c ) >]);

(p_lambda_sort_list := function c ->
box "hv" (1, 0)
  [< (match (nc_int_lambda_sort_right c) with
    | 0 -> [< 'Std_ppcmds (!p_lambda_sort c ) >]
    | _ -> [< (match (nc_int_lambda_coord c) with
              | 1 ->
                [< 'Std_ppcmds (!p_lambda_sort c ); 'String "such"; 'String "that";
                  'Std_ppcmds (!p_lambda_sort_next_bis c ) >]
              | _ -> [< 'Std_ppcmds (box "h" def_sep_h
                                       [< 'Std_ppcmds (!p_lambda_sort c );
                                         'String ";" >]);
                        'Std_ppcmds (!p_lambda_sort_next c ) >]
              ) >]
    ) >]);

(p_lambda_sort_list_cap := function c ->
box "hv" (1, 0)
  [< (match (nc_int_lambda_sort_right c) with
    | 0 -> [< 'Std_ppcmds (!p_lambda_sort_cap c ) >]
    | _ -> [< (match (nc_int_lambda_coord c) with
              | 1 ->
                [< 'Std_ppcmds (!p_lambda_sort_cap c ); 'String "such";
                  'String "that"; 'Std_ppcmds (!p_lambda_sort_next_bis c ) >]
              | _ -> [< 'Std_ppcmds (box "h" def_sep_h
                                       [< 'Std_ppcmds (!p_lambda_sort_cap c );
                                         'String ";" >]);
                        'Std_ppcmds (!p_lambda_sort_next c ) >]
              ) >]
    ) >]);

(p_lambda_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1000 -> [< 'Std_ppcmds (box "h" def_sep_h
                                 [< 'Std_ppcmds (!p_type_intro_bis_cap c );
                                   'String "," >]); 'Std_ppcmds (box "h" def_sep_h
                                                                [< 'Std_ppcmds
                                                                    (!p_lambda_sort_list
                                                                    c );
                                                                  'String "." >]) >]
    | 0000 -> [< 'Std_ppcmds (box "h" def_sep_h
                                 [< 'Std_ppcmds (!p_lambda_sort_list_cap c );
                                   'String "." >]) >]
    | _ -> [< 'String "ERROR lambda_intro" >]
    ) >]);

(p_apply_std_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1100 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "with";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_apply_head p_id c ); 'String "." >]) >]
    | 1000 -> [< 'Std_ppcmds (box "h" def_sep_h
                                 [< 'Std_ppcmds (!p_type_intro_cap c );
                                   'String "." >]) >]
    | 0100 -> [< 'String "We"; 'String "use"; 'Std_ppcmds (box "h" def_sep_h
                                                         [< 'Std_ppcmds
                                                              (!p_apply_head
                                                              p_id c );
                                                           'String "." >]) >]
    | _ -> [< 'String "ERROR apply_omit_intro" >]
    ) >]);

(p_apply_omit_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1000 -> [< 'Std_ppcmds (box "h" def_sep_h
                                 [< 'Std_ppcmds (!p_type_intro_cap c );
                                   'String "." >]) >]
    | _ -> [< 'String "ERROR apply_omit_intro" >]
    ) >]);

(p_apply_construct_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1100 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "with";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_apply_head p_id_expl c ); 'String "." >]) >]
    | 1000 -> [< 'Std_ppcmds (box "h" def_sep_h
                                 [< 'Std_ppcmds (!p_type_intro_cap c );
                                   'String "." >]) >]
    | 0100 -> [< 'String "We"; 'String "use"; 'Std_ppcmds (box "h" def_sep_h
                                                         [< 'Std_ppcmds
                                                              (!p_apply_head
                                                              p_id_expl c );
                                                           'String "." >]) >]
    | _ -> [< 'String "ERROR apply_construct_intro" >]
    ) >]);

(p_elim_match_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1110 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "using";
        'Std_ppcmds (!p_elim_head p_id c ); 'String "with";
        'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'String "in"; 'String "a";
        'String "study"; 'String "in"; 'String (nc_atm_text_nbr_elim_cases c);
        'String "cases." >]
    | 1100 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "using";
        'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'String "in"; 'String "a";
        'String "study"; 'String "in"; 'String (nc_atm_text_nbr_elim_cases c);
        'String "cases." >]
    | 1010 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "we"; 'String "distinguish";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cases"; 'String "in";
        'String "the"; 'String "study"; 'String "of"; 'Std_ppcmds (box "h" def_sep_h
                                                             [< 'Std_ppcmds
                                                                  (!p_elim_head
                                                                  p_id c );
                                                               'String "." >]) >]
    | 1000 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "we"; 'String "distinguish";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cases." >]
    | 0110 ->
      [< 'String "We"; 'String "use"; 'Std_ppcmds (!p_elim_head p_id c );
        'String "with"; 'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'String "in";
        'String "a"; 'String "study"; 'String "in";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cases." >]
    | 0100 ->
      [< 'String "We"; 'String "use"; 'Std_ppcmds (!p_induct_cst p_definition_expl c );
        'String "in"; 'String "a"; 'String "study"; 'String "in";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cases." >]
    | 0010 ->
      [< 'String "We"; 'String "distinguish"; 'String (nc_atm_text_nbr_elim_cases c);
        'String "cases"; 'String "in"; 'String "the"; 'String "study"; 'String "of";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_elim_head p_id c ); 'String "." >]) >]
    | 0000 ->
      [< 'String "We"; 'String "distinguish"; 'String (nc_atm_text_nbr_elim_cases c);
        'String "cases." >]
    | _ -> [< 'String "ERROR elim_match_intro" >]
    ) >]);

(p_elim_match_one_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1110 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "using";
        'Std_ppcmds (!p_elim_head p_id c ); 'String "with";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_induct_cst p_definition_expl c );
                         'String "." >]) >]
    | 1100 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "using";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_induct_cst p_definition_expl c );
                         'String "." >]) >]
    | 1010 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "we"; 'String "study";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_elim_head p_id c ); 'String "." >]) >]
    | 1000 -> [< 'Std_ppcmds (box "h" def_sep_h
                                 [< 'Std_ppcmds (!p_type_intro_bis_cap c );
                                   'String "." >]) >]
    | 0110 ->
      [< 'String "We"; 'String "use"; 'Std_ppcmds (!p_elim_head p_id c );
        'String "with"; 'Std_ppcmds (box "h" def_sep_h
                                     [< 'Std_ppcmds (!p_induct_cst
                                          p_definition_expl c ); 'String "." >]) >]
    | 0100 -> [< 'String "We"; 'String "use"; 'Std_ppcmds (box "h" def_sep_h
                                                         [< 'Std_ppcmds
                                                              (!p_induct_cst
                                                              p_definition_expl c
                                                              ); 'String "." >]) >]
    | 0010 -> [< 'String "We"; 'String "study"; 'Std_ppcmds (box "h" def_sep_h
                                                           [< 'Std_ppcmds
                                                                (!p_elim_head
                                                                p_id c );
                                                             'String "." >]) >]
    | 0000 -> [< 'String "We"; 'String "study"; 'String "this"; 'String "result" >]
    | _ -> [< 'String "ERROR elim_match_one_intro" >]
    ) >]);

(p_elim_match_absurd_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1110 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "using";
        'Std_ppcmds (!p_elim_head p_id c ); 'String "with";
        'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'String "in"; 'String "a";
        'String "study"; 'String "in"; 'String (nc_atm_text_nbr_elim_cases c);
        'String "cases." >]
    | 1100 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "using";
        'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'String "in"; 'String "a";
        'String "study"; 'String "in"; 'String (nc_atm_text_nbr_elim_cases c);
        'String "cases." >]
    | 1010 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "we"; 'String "distinguish";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cases"; 'String "in";
        'String "the"; 'String "study"; 'String "of"; 'Std_ppcmds (box "h" def_sep_h
                                                             [< 'Std_ppcmds
                                                                  (!p_elim_head
                                                                  p_id c );
                                                               'String "." >]) >]
    | 1000 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "we"; 'String "distinguish";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cases." >]
    | 0110 ->
      [< 'String "We"; 'String "use"; 'Std_ppcmds (!p_elim_head p_id c );
        'String "with"; 'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'String "in";
        'String "a"; 'String "study"; 'String "in";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cases." >]
    | 0100 ->
      [< 'String "We"; 'String "use"; 'Std_ppcmds (!p_induct_cst p_definition_expl c );
        'String "in"; 'String "a"; 'String "study"; 'String "in";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cases." >]
    | 0010 ->
      [< 'String "We"; 'String "distinguish"; 'String (nc_atm_text_nbr_elim_cases c);
        'String "cases"; 'String "in"; 'String "the"; 'String "study"; 'String "of";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_elim_head p_id c ); 'String "." >]) >]
    | 0000 ->
      [< 'String "We"; 'String "distinguish"; 'String (nc_atm_text_nbr_elim_cases c);
        'String "cases." >]
    | _ -> [< 'String "ERROR elim_match_absurd_intro" >]
    ) >]);

(p_elim_induc_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1110 -> [< 'String "With"; 'Std_ppcmds (box "h" def_sep_h
                                              [< 'Std_ppcmds (!p_elim_head p_id
                                                   c ); 'String "," >]);
                 'Std_ppcmds (!p_type_intro c ); 'String "by"; 'String "induction";
                 'String "on"; 'Std_ppcmds (box "h" def_sep_h
                                           [< 'Std_ppcmds (!p_induct_cst
                                                p_definition_expl c );
                                             'String "." >]) >]
    | 1100 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "by"; 'String "induction";
        'String "on"; 'Std_ppcmds (box "h" def_sep_h
                                   [< 'Std_ppcmds (!p_induct_cst p_definition_expl
                                        c ); 'String "." >]) >]
    | 1010 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "by"; 'String "induction";
        'String "on"; 'Std_ppcmds (box "h" def_sep_h
                                   [< 'Std_ppcmds (!p_elim_head p_id c );
                                     'String "." >]) >]
    | 1000 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "by";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'String "induction"; 'String "." >]) >]
    | 0110 -> [< 'String "With"; 'Std_ppcmds (box "h" def_sep_h
                                              [< 'Std_ppcmds (!p_elim_head p_id
                                                   c ); 'String "," >]);
                 'String "we"; 'String "do"; 'String "an"; 'String "induction";
                 'String "on"; 'Std_ppcmds (box "h" def_sep_h
                                           [< 'Std_ppcmds (!p_induct_cst
                                                p_definition_expl c );
                                             'String "." >]) >]
    | 0100 ->
      [< 'String "We"; 'String "do"; 'String "an"; 'String "induction"; 'String "on";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_induct_cst p_definition_expl c );
                         'String "." >]) >]
    | 0010 ->
      [< 'String "We"; 'String "do"; 'String "an"; 'String "induction"; 'String "on";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_elim_head p_id c ); 'String "." >]) >]
    | 0000 ->
      [< 'String "We"; 'String "do"; 'String "an"; 'Std_ppcmds (box "h" def_sep_h
                                                           [< 'String "induction";
                                                             'String "." >]) >]
    | _ -> [< 'String "ERROR elim_induc_intro" >]
    ) >]);

(p_trivial_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_lambda_sort c) with
    | 1 -> [< 'String "We"; 'String "have" >]
    | _ ->
      [< 'String "We"; 'String "know"; 'String "the"; 'String "existence"; 'String "of" >]
    ); (match (nc_int_lambda_sort_right c) with
       | 0 -> [< 'Std_ppcmds (box "h" def_sep_h
                               [< 'Std_ppcmds (!p_lambda_type_list c );
                                 'String "." >]) >]
       | _ -> [< (match (nc_int_lambda_coord c) with
                 | 1 ->
                   [< 'Std_ppcmds (!p_lambda_type_list c ); 'String "such";
                     'String "that"; 'Std_ppcmds (box "h" def_sep_h
                                                 [< 'Std_ppcmds
                                                     (!p_lambda_sort_next_bis c
                                                     ); 'String "." >]) >]
                 | _ -> [< 'Std_ppcmds (box "h" def_sep_h
                                          [< 'Std_ppcmds (!p_lambda_type_list c );
                                            'String ";" >]);
                          'Std_ppcmds (box "h" def_sep_h
                                         [< 'Std_ppcmds (!p_lambda_sort_next c );
                                           'String "." >]) >]
                 ) >]
       ) >]);

(p_misc_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1000 -> [< 'Std_ppcmds (box "h" def_sep_h
                                 [< 'Std_ppcmds (!p_type_intro_cap c );
                                   'String "." >]) >]
    | _ -> [< 'String "ERROR misc_intro" >]
    ) >]);

()

end);

(********************************************************************)
(*|                          end of chapter                        |*)
(********************************************************************)

(********************************************************************)
(*|                                                                |*)
(*|                              chapter                           |*)
(*|                                                                |*)
(********************************************************************)
(*  Name : conclusions  *)

(

begin

(p_lambda_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 -> [< (match (nc_int_lambda_nat c) with
                  | 3 ->
                    [< 'String "So"; 'String "we"; 'String "have";
                      'Std_ppcmds (box "h" def_sep_h
                                     [< 'Std_ppcmds (!p_type_concl c );
                                       'String "." >]) >]
                  | 4 ->
                    [< 'String "So"; 'String "we"; 'String "can";
                      'Std_ppcmds (box "h" def_sep_h
                                     [< 'Std_ppcmds (!p_type_concl_ter c );
                                       'String "." >]) >]
                  | _ ->
                    [< 'String "We"; 'String "have"; 'String "proved";
                      'Std_ppcmds (box "h" def_sep_h
                                     [< 'Std_ppcmds (!p_type_concl_bis c );
                                       'String "." >]) >]
                  ) >]
    | _ -> [< 'String "ERROR lambda_concl" >]
    ) >]);

(p_apply_std_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1101 | 1110 ->
      [< (if (nc_int_is_concl_false c) = 1 && (nc_int_number_of_types c) = 1 then
            [< 'Std_ppcmds (!p_apply_head p_id_cap c ); 'String "contradicts";
              'Std_ppcmds (box "h" def_sep_h
                             [< 'Std_ppcmds (!p_apply_sub_horiz_expl c );
                               'String "." >]) >] else
         [< 'String "Using"; 'Std_ppcmds (!p_apply_head p_id c ); 'String "with";
           'Std_ppcmds (!p_apply_sub_horiz c ); 'String "we"; 'String "get";
           'Std_ppcmds (box "h" def_sep_h
                          [< 'Std_ppcmds (!p_type_concl c ); 'String "." >]) >]
         ) >]
    | 1100 ->
      [< (if (nc_int_is_concl_false c) = 1 && (nc_int_number_of_types c) = 1 then
            [< (if (nc_int_apply_subs_number c) = 1 then
                 [< 'Std_ppcmds (!p_apply_head p_id_cap c ); 'String "contradicts";
                   'String "this"; 'String "result." >] else
               [< 'Std_ppcmds (!p_apply_head p_id_cap c ); 'String "contradicts";
                 'String "these"; 'String "results." >]
               ) >] else
         [< (if (nc_int_apply_subs_number c) = 1 then
               [< 'String "Using"; 'Std_ppcmds (!p_apply_head p_id c );
                 'String "with"; 'String "this"; 'String "result"; 'String "we";
                 'String "get"; 'Std_ppcmds (box "h" def_sep_h
                                            [< 'Std_ppcmds (!p_type_concl c );
                                              'String "." >]) >] else
            [< 'String "Using"; 'Std_ppcmds (!p_apply_head p_id c ); 'String "with";
              'String "these"; 'String "results"; 'String "we"; 'String "get";
              'Std_ppcmds (box "h" def_sep_h
                             [< 'Std_ppcmds (!p_type_concl c ); 'String "." >]) >]
            ) >]
         ) >]
    | 1010 | 1001 ->
      [< (if
            ((nc_int_is_concl_false c) = 1 && (nc_int_number_of_types c) = 1) &&
              (nc_int_apply_subs_number c) = 1 then
            [< 'String "This"; 'String "result"; 'String "contradicts";
              'Std_ppcmds (box "h" def_sep_h
                             [< 'Std_ppcmds (!p_apply_sub_horiz c ); 'String "." >]) >]
            else
         [< 'String "So,"; 'String "with"; 'Std_ppcmds (!p_apply_sub_horiz c );
           'String "we"; 'String "get"; 'Std_ppcmds (box "h" def_sep_h
                                                  [< 'Std_ppcmds (!p_type_concl
                                                       c ); 'String "." >]) >]
         ) >]
    | 1000 ->
      [< (if
            ((nc_int_is_concl_false c) = 1 && (nc_int_number_of_types c) = 1) &&
              (nc_int_apply_subs_number c) = 1 then
            [< 'String "These"; 'String "two"; 'String "results"; 'String "are";
              'String "contradictory." >] else
         if (nc_int_is_apply_head_up c) = 1 then
           [< (if (nc_int_apply_subs_number c) = 1 then
                 [< 'String "Applying"; 'String "the"; 'String "first"; 'String "result";
                   'String "to"; 'String "the"; 'String "next"; 'String "one,"; 'String "we";
                   'String "get"; 'Std_ppcmds (box "h" def_sep_h
                                              [< 'Std_ppcmds (!p_type_concl c );
                                                'String "." >]) >] else
              [< 'String "Applying"; 'String "the"; 'String "first"; 'String "result";
                'String "to"; 'String "the"; 'String "next"; 'String "ones,"; 'String "we";
                'String "get"; 'Std_ppcmds (box "h" def_sep_h
                                           [< 'Std_ppcmds (!p_type_concl c );
                                             'String "." >]) >]
              ) >] else
         if (nc_int_apply_subs_number c) = 1 then
           [< 'String "Applying"; 'String "the"; 'String "last"; 'String "result";
             'String "to"; 'String "the"; 'String "previous"; 'String "one,"; 'String "we";
             'String "get"; 'Std_ppcmds (box "h" def_sep_h
                                        [< 'Std_ppcmds (!p_type_concl c );
                                          'String "." >]) >] else
         [< 'String "Applying"; 'String "the"; 'String "last"; 'String "result"; 'String "to";
           'String "the"; 'String "previous"; 'String "ones,"; 'String "we"; 'String "get";
           'Std_ppcmds (box "h" def_sep_h
                          [< 'Std_ppcmds (!p_type_concl c ); 'String "." >]) >]
         ) >]
    | 0110 | 0101 ->
      [< 'String "We"; 'String "apply"; 'Std_ppcmds (!p_apply_head p_id c );
        'String "to"; 'Std_ppcmds (box "h" def_sep_h
                                   [< 'Std_ppcmds (!p_apply_sub_horiz c );
                                     'String "." >]) >]
    | 0100 ->
      [< 'String "We"; 'String "apply"; 'String "now"; 'Std_ppcmds (box "h" def_sep_h
                                                                [< 'Std_ppcmds
                                                                     (!p_apply_head
                                                                     p_id c );
                                                                  'String "." >]) >]
    | 0010 | 0001 ->
      [< 'String "We"; 'String "apply"; 'String "this"; 'String "result"; 'String "to";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_apply_sub_horiz c ); 'String "." >]) >]
    | 0000 ->
      [< (if (nc_int_is_apply_head_up c) = 1 then
            [< (if (nc_int_apply_subs_number c) = 1 then
                 [< 'String "We"; 'String "apply"; 'String "the"; 'String "first";
                   'String "result"; 'String "to"; 'String "the"; 'String "next";
                   'String "one." >] else
               [< 'String "We"; 'String "apply"; 'String "the"; 'String "first";
                 'String "result"; 'String "to"; 'String "the"; 'String "next";
                 'String "ones." >]
               ) >] else
         if (nc_int_apply_subs_number c) = 1 then
           [< 'String "We"; 'String "apply"; 'String "the"; 'String "last"; 'String "result";
             'String "to"; 'String "the"; 'String "previous"; 'String "one." >] else
         [< 'String "We"; 'String "apply"; 'String "the"; 'String "last"; 'String "result";
           'String "to"; 'String "the"; 'String "previous"; 'String "ones." >]
         ) >]
    | _ -> [< 'String "ERROR apply_concl" >]
    ) >]);

(p_apply_std_specialization_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1100 ->
      [< 'String "From"; 'Std_ppcmds (!p_apply_head p_id c ); 'String "we";
        'String "obtain"; 'Std_ppcmds (box "h" def_sep_h
                                      [< 'Std_ppcmds (!p_type_concl c );
                                        'String "." >]) >]
    | 1000 ->
      [< 'String "From"; 'String "this"; 'String "result"; 'String "we"; 'String "obtain";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_type_concl c ); 'String "." >]) >]
    | 0100 -> [< 'String "We"; 'String "specialize"; 'Std_ppcmds (box "h" def_sep_h
                                                               [< 'Std_ppcmds
                                                                    (!p_apply_head
                                                                    p_id c );
                                                                 'String "." >]) >]
    | 0000 -> [< 'String "We"; 'String "specialize"; 'String "this"; 'String "result." >]
    | _ -> [< 'String "ERROR apply_specialization_concl" >]
    ) >]);

(p_apply_omit_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1010 ->
      [< 'String "With"; 'Std_ppcmds (!p_apply_sub_horiz c ); 'String "we";
        'String "have"; 'Std_ppcmds (box "h" def_sep_h
                                     [< 'Std_ppcmds (!p_type_concl c );
                                       'String "." >]) >]
    | 1000 ->
      [< (if (nc_int_apply_subs_number c) = 1 then
            [< 'String "With"; 'String "this"; 'String "result"; 'String "we";
              'String "have"; 'Std_ppcmds (box "h" def_sep_h
                                          [< 'Std_ppcmds (!p_type_concl c );
                                            'String "." >]) >] else
         [< 'String "With"; 'String "these"; 'String "results"; 'String "we"; 'String "have";
           'Std_ppcmds (box "h" def_sep_h
                          [< 'Std_ppcmds (!p_type_concl c ); 'String "." >]) >]
         ) >]
    | 0010 | 0001 -> [< 'String "We"; 'String "use"; 'Std_ppcmds (box "h" def_sep_h
                                                                [< 'Std_ppcmds
                                                                     (!p_apply_sub_horiz
                                                                     c );
                                                                  'String "." >]) >]
    | _ -> [< 'String "ERROR omit_concl" >]
    ) >]);

(p_apply_omit_specialization_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "We"; 'String "have"; 'String "directly";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_type_concl c ); 'String "." >]) >]
    | 0000 -> [< 'String "This"; 'String "is"; 'String "immediate." >]
    | _ -> [< 'String "ERROR omit_specialization_concl" >]
    ) >]);

(p_apply_construct_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1110 | 1101 -> [< 'String "By"; 'Std_ppcmds (box "h" def_sep_h
                                                   [< 'Std_ppcmds
                                                        (!p_apply_head p_id_expl
                                                        c ); 'String "," >]);
                        'String "with"; 'Std_ppcmds (!p_apply_sub_horiz c );
                        'String "we"; 'String "have"; 'Std_ppcmds (box "h" def_sep_h
                                                                 [< 'Std_ppcmds
                                                                     (!p_type_concl
                                                                     c );
                                                                   'String "." >]) >]
    | 1100 ->
      [< 'String "So,"; 'String "by"; 'Std_ppcmds (!p_apply_head p_id_expl c );
        'String "we"; 'String "have"; 'Std_ppcmds (box "h" def_sep_h
                                                 [< 'Std_ppcmds (!p_type_concl c
                                                      ); 'String "." >]) >]
    | 1010 | 1001 ->
      [< 'String "With"; 'Std_ppcmds (!p_apply_sub_horiz c ); 'String "we";
        'String "have"; 'Std_ppcmds (box "h" def_sep_h
                                     [< 'Std_ppcmds (!p_type_concl c );
                                       'String "." >]) >]
    | 1000 ->
      [< 'String "So,"; 'String "we"; 'String "have"; 'Std_ppcmds (box "h" def_sep_h
                                                              [< 'Std_ppcmds
                                                                   (!p_type_concl
                                                                   c );
                                                                'String "." >]) >]
    | 0110 | 0101 ->
      [< 'String "We"; 'String "apply"; 'Std_ppcmds (!p_apply_head p_id_expl c );
        'String "to"; 'Std_ppcmds (box "h" def_sep_h
                                   [< 'Std_ppcmds (!p_apply_sub_horiz c );
                                     'String "." >]) >]
    | 0100 ->
      [< 'String "We"; 'String "apply"; 'String "now"; 'Std_ppcmds (box "h" def_sep_h
                                                                [< 'Std_ppcmds
                                                                     (!p_apply_head
                                                                     p_id_expl c
                                                                     );
                                                                  'String "." >]) >]
    | 0010 | 0001 -> [< 'String "We"; 'String "use"; 'Std_ppcmds (box "h" def_sep_h
                                                                [< 'Std_ppcmds
                                                                     (!p_apply_sub_horiz
                                                                     c );
                                                                  'String "." >]) >]
    | _ -> [< 'String "ERROR construct_concl" >]
    ) >]);

(p_apply_construct_specialization_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1100 ->
      [< 'String "From"; 'Std_ppcmds (!p_apply_head p_id_expl c ); 'String "we";
        'String "obtain"; 'Std_ppcmds (box "h" def_sep_h
                                      [< 'Std_ppcmds (!p_type_concl c );
                                        'String "." >]) >]
    | 1000 ->
      [< 'String "We"; 'String "have"; 'String "directly";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_type_concl c ); 'String "." >]) >]
    | 0100 -> [< 'String "We"; 'String "specialize"; 'Std_ppcmds (box "h" def_sep_h
                                                               [< 'Std_ppcmds
                                                                    (!p_apply_head
                                                                    p_id_expl c
                                                                    );
                                                                 'String "." >]) >]
    | 0000 ->
      [< 'String "We"; 'String "now"; 'String "do"; 'String "a";
        'String "specialization." >]
    | _ -> [< 'String "ERROR construct_specialization_concl" >]
    ) >]);

(p_elim_match_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "We"; 'String "have"; 'String "proved";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_type_concl_bis c ); 'String "." >]) >]
    | _ -> [< 'String "ERROR elim_match_concl" >]
    ) >]);

(p_elim_match_one_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "We"; 'String "have"; 'String "proved";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_type_concl_bis c ); 'String "." >]) >]
    | _ -> [< 'String "ERROR elim_match_one_concl" >]
    ) >]);

(p_elim_match_no_case_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1110 | 1101 ->
      [< (if (nc_int_is_concl_false c) = 1 then
            [< 'Std_ppcmds (!p_elim_head p_id_cap c ); 'String "contradicts";
              'Std_ppcmds (box "h" def_sep_h
                             [< 'Std_ppcmds (!p_induct_cst p_definition_expl c );
                               'String "." >]) >] else
         [< 'Std_ppcmds (!p_elim_head p_id_cap c ); 'String "contradicts";
           'Std_ppcmds (box "h" def_sep_h
                          [< 'Std_ppcmds (!p_induct_cst p_definition_expl c );
                            'String "," >]); 'String "so"; 'String "we"; 'String "can";
           'Std_ppcmds (box "h" def_sep_h
                          [< 'Std_ppcmds (!p_type_concl_ter c ); 'String "." >]) >]
         ) >]
    | 1100 ->
      [< (if (nc_int_is_concl_false c) = 1 then
            [< 'String "This"; 'String "result"; 'String "contradicts";
              'Std_ppcmds (box "h" def_sep_h
                             [< 'Std_ppcmds (!p_induct_cst p_definition_expl c );
                               'String "." >]) >] else
         [< 'String "This"; 'String "result"; 'String "contradicts";
           'Std_ppcmds (box "h" def_sep_h
                          [< 'Std_ppcmds (!p_induct_cst p_definition_expl c );
                            'String "," >]); 'String "so"; 'String "we"; 'String "can";
           'Std_ppcmds (box "h" def_sep_h
                          [< 'Std_ppcmds (!p_type_concl_ter c ); 'String "." >]) >]
         ) >]
    | 1010 | 1001 ->
      [< 'String "With"; 'Std_ppcmds (!p_elim_head p_id c ); 'String "we";
        'String "can"; 'Std_ppcmds (box "h" def_sep_h
                                    [< 'Std_ppcmds (!p_type_concl_ter c );
                                      'String "." >]) >]
    | 1000 ->
      [< 'String "We"; 'String "can"; 'Std_ppcmds (!p_type_concl_ter c ); 'String "." >]
    | 0110 | 0101 ->
      [< 'Std_ppcmds (!p_elim_head p_id_cap c ); 'String "contradicts";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_induct_cst p_definition_expl c );
                         'String "." >]) >]
    | 0100 ->
      [< 'String "This"; 'String "result"; 'String "contradicts";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_induct_cst p_definition_expl c );
                         'String "." >]) >]
    | _ -> [< 'String "ERROR elim_absurd_concl" >]
    ) >]);

(p_elim_match_trivial_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1110 | 1101 ->
      [< 'String "Using"; 'Std_ppcmds (!p_elim_head p_id c ); 'String "with";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_induct_cst p_definition_expl c );
                         'String "," >]); 'String "we"; 'String "get"; 'String "trivially";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_type_concl c ); 'String "." >]) >]
    | 1100 -> [< 'String "Using"; 'Std_ppcmds (box "h" def_sep_h
                                               [< 'Std_ppcmds (!p_induct_cst
                                                    p_definition_expl c );
                                                 'String "," >]); 'String "we";
                 'String "get"; 'String "trivially"; 'Std_ppcmds (box "h" def_sep_h
                                                            [< 'Std_ppcmds
                                                                 (!p_type_concl c
                                                                 ); 'String "." >]) >]
    | 1010 | 1001 ->
      [< 'String "Using"; 'Std_ppcmds (!p_elim_head p_id c ); 'String ","; 'String "we";
        'String "get"; 'String "trivially"; 'Std_ppcmds (box "h" def_sep_h
                                                    [< 'Std_ppcmds (!p_type_concl
                                                         c ); 'String "." >]) >]
    | 1000 ->
      [< 'String "We"; 'String "get"; 'String "trivially"; 'Std_ppcmds (!p_type_concl c );
        'String "." >]
    | 0110 | 0101 ->
      [< 'String "We"; 'String "use"; 'String "trivially";
        'Std_ppcmds (!p_elim_head p_id c ); 'String "with";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_induct_cst p_definition_expl c );
                         'String "." >]) >]
    | 0100 ->
      [< 'String "We"; 'String "use"; 'String "trivially";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_induct_cst p_definition_expl c );
                         'String "." >]) >]
    | 0010 | 0001 ->
      [< 'String "We"; 'String "use"; 'String "trivially";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_elim_head p_id c ); 'String "." >]) >]
    | _ -> [< 'String "ERROR elim_trivial_concl" >]
    ) >]);

(p_elim_match_absurd_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "So"; 'String "we"; 'String "can"; 'Std_ppcmds (box "h" def_sep_h
                                                            [< 'Std_ppcmds
                                                                 (!p_type_concl_ter
                                                                 c );
                                                              'String "." >]) >]
    | _ -> [< 'String "ERROR elim_match_absurd_concl" >]
    ) >]);

(p_elim_induc_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "We"; 'String "have"; 'String "proved";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_type_concl_bis c ); 'String "." >]) >]
    | _ -> [< 'String "ERROR elim_induc_concl" >]
    ) >]);

(p_fix_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "We"; 'String "have"; 'String "proved";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_type_concl_bis c ); 'String "." >]) >]
    | _ -> [< 'String "ERROR fix_conl" >]
    ) >]);

(p_identifier_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1001 ->
      [< 'String "By"; 'Std_ppcmds (!p_id c ); 'String "we"; 'String "have";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_type_concl c ); 'String "." >]) >]
    | 0001 -> [< 'String "We"; 'String "use"; 'Std_ppcmds (box "h" def_sep_h
                                                         [< 'Std_ppcmds (!p_id c
                                                              ); 'String "." >]) >]
    | _ -> [< 'String "ERROR var_concl" >]
    ) >]);

(p_metavar_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "Imagine"; 'String "a"; 'String "proof"; 'String "of";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_type_concl c ); 'String "." >]) >]
    | 0000 -> [< 'String "Imagine"; 'String "a"; 'String "proof." >]
    | _ -> [< 'String "ERROR metavar_concl" >]
    ) >]);

(p_trivial_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "We"; 'String "trivially"; 'String "have";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_type_concl c ); 'String "." >]) >]
    | 0000 -> [< 'String "This"; 'String "is"; 'String "trivial." >]
    | _ -> [< 'String "ERROR trivial_concl" >]
    ) >]);

(p_misc_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "We"; 'String "have"; 'String "proved";
        'Std_ppcmds (box "h" def_sep_h
                       [< 'Std_ppcmds (!p_type_concl_bis c ); 'String "." >]) >]
    | _ -> [< 'String "ERROR misc_concl" >]
    ) >]);

()

end)

(********************************************************************)
(*|                          end of chapter                        |*)
(********************************************************************)

end;;

(********************************************************************)
(*|                          end of pprinter                       |*)
(********************************************************************)
