(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA                        ENS-CNRS                *)
(*              Rocquencourt                        Lyon                    *)
(*                                                                          *)
(*                                Coq V6.0                                  *)
(*                              Sep 25th 1996                               *)
(*                                                                          *)
(****************************************************************************)
(*                                ntentries.ml                              *)
(****************************************************************************)

(* Concrete syntax for the commands of Yann Coscoy's pretty-printer         *)

open Std;;
open Pp;;
open Himsg;;
open Names;;
open Vernacinterp;;
open Ntcommand;;

let add = vinterp_add;;

add("SelectLanguageText",
    function [VARG_IDENTIFIER id] ->
      (fun () ->
         try select_language_text id;
            mSGNL [< 'sTR "Natural language set to "; 'sTR (string_of_id id) >]
         with UserError (_,pps) -> mSGNL pps)
     | _ -> anomaly "This should be trapped");;

add("PrintText",
    function [VARG_IDENTIFIER id] ->
      (fun () -> print_text id)
     | _ -> anomaly "This should be trapped");;

add("SetDepth",
    function [VARG_NUMBER n] ->
      (fun () -> Format.set_max_boxes n;
                 mSGNL [< 'sTR "The max size of nested text is now ";
                          'iNT n >])
     | [] ->
       fun () -> mSGNL [< 'sTR "The current max size of nested text is ";
                          'iNT (Format.get_max_boxes ()) >]
     | _ -> anomaly "This should be trapped");;

add("PrintCurrentText",
    function [] ->
      (fun () -> print_current_text ())
     | _ -> anomaly "This should be trapped");;


add("AddTextParamOmit",
    function [VARG_IDENTIFIER id] ->
      (fun () -> add_text_param_omit id)
     | _ -> anomaly "This should be trapped");;

add("MemTextParamOmit",
    function [VARG_IDENTIFIER id] ->
      (fun () -> mem_text_param_omit id)
     | _ -> anomaly "This should be trapped");;

add("RemoveTextParamOmit",
    function [VARG_IDENTIFIER id] ->
      (fun () -> remove_text_param_omit id)
     | _ -> anomaly "This should be trapped");;

add("PrintTextParamOmit",
    function [] ->
      (fun () -> print_text_param_omit ())
     | _ -> anomaly "This should be trapped");;


add("AddTextParamRecSub",
    function [VARG_IDENTIFIER id] ->
      (fun () -> add_text_param_rec_sub id)
     | _ -> anomaly "This should be trapped");;

add("MemTextParamRecSub",
    function [VARG_IDENTIFIER id] ->
      (fun () -> mem_text_param_rec_sub id)
     | _ -> anomaly "This should be trapped");;

add("RemoveTextParamRecSub",
    function [VARG_IDENTIFIER id] ->
      (fun () -> remove_text_param_rec_sub id)
     | _ -> anomaly "This should be trapped");;

add("PrintTextParamRecSub",
    function [] ->
      (fun () -> print_text_param_rec_sub ())
     | _ -> anomaly "This should be trapped");;


add("AddTextParamImmediate",
    function [VARG_IDENTIFIER id] ->
      (fun () -> add_text_param_immediate id)
     | _ -> anomaly "This should be trapped");;

add("MemTextParamImmediate",
    function [VARG_IDENTIFIER id] ->
      (fun () -> mem_text_param_immediate id)
     | _ -> anomaly "This should be trapped");;

add("RemoveTextParamImmediate",
    function [VARG_IDENTIFIER id] ->
      (fun () -> remove_text_param_immediate id)
     | _ -> anomaly "This should be trapped");;

add("PrintTextParamImmediate",
    function [] ->
      (fun () -> print_text_param_immediate ())
     | _ -> anomaly "This should be trapped");;

let max_depth_nested_text = 100;;

add("InitText",
    function [] ->
      (fun () -> init_text ();Format.set_max_boxes max_depth_nested_text)
     | _ -> anomaly "This should be trapped");;

