(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 unif.mli                                 *)
(****************************************************************************)

open General;;
open Dpctypes;;

exception Not_unifiable;;

val unif_atoms : atom_id * term list -> atom_id * term list 
                   -> (term * term) list;;
val unif_terms : term -> term -> (term * term) list;;

val assoc_unif : 'a -> ('a * 'a) list -> 'a;;
val apply_unif : (term * term) list -> term -> term;;
val appear_var_term : term -> term -> bool;;

exception Up_error;;

val up : (term * term) list -> (term * term) list -> (term * term) list;;


(* $Id: unif.mli,v 1.4 1999/06/29 07:48:11 loiseleu Exp $ *)
