(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                general.ml                                *)
(****************************************************************************)

open Std;;

(*** glue : make the concatenation of the lists of a lists list *****)

let rec glue = function
    (l::ll) -> union l (glue ll)
  | [] -> [];;

(*** disjoint l1 l2 : returns true if the lists l1 and l2 are disjoint ******)

let disjoint l1 l2 = 
  let rec disjoint_rec = function
      (a::ll1) -> if List.mem a l2 then false else disjoint_rec ll1
    | [] -> true
  in disjoint_rec l1;;

(*** such_that : 'a list -> ('a -> bool) -> 'a list *******)

let such_that l p = 
  let rec such_rec = function
      a::ll -> if (p a) then a::(such_rec ll) else such_rec ll
    | [] -> []
  in such_rec l
;;

(* $Id: general.ml,v 1.4 1999/06/29 07:48:10 loiseleu Exp $ *)
