(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                Equality.v                                *)
(****************************************************************************)

Declare ML Module "Equality".

Grammar vernac orient_rule:=
   lr ["LR"] -> ["LR"]
  |rl ["RL"] -> ["RL"]
with rule_list: List :=
   single_rlt [ comarg($com) orient_rule($ort) ] ->
     [(VERNACARGLIST $com $ort)]
  |recursive_rlt [ comarg($com) orient_rule($ort) rule_list($tail)] ->
    [(VERNACARGLIST $com $ort) ($LIST $tail)]
with base_list: List :=
   single_blt [identarg($rbase) "[" rule_list($rlt) "]"] ->
     [(VERNACARGLIST $rbase ($LIST $rlt))]
  |recursive_blt [identarg($rbase) "[" rule_list($rlt) "]"
    base_list($blt)] ->
    [(VERNACARGLIST $rbase ($LIST $rlt)) ($LIST $blt)]
with vernac:=
   addrule ["HintRewrite" base_list($blt) "."] ->
     [(HintRewrite ($LIST $blt))].

Grammar tactic list_tactics: List :=
   single_lt [tactic($tac)] -> [$tac]
  |recursive_lt [tactic($tac) "|" list_tactics($tail)] ->
    [$tac ($LIST $tail)]

with step_largs: List :=
   nil_step [] -> []
  |solve_step ["with" "Solve"] -> [(REDEXP (SolveStep))]
  |use_step ["with" "Use"] -> [(REDEXP (Use))]
  |all_step ["with" "All"] -> [(REDEXP (All))]

with rest_largs: List :=
   nil_rest [] -> []
  |solve_rest ["with" "Solve"] -> [(REDEXP (SolveRest))]
  |cond_rest ["with" "Cond"] -> [(REDEXP (Cond))]

with autorew_largs: List :=
   step_arg ["Step" "=" "[" list_tactics($ltac) "]" step_largs($slargs)] ->
    [(REDEXP (Step ($LIST $ltac))) ($LIST $slargs)]
  |rest_arg ["Rest" "=" "[" list_tactics($ltac) "]" rest_largs($llargs)] ->
    [(REDEXP (Rest ($LIST $ltac))) ($LIST $llargs)]
  |depth_arg ["Depth" "=" numarg($dth)] ->
    [(REDEXP (Depth $dth))]

with list_args_autorew: List :=
   nil_laa [] -> []
  |recursive_laa [autorew_largs($largs) list_args_autorew($laa)] ->
    [($LIST $largs) ($LIST $laa)]

with hintbase_list: List :=
  nil_hintbase [] -> []
| base_by_name [identarg($id) hintbase_list($tail)] -> 
       [ (REDEXP (ByName $id)) ($LIST $tail)]
| explicit_base ["[" hintbase($b) "]" hintbase_list($tail)] -> 
       [(REDEXP (Explicit ($LIST $b))) ($LIST $tail) ]

with hintbase: List := 
  onehint_lr [ comarg($c) "LR" ] -> [(REDEXP (LR $c))]
| onehint_rl  [ comarg($c) "RL" ] -> [(REDEXP (RL $c))]
| conshint_lr [ comarg($c) "LR" hintbase($tail)] -> [(REDEXP (LR $c)) ($LIST $tail)]
| conshint_rl [ comarg($c) "RL" hintbase($tail)] -> [(REDEXP (RL $c)) ($LIST $tail)]

with simple_tactic := 
 AutoRewrite [ "AutoRewrite" "[" hintbase_list($lbase) "]"
  list_args_autorew($laa)] ->
  [(AutoRewrite (REDEXP (BaseList ($LIST $lbase))) ($LIST $laa))].

Grammar tactic simple_tactic :=
  replace [ "Replace" comarg($c1) "with" comarg($c2) ] -> [(Replace $c1 $c2)]

| deqhyp   [ "Simplify_eq" identarg($id) ] -> [(DEqHyp $id)]
| deqconcl [ "Simplify_eq" ] -> [(DEqConcl)]

| discr_id [ "Discriminate" identarg($id) ] -> [(DiscrHyp $id)]
| discr    [ "Discriminate" ] -> [(Discr)]

| inj    [ "Injection" ] -> [(Inj)]
| inj_id [ "Injection" identarg($id) ] -> [(InjHyp $id)]

| rewriteLR [ "Rewrite" "->" comarg_binding_list($cl) ] -> [(RewriteLR ($LIST $cl))]
| rewriteRL [ "Rewrite" "<-" comarg_binding_list($cl) ] -> [(RewriteRL ($LIST $cl))]
| rewrite [ "Rewrite" comarg_binding_list($cl) ] -> [(RewriteLR ($LIST $cl))]

| condrewriteLR [ "Conditional" tactic_com($tac) "Rewrite" "->" comarg_binding_list($cl) ] -> [(CondRewriteLR (TACTIC $tac) ($LIST $cl))]
| condrewriteRL [ "Conditional" tactic_com($tac) "Rewrite" "<-" comarg_binding_list($cl) ] -> [(CondRewriteRL (TACTIC $tac) ($LIST $cl))]
| condrewrite [ "Conditional" tactic_com($tac) "Rewrite" comarg_binding_list($cl) ] -> [(CondRewriteLR (TACTIC $tac) ($LIST $cl))]

| rewrite_in [ "Rewrite" comarg_binding_list($cl) "in" identarg($h) ]
       -> [(RewriteLRin $h ($LIST $cl))]
| rewriteRL_in [ "Rewrite" "->" comarg_binding_list($cl) "in" identarg($h) ]
       -> [(RewriteLRin $h ($LIST $cl))]
| rewriteLR_in [ "Rewrite" "<-" comarg_binding_list($cl) "in" identarg($h) ]
       -> [(RewriteRLin $h ($LIST $cl))]

| condrewriteLRin 
  [ "Conditional" tactic_com($tac) "Rewrite" "->" comarg_binding_list($cl) 
	"in" identarg($h) ] ->
	   [(CondRewriteLRin (TACTIC $tac) $h ($LIST $cl))]
| condrewriteRLin 
  [ "Conditional" tactic_com($tac) "Rewrite" "<-" comarg_binding_list($cl) 
	"in" identarg($h)] ->
  	   [(CondRewriteRLin (TACTIC $tac) $h ($LIST $cl))]
| condrewritein 
  [ "Conditional" tactic_com($tac) "Rewrite" comarg_binding_list($cl) "in" identarg($h) ] 
        -> [(CondRewriteLRin (TACTIC $tac) $h ($LIST $cl))]

| DRewriteLR [ "Dependent" "Rewrite" "->" identarg($id) ]
       -> [(SubstHypInConcl_LR $id)]
| DRewriteRL [ "Dependent" "Rewrite" "<-" identarg($id) ]
       -> [(SubstHypInConcl_RL $id)]

| cutrewriteLR [ "CutRewrite" "->" comarg($eqn) ] -> [(SubstConcl_LR $eqn)]
| cutrewriteLRin [ "CutRewrite" "->" comarg($eqn) "in" identarg($id) ]
      -> [(SubstHyp_LR $eqn $id)]
| cutrewriteRL [ "CutRewrite" "<-" comarg($eqn) ] -> [(SubstConcl_RL $eqn)]
| cutrewriteRLin [ "CutRewrite" "<-" comarg($eqn) "in" identarg($id) ]
      -> [(SubstHyp_RL $eqn $id)].

Syntax tactic level 0:
  replace [(Replace $c1 $c2)] -> ["Replace " $c1 [1 1] "with " $c2]

| deqhyp [(DEqHyp $id)] -> ["Simplify_eq " $id]
| deqconcl [(DEqConcl)] -> ["Simplify_eq"]

| discr_id [(DiscrHyp $id)] -> ["Discriminate " $id]
| discr [(Discr)] -> ["Discriminate"]

| inj [(Inj)] -> ["Injection"]
| inj_id [(InjHyp $id)] -> ["Injection " $id]

| rewritelr [(RewriteLR $C ($LIST $bl))] -> ["Rewrite " $C (WITHBINDING ($LIST $bl))]
| rewriterl [(RewriteRL $C ($LIST $bl))] -> ["Rewrite <- " $C (WITHBINDING ($LIST $bl))]

| condrewritelr [(CondRewriteLR (TACTIC $tac) $C ($LIST $bl))] -> ["Conditional " $tac [1 1] "Rewrite " $C (WITHBINDING ($LIST $bl))]
| condrewriterl [(CondRewriteRL (TACTIC $tac) $C ($LIST $bl))] -> ["Conditional "  $tac [1 1] "Rewrite <- " $C (WITHBINDING ($LIST $bl))]

| rewriteLR_in [(RewriteLRin $h $c ($LIST $bl))] -> ["Rewrite " $c (WITHBINDING ($LIST $bl)) [1 1] "in " $h]
| rewriteRL_in [(RewriteRLin $h $c ($LIST $bl))] -> ["Rewrite <- " $c (WITHBINDING ($LIST $bl)) [1 1]"in " $h]

| condrewritelrin [(CondRewriteLRin (TACTIC $tac) $h $C ($LIST $bl))] -> ["Conditional " $tac [1 1] "Rewrite " $C (WITHBINDING ($LIST $bl)) [1 1] "in " $h]
| condrewriterlin [(CondRewriteRLin (TACTIC $tac) $h $C ($LIST $bl))] -> ["Conditional "  $tac [1 1] "Rewrite <- " $C (WITHBINDING ($LIST $bl)) [1 1] "in " $h]


| DRewriteLR [(SubstHypInConcl_LR $id)] -> ["Dependent Rewrite -> " $id]
| DRewriteRL [(SubstHypInConcl_RL $id)] -> ["Dependent Rewrite <- " $id]

| cutrewriteLR [(SubstConcl_LR $eqn)] -> ["CutRewrite -> " $eqn]
| cutrewriteLRin [(SubstHyp_LR $eqn $id)]
     -> ["CutRewrite -> " $eqn:E [1 1]"in " $id]

| cutrewriteRL [(SubstConcl_RL $eqn)] -> ["CutRewrite <- " $eqn:E]
| cutrewriteRLin [(SubstHyp_RL $eqn $id)]
      -> ["CutRewrite <- " $eqn:E [1 1]"in " $id]
|nil_consbase [(CONSBASE)] -> []
|single_consbase [(CONSBASE $tac)] -> [[1 0] $tac]
|nil_ortactic [(ORTACTIC)] -> []
|single_ortactic [(ORTACTIC $tac)] -> ["|" $tac]
|AutoRewrite [(AutoRewrite $id)] -> ["AutoRewrite " $id]
|AutoRewriteBaseList [(REDEXP (BaseList $ft ($LIST $tl)))] ->
  ["[" $ft (CONSBASE ($LIST $tl)) "]"]
|AutoRewriteStep [(REDEXP (Step $ft ($LIST $tl)))] ->
  [[0 1] "Step=" "[" $ft (ORTACTIC ($LIST $tl)) "]"]
|AutoRewriteRest [(REDEXP (Rest $ft ($LIST $tl)))] ->
  [[0 1] "Rest=" "[" $ft (ORTACTIC ($LIST $tl)) "]"]
|AutoRewriteSolveStep [(REDEXP (SolveStep))] -> ["with Solve"]
|AutoRewriteSolveRest [(REDEXP (SolveRest))] -> ["with Solve"]
|AutoRewriteUse [(REDEXP (Use))] -> ["with Use"]
|AutoRewriteAll [(REDEXP (All))] -> ["with All"]
|AutoRewriteCond [(REDEXP (Cond))] -> ["with Cond"]
|AutoRewriteDepth [(REDEXP (Depth $dth))] -> [[0 1] "Depth=" $dth]
|AutoRewriteByName [(REDEXP (ByName $id))] -> [ $id ]
|AutoRewriteExplicit [(REDEXP (Explicit $l))] -> ["[" $l "]"]
|AutoRewriteLR [(REDEXP (LR $c))] -> [ $c "LR" ]
|AutoRewriteRL [(REDEXP (RL $c))] -> [ $c "RL" ]
.

(* $Id: Equality.v,v 1.16 1999/07/06 15:44:42 delahaye Exp $ *)
