(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 mach.mli                                 *)
(****************************************************************************)

open Names
open Generic
open Term
open Impuniv
open Pp
open Evd

val j_val_cast : judgement -> constr
val j_val_only : judgement -> constr

(* MACHINE WITH INFORMATION *)

(* Utilise par program.ml *)
val infexemeta : 'c evar_map -> (int * (constr * information)) list
  -> (environment * environment) -> constr
    -> (judgement * information)

val infexecute_type : 'c evar_map
  -> (context * context)
    -> constr -> (type_judgement * information)
val infexecute : 'c evar_map
  -> (context * context)
    -> constr -> (judgement * information)


val fsign_of_sign : 'c evar_map -> context -> context

(* MACHINE WITHOUT INFORMATION *)

val fexecute_type : 'c evar_map -> context -> constr -> type_judgement
val fexecute : 'c evar_map -> context -> constr -> judgement

val execute_rec_type : 'c evar_map -> environment -> constr -> type_judgement
val execute_rec : 'c evar_map -> environment -> constr -> judgement

val type_of      : 'c evar_map -> context -> constr -> constr
val type_of_type : 'c evar_map -> context -> constr -> constr

val unsafe_type_of      : 'c evar_map -> environment -> constr -> constr
val unsafe_type_of_type : 'c evar_map -> environment -> constr -> constr
val unsafe_sort_of      : 'c evar_map -> environment -> constr -> sorts

(*
val push_rel     : 'c evar_map -> name * constr -> environment -> environment
*)

val type_of_rel : 'c evar_map -> environment -> constr -> constr

(* Pour gelim, inv, leminv *)
val castify_sign : 'c evar_map -> constr signature -> context
val castify_env : 'c evar_map -> (type_judgement, constr) env -> environment


val fexemeta_type :
  'c evar_map -> (int * constr) list -> environment
    -> constr -> type_judgement
val fexemeta : 'c evar_map -> (int * constr) list -> environment
  -> constr -> judgement

(* Inutile et plus compatible
val fvar_type : 'c evar_map -> (constr signature * constr signature)
  -> constr -> constr
*)
val core_fmachine_type : bool -> 'c evar_map * (int * constr) list
  -> environment -> constr -> type_judgement
val core_fmachine : bool -> 'c evar_map * (int * constr) list
  -> environment -> constr -> judgement


val core_infmachine :
  'c evar_map * ((int * constr) list * (int * information) list)
  -> environment -> environment -> constr -> information
val add_inf_rel : name * information -> environment -> environment

(* MACHINE WITH UNIVERSES *)
val instantiate_universes : constr -> constr

val fexecute_type_with_univ :
  'c evar_map -> context ->
    section_path -> constr -> universes * type_judgement
val fexecute_with_univ :
  'c evar_map -> context ->
    section_path -> constr -> universes * judgement
val infexecute_with_univ :
  'c evar_map -> (context * context) ->
    section_path -> constr -> universes * (judgement * information)
val infexecute_type_with_univ :
  'c evar_map -> (context * context) ->
    section_path -> constr -> universes * (type_judgement * information)

(* $Id: mach.mli,v 1.10 1999/11/03 19:56:36 herbelin Exp $ *)
