(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               nbtermdn.ml                                *)
(****************************************************************************)

open Std;;
open More_util;;
open Names;;
open Vectops;;
open Generic;;
open Term;;
open Himsg;;
open Pp;;

open Libobject;;
open Library;;

(* 
   Named, bounded-depth, term-discrimination nets.
   Implementation:
   Term-patterns are stored in discrimination-nets, which are
   themselves stored in a hash-table, indexed by the first label.
   They are also stored by name in a table on-the-side, so that we can
   override them if needed.

 *)

(* 
   The former comments are from Chet.
   See the module dn.ml for further explanations.
   Eduardo (5/8/97)
*)

type 'na args =
    {name_ord : 'na -> 'na -> int};;

type ('na,'a) t =
    ('na,constr * 'a) Fmavm.t *
    (Termdn.lbl option,'a Btermdn.t) Mhm.t
;;

type ('na,'a) frozen_t =
    ('na,constr * 'a) Fmavm.frozen_t *
    (Termdn.lbl option,'a Btermdn.t) Mhm.frozen_t
;;

let create a =
    (Fmavm.create(a.name_ord,17),
     Mhm.create 17)
;;


let get_dn dnm hkey =
    try Mhm.map dnm hkey
    with Not_found -> Btermdn.create ()
;;

let add ((nm,dnm):('na,'a) t) (na,(pat,valu)) =
    let hkey = option_app fst (Termdn.constr_pat_discr pat)
    in (Fmavm.add nm (na,(pat,valu));
        Mhm.remap dnm hkey (Btermdn.add (get_dn dnm hkey) (pat,valu)))
;;

let rmv ((nm,dnm):('na,'a) t) na =
let (pat,valu) = Fmavm.map nm na in
let hkey = option_app fst (Termdn.constr_pat_discr pat)
in (Fmavm.rmv nm na;
    Mhm.remap dnm hkey (Btermdn.rmv (get_dn dnm hkey) (pat,valu)))
;;

let in_dn (nm,dnm) na = Fmavm.in_dom nm na;;

let remap (ndn:('na,'a) t) na (pat,valu) =
    rmv ndn na;
    add ndn (na,(pat,valu))
;;

let lookup (nm,dnm) valu =
let hkey = option_app fst (Termdn.constr_val_discr valu)
in try Btermdn.lookup (Mhm.map dnm hkey) valu
   with Not_found -> []
;;

let app f (nm,dnm) = Fmavm.app f nm;;

let dnet_depth = Btermdn.dnet_depth;;

let freeze (nm,dnm) = (Fmavm.freeze nm,Mhm.freeze dnm);;
let unfreeze (fnm,fdnm) (nm,dnm) =
    (Fmavm.unfreeze fnm nm;
     Mhm.unfreeze fdnm dnm)
;;

let empty (nm,dnm) = (Fmavm.empty nm;
                      Mhm.empty dnm)
;;

let to2Lists (table:('na,'a)t) = ((Fmavm.toList (fst table)),(Mhm.toList (snd table)))
;;

(* $Id: nbtermdn.ml,v 1.9 1999/06/29 07:47:41 loiseleu Exp $ *)
