(* $Id: q_CoqAst.ml4,v 1.6 1998/05/13 15:14:24 filliatr Exp $ *)
(* camlp4r q_MLast.cmo *)

value dummy_loc = (0,0);
value is_meta s = String.length s > 0 && s.[0] == '$';

value not_impl name x =
  let desc =
    if Obj.is_block (Obj.repr x) then
      "tag = " ^ string_of_int (Obj.tag (Obj.repr x))
    else "int_val = " ^ string_of_int (Obj.magic x)
  in
  failwith ("<Q_CoqAst." ^ name ^ ", not impl: " ^ desc)
;

value purge_str s =
  if String.length s == 0 || s.[0] <> '$' then s
  else String.sub s 1 (String.length s - 1)
;


value anti loc x =
  let e =
    let loc = (1, snd loc - fst loc) in <:expr< $lid:purge_str x$ >>
  in
  <:expr< $anti:e$ >>
;

value rec expr_of_ast =
  fun
  [ CoqAst.Nvar loc id when is_meta id -> anti loc id
  | CoqAst.Id loc id when is_meta id -> anti loc id
  | CoqAst.Node _ "$VAR" [CoqAst.Nvar loc x] ->
      <:expr< CoqAst.Nvar loc $anti loc x$ >>
  | CoqAst.Node _ "$ID" [CoqAst.Nvar loc x] ->
      <:expr< CoqAst.Id loc $anti loc x$ >>
  | CoqAst.Node _ "$STR" [CoqAst.Nvar loc x] ->
      <:expr< CoqAst.Str loc $anti loc x$ >>
  | CoqAst.Node _ "$SLAM" [CoqAst.Nvar loc idl; y] ->
      <:expr<
        List.fold_right (Pcoq.slam_ast loc) $anti loc idl$ $expr_of_ast y$ >>
  | CoqAst.Node loc nn al ->
      let e = expr_list_of_ast_list al in
      <:expr< CoqAst.Node loc $str:nn$ $e$ >>
  | CoqAst.Nvar loc id -> <:expr< CoqAst.Nvar loc $str:id$ >>
  | CoqAst.Slam loc None a ->
      <:expr< CoqAst.Slam loc None $expr_of_ast a$ >>
  | CoqAst.Slam loc (Some s) a ->
      let se = if is_meta s then anti loc s else <:expr< $str:s$ >> in
      <:expr< CoqAst.Slam loc (Some $se$) $expr_of_ast a$ >>
  | CoqAst.Num loc i -> <:expr< CoqAst.Num loc $int:string_of_int i$ >>
  | CoqAst.Id loc id -> <:expr< CoqAst.Id loc $str:id$ >>
  | CoqAst.Str loc str -> <:expr< CoqAst.Str loc $str:str$ >>
  | CoqAst.Path loc sl s ->
      let e = expr_list_of_var_list sl in
      <:expr< CoqAst.Path loc $e$ $str:s$ >> 
  | CoqAst.Dynamic _ _ ->
      failwith "Q_CoqAst: dynamic: not implemented" ]
and expr_list_of_ast_list al =
  List.fold_right
    (fun a e2 ->
       match a with
       [ (CoqAst.Node _ "$LIST" [CoqAst.Nvar locv pv]) ->
           let e1 = anti locv pv in
           let loc = (fst(MLast.loc_of_expr e1), snd(MLast.loc_of_expr e2)) in
             <:expr< ( $lid:"@"$ $e1$ $e2$) >>
       | _ ->
           let e1 = expr_of_ast a in
           let loc = (fst(MLast.loc_of_expr e1), snd(MLast.loc_of_expr e2)) in
       <:expr< [$e1$ :: $e2$] >> ])
    al (let loc = dummy_loc in <:expr< [] >>)
and expr_list_of_var_list sl =
  let loc = dummy_loc in
  List.fold_right
    (fun s e2 ->
       let e1 = if is_meta s then anti loc s else <:expr< $str:s$ >> in
       let loc = (fst (MLast.loc_of_expr e1), snd (MLast.loc_of_expr e2)) in
       <:expr< [$e1$ :: $e2$] >>)
    sl <:expr< [] >>
;

value rec patt_of_expr e =
  let loc = MLast.loc_of_expr e in
  match e with
  [ <:expr< $e1$.$e2$ >> -> <:patt< $patt_of_expr e1$.$patt_of_expr e2$ >>
  | <:expr< $e1$ $e2$ >> -> <:patt< $patt_of_expr e1$ $patt_of_expr e2$ >>
  | <:expr< loc >> -> <:patt< _ >>
  | <:expr< $lid:s$ >> -> <:patt< $lid:s$ >>
  | <:expr< $uid:s$ >> -> <:patt< $uid:s$ >>
  | <:expr< $str:s$ >> -> <:patt< $str:s$ >>
  | <:expr< $anti:e$ >> -> <:patt< $anti:patt_of_expr e$ >>
  | _ -> not_impl "patt_of_expr" e ]
  
;

value f e =
  let ee s =
    expr_of_ast (Pcoq.Gram.Entry.parse e
                     (Pcoq.Gram.parsable (Stream.of_string s)))
  in
  let ep s = patt_of_expr (ee s) in
  Quotation.ExAst (ee, ep)
;

Quotation.add "command" (f Pcoq.Command.command_eoi);
Quotation.add "tactic" (f Pcoq.Tactic.tactic_eoi);
Quotation.add "vernac" (f Pcoq.Vernac.vernac_eoi);
Quotation.add "ast" (f Pcoq.Prim.ast_eoi);
Quotation.default.val := "command";
