(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               egrammar.mli                               *)
(****************************************************************************)

open CoqAst
open Ast
open Pcoq
open Extend

type frozen_t

val freeze : unit -> frozen_t
val unfreeze : frozen_t -> unit
val init : unit -> unit

val extend_grammar : grammar_command -> unit

val remove_rule : (string * gram_universe) -> typed_entry -> grammar_rule ->
  unit
val remove_entry : (string * gram_universe) -> grammar_entry -> unit
val remove_grammar : grammar_command -> unit


(* $Id: egrammar.mli,v 1.3 1999/06/29 07:47:29 loiseleu Exp $ *)
