(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                stock.mli                                 *)
(****************************************************************************)

open Pp;;
open Names;;

type 'a stock;;
type module_mark;;
type 'a stocked;;

type 'a stock_args =
    {name : string;
     proc : string -> 'a};;

val make_stock : 'a stock_args -> 'a stock;;
val make_module_marker : 'a stock -> string list -> module_mark;;
val stock : 'a stock -> module_mark -> string -> 'a stocked;;
val retrieve : 'a stock -> 'a stocked -> 'a;;

(*value inspect : 'a stock -> std_ppcmds;;*)

(* $Id: stock.mli,v 1.5 1999/06/29 07:47:27 loiseleu Exp $ *)
