(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                initial.ml                                *)
(****************************************************************************)

open Std;;
open Pp;;

(* A list of the areas of the system where "unsafe" operation
 * has been requested *)
let unsafe_list = ref ([] : string list);;
let add_unsafe s = unsafe_list := add_set s !unsafe_list;;
let is_unsafe s = List.mem s !unsafe_list;;

(* implicit arguments *)

let iMPLCIT_ARGS = ref false;;
let make_implicit_args flag = iMPLCIT_ARGS:=flag;;
let is_implicit_args() = !iMPLCIT_ARGS;;

let implicitely f x =
  let oimplicit = is_implicit_args() in
  try make_implicit_args true;
      let rslt = f x in (make_implicit_args oimplicit; rslt)
  with e -> (make_implicit_args oimplicit; raise e)
;;

(* implicit arguments *)

let mes_ambig = ref true;;
let make_mes_ambig flag = mes_ambig:=flag;;
let is_mes_ambig() = !mes_ambig;;

let without_mes_ambig f x =
  let old = is_mes_ambig() in
  try make_mes_ambig false;
      let rslt = f x in (make_mes_ambig old; rslt)
  with e -> (make_mes_ambig old; raise e)
;;


(* Silent *)
let sILENT = ref false;;
let make_silent flag = sILENT:=flag; ();;
let is_silent () = !sILENT;;

let silently f x =
  let osilent = is_silent() in
  try make_silent true;
      let rslt = f x in (make_silent osilent; rslt)
  with e -> (make_silent osilent; raise e)
;;

(* Time stamps *)
let stamp_ctr = ref 0;;
let new_stamp () = (incr stamp_ctr; !stamp_ctr);;

type 'a timestamped = {stamp : int; ed : 'a};;
let ts_stamp st = st.stamp;;
let ts_mod f st = {stamp = new_stamp();
                        ed = f st.ed};;
let ts_it st = st.ed;;
let ts_mk v = {stamp = new_stamp();
               ed    = v};;
let ts_eq st1 st2 = (st1.stamp = st2.stamp);;

type 'a idstamped = 'a timestamped;;
let ids_mod f st = {stamp = st.stamp;
                    ed    = f st.ed};;
let ids_it = ts_it;;
let ids_mk = ts_mk;;
let ids_eq = ts_eq;;

(* The goal focused on *)
let fOCUS = ref 0;;
let make_focus n = fOCUS:=n;;
let focus () = !fOCUS;;
let focused_goal () = let n = !fOCUS in if n=0 then 1 else n;;

(* The number of printed hypothesis in a goal *)

let pRINT_HYPS_LIMIT = ref (None : int option);;
let set_print_hyps_limit n = pRINT_HYPS_LIMIT := Some n;;
let unset_print_hyps_limit () = pRINT_HYPS_LIMIT := None;;
let print_hyps_limit () = !pRINT_HYPS_LIMIT;;

(* $Id: initial.ml,v 1.12 1999/07/09 17:57:16 mohring Exp $ *)
