(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               vectops.mli                                *)
(****************************************************************************)
open Std;;

(* Functions on vectors *)

val vect_it : ('a -> 'b -> 'b) -> 'a array -> 'b -> 'b;;
val vect_it2 : ('a -> 'b -> 'c -> 'c) -> 'a array -> 'b array -> 'c -> 'c;;
val it_vect : ('a -> 'b -> 'a) -> 'a -> 'b array -> 'a;;
val it_vect2 : ('a -> 'b -> 'c -> 'a) -> 'a -> 'b array -> 'c array -> 'a;;
val vlnth : 'a array list -> int -> 'a;;
val chop_vect : int -> 'a array -> 'a array * 'a array;;
val safe_chop_vect : int -> 'a array -> 'a array * ('a array, int) union;;
val exists_vect : ('a -> bool) -> 'a array -> bool;;
val exists2_i_vect_LR : (int -> 'a -> 'b -> bool) -> int -> 'a array -> 'b array -> bool;;
val exists2_vect_LR : ('a -> 'b -> bool) -> 'a array -> 'b array -> bool;;
val for_all_vect : ('a -> bool) -> 'a array -> bool;;
val for_all_vect_i : (int -> 'a -> bool) -> int -> 'a array -> bool;;
val for_all2eq_vect : ('a -> 'b -> bool) -> 'a array -> 'b array -> bool;;
val tabulate_vect : (int -> 'a) -> int -> 'a array;;
val app_vect : 'a array -> 'a list -> 'a list;;
val it_vect_from : int -> ('a -> 'b -> 'a) -> 'a -> 'b array -> 'a;;
val vect_it_from : int -> ('a -> 'b -> 'b) -> 'a array -> 'b -> 'b;;
val it_vect2_from : int -> ('a -> 'b -> 'c -> 'a) -> 'a -> 'b array -> 'c array -> 'a;;
val app_tl_vect : 'a array -> 'a list -> 'a list;;
val list_of_tl_vect : 'a array -> 'a list;;
val app_vectpair : 'a array * 'b array -> ('a * 'b) list -> ('a * 'b) list;;
val hd_vect : 'a array -> 'a;;
val tl_vect : 'a array -> 'a array;;
val cons_vect : 'a -> 'a array -> 'a array;;
val car_vect : 'a array -> 'a;;
val cdr_vect : 'a array -> 'a array;;
val cadr_vect : 'a array -> 'a;;
val cddr_vect : 'a array -> 'a array;;
val last_vect : 'a array -> 'a;;
val map2_vect : ('a -> 'b -> 'c) -> 'a array -> 'b array -> 'c array;;
val map3_vect : ('a -> 'b -> 'c -> 'd) -> 'a array -> 'b array -> 'c array -> 'd array;;
val map4_vect : ('a -> 'b -> 'c -> 'd -> 'e) -> 'a array -> 'b array -> 'c array -> 'd array -> 'e array;;
val map_i_vect : (int -> 'a -> 'b) -> int -> 'a array -> 'b array;;
val split_vect : ('a * 'b) array -> 'a array * 'b array;;
val combine_vect_list : 'a array * 'b array -> ('a * 'b) list;;
val map_tl_vect_list : ('a -> 'b) -> 'a array -> 'b list;;
val map_vect_list : ('a -> 'b) -> 'a array -> 'b list;;
val first_vect : ('a -> bool) -> 'a array -> int;;
val vect_index : 'a -> 'a array -> int;;

(* Functions on lists of vectors *)
type 'a vectlist = 'a array list;;
val join_vect : 'a array list -> 'a array;;
val vlist_length : 'a array list -> int;;
val chop_vect_list : int -> 'a array list -> 'a array list * 'a array list;;
val vlitem : 'a array list -> int -> 'a;;
val list_of_vectlist : 'a array list -> 'a list;;

(* Functions on lists of vector fragments *)
type 'a vectstack = ('a array * int) list;;
val vstack1 : 'a array -> ('a array * int) list;;
val push_vstack : 'a array -> ('a array * int) list -> ('a array * int) list;;
val vstack_empty : 'a list -> bool;;
val pop_vstack : ('a array * int) list -> 'a * ('a array * int) list;;
val vstack_length : ('a array * int) list -> int;;
val safe_chop_vfrag : int -> 'a array * int -> ('a array * int) * ('a array * int, int) union;;
val chop_vstack : int -> ('a array * int) list -> ('a array * int) list * ('a array * int) list;;
val join_vstack : ('a array * int) list -> 'a array;;
val map_vstack : ('a -> 'b) -> ('a array * int) list -> ('b array * int) list;;
val map_i_vstack : (int -> 'a -> 'b) -> int -> ('a array * int) list -> ('b array * int) list;;
val map_vstack_list : ('a -> 'b) -> ('a array * int) list -> 'b list;;
val for_all_vstack : ('a -> bool) -> ('a array * int) list -> bool;;
val for_all2eq_vstack : ('a -> 'b -> bool) -> ('a array * int) list -> ('b array * int) list -> bool;;
val concat_vstack : 'a list -> 'a list -> 'a list;;

(* $Id: vectops.mli,v 1.5 1999/06/29 07:47:22 loiseleu Exp $ *)
