(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 tlm.mli                                  *)
(****************************************************************************)

type ('a,'b) t;;

val create : unit -> ('a,'b) t;;

(* Work on labels, not on paths *)

val map : ('a,'b) t -> 'a -> ('a,'b) t;;
val xtract : ('a,'b) t -> 'b list;;
val dom : ('a,'b) t -> 'a list;;
val in_dom : ('a,'b) t -> 'a -> bool;;

(* Work on paths, not labels *)

val add : ('a,'b) t -> 'a list * 'b -> ('a,'b) t;;
val rmv : ('a,'b) t -> ('a list * 'b) -> ('a,'b) t;;

val app : (('a list * 'c) -> unit) -> ('a,'c) t -> unit;;
val toList : ('a,'b) t -> ('a list * 'b) list;;
(*value rng : ('a,'b) t -> 'b list;;*)
(*value in_rng : ('a,'b) t -> 'b -> bool;;*)

(* $Id: tlm.mli,v 1.7 1999/06/29 07:47:21 loiseleu Exp $ *)
