(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 std.mli                                  *)
(****************************************************************************)

open Pp

exception Anomaly of string * std_ppcmds  (* System errors *)
val anomaly : string -> 'a
val anomalylabstrm : string -> std_ppcmds -> 'a

exception UserError of string * std_ppcmds (* User errors *)
val error : string -> 'a
val errorlabstrm : string -> std_ppcmds -> 'a

val ref_app : ('a -> 'b) -> 'a ref -> 'b ref

val comp : ('a -> 'b) -> ('c -> 'a) -> 'c -> 'b

val repeat : int -> ('a -> 'b) -> 'a -> unit
val fst3 : ('a * 'b * 'c) -> 'a

val modify_vect : ('a -> 'a) -> 'a array -> unit
val it_vect : ('a -> 'b -> 'a) -> 'a -> 'b array -> 'a
val map_vect_list: ('a -> 'b) -> 'a array -> 'b list

val explode : string -> string list
val implode : string list -> string
val explode_ascii : string -> int list
val sep_last : 'a list -> 'a * 'a list
val words : string -> string list
val scan_string : string -> string -> int -> int
val compare_strings: string -> string -> int
val break_string : string -> string -> string list
val skip_string : char list -> string -> string
val skip_space_return : string -> string
val first_n_string : int -> string -> string
val last_n_string : int -> string -> string

val index : 'a -> 'a list -> int
val car : 'a list -> 'a
val cdr : 'a list -> 'a list
val cddr : 'a list -> 'a list
val cdddr : 'a list -> 'a list
val safe_cdr : 'a list -> 'a list
val safe_cddr : 'a list -> 'a list
val safe_cdddr : 'a list -> 'a list
val cadr : 'a list -> 'a
val except : 'a -> 'a list -> 'a list
val except_assoc : 'a -> ('a * 'b) list -> ('a * 'b) list
val try_find : ('a -> 'b) -> 'a list -> 'b
val try_find_i : (int -> 'a -> 'b) -> int -> 'a list -> 'b
val for_all_i : (int -> 'a -> bool) -> int -> 'a list -> bool
val for_all2 : ('a -> 'b -> bool) -> 'a list -> 'b list -> bool
val for_all2eq : ('a -> 'b -> bool) -> 'a list -> 'b list -> bool
val filter : ('a -> bool) -> 'a list -> 'a list
val chop_list  : int -> 'a list -> 'a list * 'a list
val split_list : int -> 'a list -> 'a list * 'a * 'a list ;;
val splitby   : ('a -> bool) -> 'a list -> 'a list * 'a list
val iterate : ('a -> 'a) -> int -> 'a -> 'a
val map_i : (int -> 'a -> 'b) -> int -> 'a list -> 'b list
val map2_i : (int -> 'a -> 'b -> 'c) -> int -> 'a list -> 'b list -> 'c list
val app_i : (int -> 'a -> 'b) -> int -> 'a list -> unit
val it_list_i : (int -> 'a -> 'b -> 'a) -> int -> 'a -> 'b list -> 'a
val rev_append : 'a list -> 'a list -> 'a list
val last : 'a list -> 'a
val firstn : int -> 'a list -> 'a list
val lastn : int -> 'a list -> 'a list

(* Maps f on the sublist of l where f does not raise an exception Failure _ *)
(* For example, if (f x2) and (f x4) both raise the exception Failure _
    map_succed f [x1; x2; x3; x4; x5; x6] 
  evaluates to [f x1; f X3; f x5; f x6] *)
val map_succeed : ('a -> 'b) -> 'a list -> 'b list
(* Like map_succed
   raises Invalid_argument if lists does not have the same length *)
val map_succeed2 : ('a -> 'b -> 'c) -> 'a list -> 'b list -> 'c list
(* Like map_succed, but with the exception Match_failure *)
val map_succeed_match : ('a -> 'b) -> 'a list -> 'b list
val do_listRL : ('a -> unit) -> 'a list -> unit
val join_map_list : ('a -> 'b list) -> 'a list -> 'b list
val prefix_of : 'a list -> 'a list -> bool
val share_tails : 'a list -> 'a list -> 'a list * 'a list * 'a list
val fold_right_one : ('a -> 'b -> 'b) -> 'a list -> 'b -> ('a -> 'b) -> 'b
val distinct : 'a list -> bool

(* [map_append f [x1; ...; xn]] returns [(f x1)@(f x2)@...@(f xn)] *)
val map_append : ('a -> 'b list) -> 'a list -> 'b list;;
(* raises [Invalid_argument] if the two lists don't have the same length *)
val map_append2 : ('a -> 'b -> 'c list) -> 'a list -> 'b list -> 'c list
 
val interval : int -> int -> int list
val range : int -> int list
val push : 'a list ref -> 'a -> unit
val pop : 'a list ref -> unit
val top : 'a list ref -> 'a
val truncate : int -> 'a list ref -> unit

val hash_clear : 'a list array -> unit
val hash_assoc : 'a -> ('a * 'b) list array -> 'b
val hash_remove_assoc : 'a * 'b -> ('a * 'b) list array -> unit
val hash_add_assoc : 'a * 'b -> ('a * 'b) list array -> unit

type ('a,'b) union = Inl of 'a | Inr of 'b
val outl : ('a,'b) union -> 'a
val outr : ('a,'b) union -> 'b

val lexico : ('a -> 'a -> int) -> ('a list -> 'a list -> int)
val rev_lexico : ('a -> 'a -> int) -> ('a list -> 'a list -> int)

val union_exn : ('a -> 'b) -> 'a -> ('b,exn) union
val compare : string -> ('b -> 'b -> bool) -> ('a -> std_ppcmds)
                     -> ('a -> 'b) -> ('a -> 'b) -> 'a -> 'b

val tabulate_list : (int -> 'b) -> int -> 'b list
val list_assign : 'a list -> int -> 'a -> 'a list

(************************************************************************)
(* sets operations on lists;                                            *)
(* for an abstract and baltree version of sets, use module Set          *)

val uniquize : 'a list -> 'a list          (* remove redundant elements *)
val make_set : 'a list -> 'a list                (* synonym of uniquize *)
val add_set  : 'a -> 'a list -> 'a list           (* add if not present *)
val rmv_set  : 'a -> 'a list -> 'a list

val intersect : 'a list -> 'a list -> 'a list
val union     : 'a list -> 'a list -> 'a list
val union2    : 'a list -> 'a list -> 'a list  (* optim. for large sets *)
val unionq    : 'a list -> 'a list -> 'a list   (* with == instead of = *)
val diff_set  : 'a list -> 'a list -> 'a list
val subtract  : 'a list -> 'a list -> 'a list    (* synonym of diff_set *)
val subtractq : 'a list -> 'a list -> 'a list   (* with == instead of = *)
val symdiff   : 'a list -> 'a list -> 'a list

val subset    : 'a list -> 'a list -> bool
val same_members : 'a list -> 'a list -> bool

(* [choose p l] returns an element [x] in [l] such that [(p x)=true]
   if there is at least one; otherwise raise Not_found *)

val choose : ('a -> bool) -> 'a list -> 'a

module Listset :
  sig
    type 'a t
    val subset   : 'a t -> 'a t -> bool
    val add      : 'a -> 'a t -> 'a t
    val rmv      : 'a -> 'a t -> 'a t
    val map      : ('a -> 'b) -> 'a t -> 'b t
    val mem      : 'a -> 'a t -> bool
    val uniquize : 'a list -> 'a t
    val subset   : 'a t -> 'a t -> bool
    val equal    : 'a t -> 'a t -> bool
    val elements : 'a t -> 'a list
    val for_all  : ('a -> bool) -> 'a t -> bool
  end

(* $Id: std.mli,v 1.18 1999/06/29 07:47:20 loiseleu Exp $ *)
