(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 mhb.mli                                  *)
(****************************************************************************)

(* A reference to a bijection (like bij).
   Implementations by hashtabl. *)

type ('a,'b) t;;
type ('a,'b) frozen_t;;

val create : int -> ('a,'b) t;;
val map : ('a,'b) t -> 'a -> 'b;;
val pam : ('a,'b) t -> 'b -> 'a;;
val dom : ('a,'b) t -> 'a list;;
val rng : ('a,'b) t -> 'b list;;
val in_dom : ('a,'b) t -> 'a -> bool;;
val in_rng : ('a,'b) t -> 'b -> bool;;
val app : (('a * 'c) -> 'b) -> ('a,'c) t -> unit;;
val toList : ('a,'b) t -> ('a * 'b) list;;

val add : ('a,'b) t -> 'a * 'b -> unit;;
val rmv : ('a,'b) t -> 'a -> unit;;

(*value remap : ('a,'b) t -> 'a -> 'b -> ('a,'b) t;;*)

val freeze : ('a,'b) t -> ('a,'b) frozen_t;;
val unfreeze : ('a,'b) frozen_t -> ('a,'b) t -> unit;;
val set_meanlen : ('a,'b) t -> int -> unit;;

(* $Id: mhb.mli,v 1.7 1999/06/29 07:47:18 loiseleu Exp $ *)
