(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               listmap.mli                                *)
(****************************************************************************)

type ('a,'b) t = ('a * 'b) list;;

(* A listmap is a map from 'a to 'b implemented by lists *)

val create : unit -> ('a,'b) t;;
val map : ('a,'b) t -> 'a -> 'b;;
val dom : ('a,'b) t -> 'a list;;
val rng : ('a,'b) t -> 'b list;;
val in_dom : ('a,'b) t -> 'a -> bool;;
val in_rng : ('a,'b) t -> 'b -> bool;;
val inv : ('a,'b) t -> 'b -> 'a list;;
val add : ('a,'b) t -> 'a * 'b -> ('a,'b) t;;
val rmv : ('a,'b) t -> 'a -> ('a,'b) t;;
val remap : ('a,'b) t -> 'a -> 'b -> ('a,'b) t;;
val app : (('a * 'c) -> unit) -> ('a,'c) t -> unit;;
val toList : ('a,'b) t -> ('a * 'b) list;;
val for_all2_list : ('a -> 'b -> bool) -> 'a list -> 'b list -> bool ;;
val map_append : ('a -> 'b list) -> 'a list -> 'b list;;
val split_list : int -> 'a list -> 'a list * 'a * 'a list ;;
val map2_append : ('a -> 'b -> 'c) -> 'a list -> 'b list -> 'c list;;

(* $Id: listmap.mli,v 1.9 1999/06/29 07:47:18 loiseleu Exp $ *)
