(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                  avs.ml                                  *)
(****************************************************************************)

type 'a t = 'a Coq_set.t;;

let add s e = Coq_set.add e s;;
let rmv s e = Coq_set.remove e s;;
let memb s e = Coq_set.mem e s;;
let intersect = Coq_set.inter;;
let union = Coq_set.union;;
let diff = Coq_set.diff;;
let symdiff l1 l2 = diff(union l1 l2) (intersect l1 l2);;
let subset l1 l2 = List.for_all (memb l2) (Coq_set.elements l1);;
let equal = Coq_set.equal;;
let mt = Coq_set.empty;;

exception Caught;;
let exists p s =
    try (Coq_set.iter (fun e -> if p e then raise Caught else ()) s;
         false)
    with Caught -> true
;;

let toList = Coq_set.elements;;

let ofList l = List.fold_left add mt l;;
let is_empty = Coq_set.is_empty;;
let app f s = Coq_set.iter f s;;

(* $Id: avs.ml,v 1.5 1999/06/29 07:47:14 loiseleu Exp $ *)
