use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

print "1..18\n";

my $prog = '
@^@L`@{
@@@^
@@@^
@@
';

my $data = "Hello, World! Today is a great day to test INTERCAL!\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my @foo;

compile Language::INTERCAL 'prog', $prog;
@foo= ();
eval { prog(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print @foo == 1 ? "" : "not ", "ok 2\n";
print $data eq (shift @foo) ? "" : "not ", "ok 3\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo= ();
eval { prog_o(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 4\n";
print @foo == 1 ? "" : "not ", "ok 5\n";
print $data eq (shift @foo) ? "" : "not ", "ok 6\n";

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
@foo= ();
eval { prog_q(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 7\n";
print @foo == 1 ? "" : "not ", "ok 8\n";
print $data eq (shift @foo) ? "" : "not ", "ok 9\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo= ();
eval { prog_p(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 10\n";
print @foo == 1 ? "" : "not ", "ok 11\n";
print $data eq (shift @foo) ? "" : "not ", "ok 12\n";

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
@foo= ();
eval { prog_qp(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 13\n";
print @foo == 1 ? "" : "not ", "ok 14\n";
print $data eq (shift @foo) ? "" : "not ", "ok 15\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo = ();
_run_db(prog_d(\&faa, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 16\n";
print @foo == 1 ? "" : "not ", "ok 17\n";
print $data eq (shift @foo) ? "" : "not ", "ok 18\n";

sub foo {
    push @foo, join('', @_);
}

sub faa {
    $data;
}

