(* camlp4r *)
(***********************************************************************)
(*                                                                     *)
(*                             Camlp4                                  *)
(*                                                                     *)
(*        Daniel de Rauglaudre, projet Cristal, INRIA Rocquencourt     *)
(*                                                                     *)
(*  Copyright 1998 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* $Id: odyl_main.ml,v 2.0 1998/12/01 08:22:16 ddr Exp $ *)

value go = ref (fun () -> ());
value name = ref "odyl";

value first_arg_no_load () =
  loop 1 where rec loop i =
    if i < Array.length Sys.argv then
      match Sys.argv.(i) with
      [ "-I" -> loop (i + 2)
      | "-nolib" -> loop (i + 1)
      | "-where" -> loop (i + 1)
      | "--" -> i + 1
      | s ->
          if Filename.check_suffix s ".cmo"
          || Filename.check_suffix s ".cma" then loop (i + 1)
          else i ]
    else i
;

Arg.current.val := first_arg_no_load () - 1;
