
#define SREAL
#include "atlas_misc.h"
#include "atlas_level1.h"
#include "cblas.h"

void cblas_srotm(const int N, float *X, const int incX, 
                 float *Y, const int incY, const float *P)
{
   if (incX < 0)
   {
      if (incY < 0) ATL_srotm(N, X, -incX, Y, -incY, P);
      else ATL_srotm(N, X+(1-N)*incX, incX, Y, incY, P);
   }
   else if (incY < 0) ATL_srotm(N, X+(N-1)*incX, -incX, Y, -incY, P);
   else ATL_srotm(N, X, incX, Y, incY, P);
}
